/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.openmeta.schema;

import com.alipay.openmeta.common.AvroDecoder;
import com.alipay.openmeta.common.AvroEncoder;
import com.alipay.openmeta.common.Decoder;
import com.alipay.openmeta.common.Encoder;
import com.alipay.openmeta.common.SchemaInfo;
import com.alipay.openmeta.schema.StructSchema;
import org.apache.avro.Schema;

public class AvroSchema<T>
extends StructSchema<T> {
    private Encoder<T> encoder;
    private Decoder<T> decoder;

    public AvroSchema(SchemaInfo schemaInfo) {
        this.encoder = new AvroEncoder(new Schema.Parser().parse(schemaInfo.getSchema()));
        this.decoder = new AvroDecoder(new Schema.Parser().parse(schemaInfo.getSchema()));
    }

    public AvroSchema(SchemaInfo writeSchema, SchemaInfo readSchema) {
        Schema writer = new Schema.Parser().parse(writeSchema.getSchema());
        Schema reader = new Schema.Parser().parse(readSchema.getSchema());
        this.encoder = new AvroEncoder(writer);
        this.decoder = new AvroDecoder(writer, reader);
    }

    @Override
    protected Encoder<T> encoder() {
        return this.encoder;
    }

    @Override
    protected Decoder<T> decoder() {
        return this.decoder;
    }
}

