/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.openmeta.utils;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;

public final class Arguments {
    private Arguments() {
    }

    public static boolean isEmpty(String s) {
        return s == null || s.isEmpty();
    }

    public static boolean isNotEmpty(String s) {
        return !Arguments.isEmpty(s);
    }

    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static <T> boolean isNotEmpty(T[] array) {
        return !Arguments.isEmpty(array);
    }

    public static <T extends Collection<?>> boolean isEmpty(T elements) {
        return elements == null || elements.isEmpty();
    }

    public static <T extends Collection<?>> boolean isNotEmpty(T elements) {
        return !Arguments.isEmpty(elements);
    }

    public static <T extends Map<?, ?>> boolean isEmpty(T elements) {
        return elements == null || elements.isEmpty();
    }

    public static <T extends Map<?, ?>> boolean isNotEmpty(T elements) {
        return !Arguments.isEmpty(elements);
    }

    public static int requirePositive(int value, String name) {
        if (value <= 0) {
            throw new IllegalArgumentException(String.format("%s must be a positive integer, but given %d", name, value));
        }
        return value;
    }

    public static int requireNotNegative(int value, String name) {
        if (value < 0) {
            throw new IllegalArgumentException(String.format("%s must be a positive integer or zero, but given %d", name, value));
        }
        return value;
    }

    public static long requirePositive(long value, String name) {
        if (value <= 0L) {
            throw new IllegalArgumentException(String.format("%s must be a positive integer, but given %d", name, value));
        }
        return value;
    }

    public static long requireNotNegative(long value, String name) {
        if (value < 0L) {
            throw new IllegalArgumentException(String.format("%s must be a positive integer or zero, but given %d", name, value));
        }
        return value;
    }

    public static float requirePositive(float value, String name) {
        if (value <= 0.0f) {
            throw new IllegalArgumentException(String.format("%s must be a positive integer, but given %f", name, Float.valueOf(value)));
        }
        return value;
    }

    public static float requireNotNegative(float value, String name) {
        if (value < 0.0f) {
            throw new IllegalArgumentException(String.format("%s must be a positive integer or zero, but given %f", name, Float.valueOf(value)));
        }
        return value;
    }

    public static String requireNotEmpty(String value, String name) {
        Arguments.requireNotNull(value, name);
        if (value.isEmpty()) {
            throw new IllegalArgumentException(String.format("%s can't be empty", name));
        }
        return value;
    }

    public static boolean isBlank(String src) {
        int len;
        if (src != null && (len = src.length()) != 0) {
            for (int i = 0; i < len; ++i) {
                if (Character.isWhitespace(src.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static ByteBuffer requireNotEmpty(ByteBuffer value, String name) {
        Arguments.requireNotNull(value, name);
        if (!value.hasRemaining()) {
            throw new IllegalArgumentException(String.format("%s can't be empty", name));
        }
        return value;
    }

    public static <T extends Collection<?>> T requireNotEmpty(T elements, String name) {
        Arguments.requireNotNull(elements, name);
        if (elements.isEmpty()) {
            throw new IllegalArgumentException(String.format("empty %s is not allowed", name));
        }
        return elements;
    }

    public static <T> T requireNotNull(T obj, String name) {
        if (obj == null) {
            throw new NullPointerException(String.format("%s is null", name));
        }
        return obj;
    }

    public static <T> T staticCast(Object src) {
        return (T)Arguments.requireNotNull(src, "src");
    }
}

