/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.openmeta.utils;

import com.alipay.sofa.sofamq.com.shade.alibaba.fastjson.JSON;
import com.alipay.sofa.sofamq.com.shade.alibaba.fastjson.TypeReference;
import com.alipay.sofa.sofamq.com.shade.alibaba.fastjson.parser.Feature;
import com.alipay.sofa.sofamq.com.shade.alibaba.fastjson.serializer.JSONSerializer;
import com.alipay.sofa.sofamq.com.shade.alibaba.fastjson.serializer.PropertyFilter;
import com.alipay.sofa.sofamq.com.shade.alibaba.fastjson.serializer.SerializeFilter;
import com.alipay.sofa.sofamq.com.shade.alibaba.fastjson.serializer.SerializeWriter;
import com.alipay.sofa.sofamq.com.shade.alibaba.fastjson.serializer.SerializerFeature;
import java.util.Arrays;
import java.util.List;

public final class JsonUtils {
    public static <T> T unmarshalFromByte(byte[] bytes, Class<T> targetClass) {
        return JSON.parseObject(bytes, targetClass, new Feature[0]);
    }

    public static <T> T unmarshalFromByte(byte[] bytes, TypeReference<T> type) {
        return JSON.parseObject(bytes, type.getType(), new Feature[0]);
    }

    public static byte[] marshalToByte(Object obj) {
        return JSON.toJSONBytes(obj, new SerializerFeature[0]);
    }

    public static byte[] marshalToByte(Object obj, SerializerFeature ... features) {
        return JSON.toJSONBytes(obj, features);
    }

    public static <T> T unmarshalFromString(String json, Class<T> targetClass) {
        return JSON.parseObject(json, targetClass);
    }

    public static String marshalToString(Object obj, boolean prettyFormat) {
        return JSON.toJSONString(obj, prettyFormat);
    }

    public static <T> T unmarshalFromString(String json, TypeReference<T> type) {
        return JSON.parseObject(json, type, new Feature[0]);
    }

    public static String marshalToString(Object obj) {
        return JSON.toJSONString(obj);
    }

    public static String marshalToString(Object obj, SerializerFeature ... features) {
        return JSON.toJSONString(obj, features);
    }

    public static String marshalToString(Object object, SerializeFilter filter, SerializerFeature ... features) {
        return JSON.toJSONString(object, filter, features);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String marshalToString(Object obj, String ... filterFields) {
        final List<String> propertyFilters = Arrays.asList(filterFields);
        SerializeWriter out = new SerializeWriter();
        try {
            JSONSerializer serializer = new JSONSerializer(out);
            serializer.getPropertyFilters().add(new PropertyFilter(){

                @Override
                public boolean apply(Object source, String name, Object value) {
                    return !propertyFilters.contains(name);
                }
            });
            serializer.write(obj);
            String string = out.toString();
            return string;
        }
        finally {
            out.close();
        }
    }
}

