/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.openmeta.utils;

public final class RestfulApiPathUtils {
    private static final String GET_SCHEMA_BY_ID_URL_FORMATTER = "http://%s/schemas/ids/%d";
    private static final String GET_SUBJECT_VERSION_OF_SCHEMA_URL_FORMATTER = "http://%s/schemas/ids/%d/versions";
    private static final String GET_SUBJECTS_URL_FORMATTER = "http://%s/subjects";
    private static final String GET_SCHEMA_VERSIONS_OF_SUBJECT_URL_FORMATTER = "http://%s/subjects/%s/versions";
    private static final String DELETE_SUBJECT_URL_FORMATTER = "http://%s/subjects/%s";
    private static final String GET_SUBJECT_URL_FORMATTER = "http://%s/subjects/%s";
    private static final String GET_SCHEMA_BY_SUBJECT_AND_VERSION_URL_FORMATTER = "http://%s/subjects/%s/versions/%d/schema";
    private static final String REGISTER_SCHEMA_FORMATTER_URL_FORMATTER = "http://%s/subjects/%s/versions";
    private static final String UPDATE_SUBJECT_URL_FORMATTER = "http://%s/subjects/%s";
    private static final String DELETE_SCHEMA_BY_SUBJECT_VERSION_URL_FORMATTER = "http://%s/subjects/%s/versions/%d";
    private static final String CHECK_COMPATIBILITY_URL_FORMATTER = "http://%s/compatibility/subjects/%s/versions/%d";
    private static final String CHECK_CAN_READ_COMPATIBILITY_URL_FORMATTER = "http://%s/compatibility/read/%s";
    private static final String GET_COMPATIBILITY_CONFIG_URL_FORMATTER = "http://%s/config/%s";
    private static final String UPDATE_COMPATIBILITY_CONFIG_URL_FORMATTER = "http://%s/config/%s";
    private static final String SEARCH_SCHEMA_URL_FORMATTER = "http://%s/search/subjects/%s/versions";

    public static String urlOfGetSchemaById(String server, long id) {
        return String.format(GET_SCHEMA_BY_ID_URL_FORMATTER, server, id);
    }

    public static String urlOfGetSubjectAndVersion(String server, long id) {
        return String.format(GET_SUBJECT_VERSION_OF_SCHEMA_URL_FORMATTER, server, id);
    }

    public static String urlOfGetAllSubjects(String server) {
        return String.format(GET_SUBJECTS_URL_FORMATTER, server);
    }

    public static String urlOfGetSchemaVersionsOfSubject(String server, String subject) {
        return String.format("http://%s/subjects/%s/versions", server, subject);
    }

    public static String urlOfDeleteSubject(String server, String subject) {
        return String.format("http://%s/subjects/%s", server, subject);
    }

    public static String urlOfGetSubject(String server, String subject) {
        return String.format("http://%s/subjects/%s", server, subject);
    }

    public static String urlOfGetSchemaBySubjectAndVersion(String server, String subject, int version) {
        return String.format(GET_SCHEMA_BY_SUBJECT_AND_VERSION_URL_FORMATTER, server, subject, version);
    }

    public static String urlOfRegisterSchema(String server, String subject) {
        return String.format("http://%s/subjects/%s/versions", server, subject);
    }

    public static String urlOfUpdateSubject(String server, String subject) {
        return String.format("http://%s/subjects/%s", server, subject);
    }

    public static String urlOfDeleteSchemaBySubjectAndVersion(String server, String subject, long version) {
        return String.format(DELETE_SCHEMA_BY_SUBJECT_VERSION_URL_FORMATTER, server, subject, version);
    }

    public static String urlOfCheckCompatibilityUrl(String server, String subject, long version) {
        return String.format(CHECK_COMPATIBILITY_URL_FORMATTER, server, subject, version);
    }

    public static String urlOfCheckCanReadCompatibilityUrl(String server, String subject) {
        return String.format(CHECK_CAN_READ_COMPATIBILITY_URL_FORMATTER, server, subject);
    }

    public static String urlOfGetCompatibilityUrl(String server, String subject) {
        return String.format("http://%s/config/%s", server, subject);
    }

    public static String urlOfUpdateCompatibility(String server, String subject) {
        return String.format("http://%s/config/%s", server, subject);
    }

    public static String urlOfSearchSchema(String server, String subject) {
        return String.format(SEARCH_SCHEMA_URL_FORMATTER, server, subject);
    }
}

