/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.cloud.auth;

import com.alipay.sofa.cloud.auth.Credentials;
import com.alipay.sofa.cloud.auth.SignAlgorithm;
import com.alipay.sofa.cloud.auth.Signer;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;

public class HmacSHA256Signer
implements Signer {
    public static final Signer INSTANCE = new HmacSHA256Signer();

    @Override
    public String sign(byte[] content, Credentials credentials) {
        Mac mac = SignAlgorithm.HmacSHA256.getMac();
        mac.reset();
        try {
            mac.init(new SecretKeySpec(credentials.getSecretKey().getBytes("UTF-8"), SignAlgorithm.HmacSHA256.toString()));
            byte[] signedBytes = mac.doFinal(content);
            return DatatypeConverter.printBase64Binary((byte[])signedBytes);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

