/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.openmeta.client.addressing;

import com.alipay.openmeta.client.ServerAddressing;
import com.alipay.sofa.openmeta.client.addressing.AntVIPConfiguration;
import com.alipay.sofa.openmeta.client.addressing.AntVIPRefresher;
import com.alipay.sofa.openmeta.client.addressing.GlobalAntVIPRefresher;
import com.alipay.sofa.openmeta.client.utils.SystemUtils;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.AntVipClient;
import com.alipay.sofa.sofamq.org.shade.apache.commons.lang.StringUtils;
import java.net.URI;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AntVIPBasedServerAddressing
implements ServerAddressing {
    private static Pattern shortDomainPattern = Pattern.compile("antvip://(.*/)?[^.]*");
    private static Pattern shortEndpointPattern = Pattern.compile("antvip://([^/]*)");
    private static Pattern longEndpointPattern = Pattern.compile("antvip://([^/]*)/([^/]*)");
    private final String schemaRegistryUrl;
    private final AntVIPConfiguration configuration;
    private volatile List<String> addresses;
    private final AntVIPRefresher.RefreshCallback refreshCallback;

    public AntVIPBasedServerAddressing(String schemaRegistryUrl) {
        this.schemaRegistryUrl = schemaRegistryUrl;
        this.configuration = this.parseAntVIPConfiguration(schemaRegistryUrl);
        this.refreshCallback = new AntVIPRefresher.RefreshCallback(){

            @Override
            public void call(AntVIPConfiguration configuration, List<String> servers) {
                if (servers != null && servers.size() > 0) {
                    AntVIPBasedServerAddressing.this.addresses = servers;
                }
            }
        };
        GlobalAntVIPRefresher.getInstance().register(this.configuration, this.refreshCallback);
    }

    @Override
    public String config() {
        return this.schemaRegistryUrl;
    }

    @Override
    public List<String> addresses() {
        if (this.addresses == null) {
            this.updateAddresses();
        }
        return this.addresses;
    }

    private void updateAddresses() {
        List<String> addresses = GlobalAntVIPRefresher.getInstance().getServers(this.configuration);
        if (addresses != null && addresses.size() > 0) {
            this.addresses = addresses;
        }
    }

    private AntVIPConfiguration parseAntVIPConfiguration(String schemaRegistryUrl) {
        try {
            Matcher longEndpointMatcher;
            Matcher shortEndpointMatcher;
            String env = null;
            String domain = null;
            URI uri = new URI(schemaRegistryUrl);
            if (!"antvip".equalsIgnoreCase(uri.getScheme())) {
                throw new UnsupportedOperationException("unsupport non-antvip config");
            }
            Matcher shortDomainMatcher = shortDomainPattern.matcher(schemaRegistryUrl);
            if (shortDomainMatcher.matches()) {
                if (StringUtils.isBlank(SystemUtils.getLocalDomainName())) {
                    throw new RuntimeException(String.format("short domain schemaRegistryUrl %s in incomplete, cannot find domainname from server.conf", schemaRegistryUrl));
                }
                schemaRegistryUrl = schemaRegistryUrl + "." + SystemUtils.getLocalDomainName();
            }
            if ((shortEndpointMatcher = shortEndpointPattern.matcher(schemaRegistryUrl)).matches()) {
                domain = shortEndpointMatcher.group(1);
            }
            if ((longEndpointMatcher = longEndpointPattern.matcher(schemaRegistryUrl)).matches()) {
                env = longEndpointMatcher.group(1);
                domain = longEndpointMatcher.group(2);
            }
            AntVIPConfiguration configuration = new AntVIPConfiguration();
            configuration.setEnv(env);
            configuration.setDomain(domain);
            return configuration;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("illegal schema registry url config: " + schemaRegistryUrl, e);
        }
    }

    @Override
    public void close() {
        GlobalAntVIPRefresher.getInstance().unregister(this.configuration, this.refreshCallback);
    }

    public void setAntVipClient(AntVipClient antVipClient) {
        GlobalAntVIPRefresher.getInstance().setGlobalAntVipClient(antVipClient);
    }
}

