/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.openmeta.client.addressing;

import com.alipay.sofa.openmeta.client.addressing.AntVIPConfiguration;
import com.alipay.sofa.openmeta.client.addressing.AntVIPRefresher;
import com.alipay.sofa.openmeta.client.log.LoggerFactory;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.AntVipClient;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.AntVipConfigure;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.DefaultAntVipClient;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.RealServer;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.exception.AntVipIOException;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.exception.DomainNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;

public class GlobalAntVIPRefresher
implements AntVIPRefresher {
    private static final Logger LOGGER = LoggerFactory.getClientLogger();
    private static GlobalAntVIPRefresher refresherInstance = new GlobalAntVIPRefresher();
    private final ConcurrentHashMap<AntVIPConfiguration, List<AntVIPRefresher.RefreshCallback>> domains = new ConcurrentHashMap();
    private final ConcurrentHashMap<AntVIPConfiguration, AntVipClient> clients = new ConcurrentHashMap();
    private AntVipClient globalAntVipClient;

    private GlobalAntVIPRefresher() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        if (GlobalAntVIPRefresher.this.domains.size() == 0) continue;
                        GlobalAntVIPRefresher.this.doRefresh();
                        continue;
                    }
                    catch (Exception e) {
                        LOGGER.error("refresh antvip exception", (Throwable)e);
                        continue;
                    }
                    finally {
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    break;
                }
            }
        });
        thread.setName("global-antvip-refresher");
        thread.setDaemon(true);
        thread.start();
    }

    public static GlobalAntVIPRefresher getInstance() {
        return refresherInstance;
    }

    private void doRefresh() {
        for (Map.Entry<AntVIPConfiguration, List<AntVIPRefresher.RefreshCallback>> domainCallbacks : this.domains.entrySet()) {
            List<String> servers;
            AntVIPConfiguration configuration = domainCallbacks.getKey();
            List<AntVIPRefresher.RefreshCallback> callbacks = domainCallbacks.getValue();
            if (callbacks == null || callbacks.size() == 0 || (servers = this.getAddresses(configuration)) == null || servers.size() == 0) continue;
            for (AntVIPRefresher.RefreshCallback callback : callbacks) {
                callback.call(configuration, servers);
            }
        }
    }

    private List<String> getAddresses(AntVIPConfiguration configuration) {
        AntVipClient antVipClient = this.globalAntVipClient != null ? this.globalAntVipClient : this.clients.get(configuration);
        if (antVipClient == null) {
            throw new IllegalStateException("null antvip client for " + configuration);
        }
        ArrayList<String> addresses = new ArrayList<String>();
        if (!antVipClient.exist(configuration.getDomain())) {
            LOGGER.error("Domain[{}] of ant vip does not exist.", (Object)configuration.getDomain());
            return addresses;
        }
        try {
            List<RealServer> realServers = antVipClient.getRealServers(configuration.getDomain());
            if (null != realServers && !realServers.isEmpty()) {
                for (RealServer realServer : realServers) {
                    addresses.add(realServer.getIp() + ":" + 8888);
                }
            } else {
                LOGGER.error("Get no servers from antvip by domain[{}], use old servers instead.", (Object)configuration.getDomain());
            }
        }
        catch (AntVipIOException e) {
            LOGGER.error("No result found in local cache and failed to get it from ant vip server.", (Throwable)e);
        }
        catch (DomainNotFoundException e) {
            LOGGER.error("Domain[{}] of ant vip does not exist.", (Object)configuration.getDomain(), (Object)e);
        }
        return addresses;
    }

    @Override
    public List<String> getServers(AntVIPConfiguration configuration) {
        return this.getAddresses(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(AntVIPConfiguration configuration, AntVIPRefresher.RefreshCallback callback) {
        Class<GlobalAntVIPRefresher> clazz = GlobalAntVIPRefresher.class;
        synchronized (GlobalAntVIPRefresher.class) {
            List<AntVIPRefresher.RefreshCallback> callbacks;
            AntVipClient client = this.clients.get(configuration);
            if (client == null) {
                AntVipConfigure config = new AntVipConfigure("antvip.properties", false);
                config.setAppName("openmeta");
                if (configuration.getEnv() != null) {
                    config.setEndpoint(configuration.getEnv());
                }
                client = new DefaultAntVipClient(config);
                this.clients.put(configuration, client);
            }
            if ((callbacks = this.domains.get(configuration)) == null) {
                callbacks = new ArrayList<AntVIPRefresher.RefreshCallback>();
                this.domains.put(configuration, callbacks);
            }
            callbacks.add(callback);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(AntVIPConfiguration configuration, AntVIPRefresher.RefreshCallback callback) {
        Class<GlobalAntVIPRefresher> clazz = GlobalAntVIPRefresher.class;
        synchronized (GlobalAntVIPRefresher.class) {
            AntVipClient client;
            List<AntVIPRefresher.RefreshCallback> callbacks = this.domains.get(configuration);
            if (callbacks == null || callbacks.size() == 0) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            callbacks.remove(callback);
            if (callbacks.size() == 0 && (client = this.clients.remove(configuration)) != null) {
                client.close();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public void setGlobalAntVipClient(AntVipClient antVipClient) {
        this.globalAntVipClient = antVipClient;
    }
}

