/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.openmeta.client.log;

import com.alipay.openmeta.utils.Arguments;
import com.alipay.sofa.openmeta.client.log.LoggerConfigConstants;
import com.alipay.sofa.sofamq.com.shade.alipay.sofa.common.log.MultiAppLoggerSpaceManager;
import org.slf4j.Logger;

public class LoggerFactory {
    private static Logger clientLogger;

    private static void initLogConfig() {
        String logPath = System.getProperty(LoggerConfigConstants.LOG_PATH_PROPERTY);
        String logLevel = System.getProperty(LoggerConfigConstants.LOG_LEVEL_PROPERTY);
        String logEncode = System.getProperty(LoggerConfigConstants.LOG_ENCODE_PROPERTY);
        if (Arguments.isBlank(logPath)) {
            System.setProperty(LoggerConfigConstants.LOG_PATH_PROPERTY, LoggerConfigConstants.LOG_PATH_DEFAULT);
        }
        if (Arguments.isBlank(logLevel)) {
            System.setProperty(LoggerConfigConstants.LOG_LEVEL_PROPERTY, LoggerConfigConstants.LOG_LEVEL_DEFAULT);
        }
        if (Arguments.isBlank(logEncode)) {
            System.setProperty(LoggerConfigConstants.LOG_ENCODE_PROPERTY, LoggerConfigConstants.LOG_ENCODE_DEFAULT);
        }
    }

    private static void initLogger() {
        clientLogger = LoggerFactory.getLogger(LoggerConfigConstants.CLIENT_LOGGER_NAME);
    }

    public static Logger getLogger(String name) {
        return MultiAppLoggerSpaceManager.getLoggerBySpace(name, LoggerConfigConstants.CLIENT_LOG_SPACE);
    }

    public static Logger getClientLogger() {
        return clientLogger;
    }

    static {
        LoggerFactory.initLogConfig();
        MultiAppLoggerSpaceManager.init(LoggerConfigConstants.CLIENT_LOG_SPACE, null);
        LoggerFactory.initLogger();
    }
}

