/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.auth.authority;

import com.alipay.sofa.sofamq.auth.authority.SigningAlgorithm;
import com.alipay.sofa.sofamq.auth.authority.exception.AuthenticationException;
import com.alipay.sofa.sofamq.org.shade.apache.commons.codec.binary.Base64;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.logging.InternalLogger;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.logging.InternalLoggerFactory;
import java.nio.charset.Charset;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class AuthSigner {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getLogger("RocketmqAuthorize");
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    public static final SigningAlgorithm DEFAULT_ALGORITHM = SigningAlgorithm.HmacSHA256;
    private static final int CAL_SIGNATURE_FAILED = 10015;
    private static final String CAL_SIGNATURE_FAILED_MSG = "[%s:signature-failed] unable to calculate a request signature. error=%s";

    public static String calSignature(String data, String key) throws AuthenticationException {
        return AuthSigner.calSignature(data, key, DEFAULT_ALGORITHM, DEFAULT_CHARSET);
    }

    public static String calSignature(String data, String key, SigningAlgorithm algorithm, Charset charset) throws AuthenticationException {
        return AuthSigner.signAndBase64Encode(data, key, algorithm, charset);
    }

    private static String signAndBase64Encode(String data, String key, SigningAlgorithm algorithm, Charset charset) throws AuthenticationException {
        try {
            byte[] signature = AuthSigner.sign(data.getBytes(charset), key.getBytes(charset), algorithm);
            return new String(Base64.encodeBase64(signature), DEFAULT_CHARSET);
        }
        catch (Exception e) {
            String message = String.format(CAL_SIGNATURE_FAILED_MSG, 10015, e.getMessage());
            LOGGER.error(message, e);
            throw new AuthenticationException(message, e);
        }
    }

    private static byte[] sign(byte[] data, byte[] key, SigningAlgorithm algorithm) throws AuthenticationException {
        try {
            Mac mac = Mac.getInstance(algorithm.toString());
            mac.init(new SecretKeySpec(key, algorithm.toString()));
            return mac.doFinal(data);
        }
        catch (Exception e) {
            String message = String.format(CAL_SIGNATURE_FAILED_MSG, 10015, e.getMessage());
            LOGGER.error(message, e);
            throw new AuthenticationException(message, e);
        }
    }

    public static String calSignature(byte[] data, String key) throws AuthenticationException {
        return AuthSigner.calSignature(data, key, DEFAULT_ALGORITHM, DEFAULT_CHARSET);
    }

    public static String calSignature(byte[] data, String key, SigningAlgorithm algorithm, Charset charset) throws AuthenticationException {
        return AuthSigner.signAndBase64Encode(data, key, algorithm, charset);
    }

    private static String signAndBase64Encode(byte[] data, String key, SigningAlgorithm algorithm, Charset charset) throws AuthenticationException {
        try {
            byte[] signature = AuthSigner.sign(data, key.getBytes(charset), algorithm);
            return new String(Base64.encodeBase64(signature), DEFAULT_CHARSET);
        }
        catch (Exception e) {
            String message = String.format(CAL_SIGNATURE_FAILED_MSG, 10015, e.getMessage());
            LOGGER.error(message, e);
            throw new AuthenticationException(message, e);
        }
    }
}

