/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.auth.authority;

import com.alipay.sofa.sofamq.auth.authority.AuthSigner;
import com.alipay.sofa.sofamq.auth.authority.SessionCredentials;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.remoting.CommandCustomHeader;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.remoting.protocol.RemotingCommand;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.zip.CRC32;

public class AuthUtil {
    protected static ConcurrentMap<Class<? extends CommandCustomHeader>, Field[]> fieldCache = new ConcurrentHashMap<Class<? extends CommandCustomHeader>, Field[]>();

    public static byte[] combineRequestContent(RemotingCommand request, SortedMap<String, String> fieldsMap) {
        try {
            StringBuilder sb = new StringBuilder("");
            for (Map.Entry<String, String> entry : fieldsMap.entrySet()) {
                if ("signature".equals(entry.getKey())) continue;
                sb.append(entry.getValue());
            }
            return AuthUtil.combineBytes(sb.toString().getBytes(SessionCredentials.CHARSET), request.getBody());
        }
        catch (Exception e) {
            throw new RuntimeException("incompatible exception.", e);
        }
    }

    public static byte[] combineBytes(byte[] b1, byte[] b2) {
        int size = (null != b1 ? b1.length : 0) + (null != b2 ? b2.length : 0);
        byte[] total = new byte[size];
        if (null != b1) {
            System.arraycopy(b1, 0, total, 0, b1.length);
        }
        if (null != b2) {
            System.arraycopy(b2, 0, total, b1.length, b2.length);
        }
        return total;
    }

    public static String calSignature(byte[] data, String secretKey) {
        String signature = AuthSigner.calSignature(data, secretKey);
        return signature;
    }

    public static byte[] calCRC32(byte[] data) {
        CRC32 crc32 = new CRC32();
        crc32.update(data);
        return Long.toHexString(crc32.getValue()).getBytes(SessionCredentials.CHARSET);
    }
}

