/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.auth.authority;

import com.alipay.sofa.sofamq.auth.authority.Channel;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.MixAll;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Properties;

public class SessionCredentials {
    public static final Charset CHARSET = Charset.forName("UTF-8");
    public static final String INSTANCE_ID = "instanceId";
    public static final String ACCESS_KEY = "accessKey";
    public static final String SECRET_KEY = "secretKey";
    public static final String SIGNATURE = "signature";
    public static final String SIGNATURE_METHOD = "signatureMethod";
    public static final String CHANNEL = "channel";
    public static final String KeyFile = System.getProperty("rocketmq.client.keyFile", System.getProperty("user.home") + File.separator + "onskey");
    private String instanceId;
    private String accessKey;
    private String secretKey;
    private String securityToken;
    private String signature;
    private String signatureMethod;
    private Channel channel = Channel.ALL;

    public SessionCredentials() {
        Properties prop;
        String keyContent = null;
        try {
            keyContent = MixAll.file2String(KeyFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (keyContent != null && (prop = MixAll.string2Properties(keyContent)) != null) {
            this.updateContent(prop);
        }
    }

    public void updateContent(Properties prop) {
        Object value = prop.getProperty(ACCESS_KEY);
        if (value != null) {
            this.accessKey = ((String)value).trim();
        }
        if ((value = prop.getProperty(SECRET_KEY)) != null) {
            this.secretKey = ((String)value).trim();
        }
        if ((value = prop.get(CHANNEL)) != null) {
            this.channel = Channel.valueOf(value.toString());
        }
        if ((value = prop.getProperty(INSTANCE_ID)) != null) {
            this.instanceId = ((String)value).trim();
        }
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getSecurityToken() {
        return this.securityToken;
    }

    public void setSecurityToken(String securityToken) {
        this.securityToken = securityToken;
    }

    public String getSignatureMethod() {
        return this.signatureMethod;
    }

    public void setSignatureMethod(String signatureMethod) {
        this.signatureMethod = signatureMethod;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accessKey == null ? 0 : this.accessKey.hashCode());
        result = 31 * result + (this.secretKey == null ? 0 : this.secretKey.hashCode());
        result = 31 * result + (this.signature == null ? 0 : this.signature.hashCode());
        result = 31 * result + (this.signatureMethod == null ? 0 : this.signatureMethod.hashCode());
        result = 31 * result + (this.channel == null ? 0 : this.channel.hashCode());
        result = 31 * result + (this.instanceId == null ? 0 : this.instanceId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SessionCredentials other = (SessionCredentials)obj;
        if (this.accessKey == null ? other.accessKey != null : !this.accessKey.equals(other.accessKey)) {
            return false;
        }
        if (this.secretKey == null ? other.secretKey != null : !this.secretKey.equals(other.secretKey)) {
            return false;
        }
        if (this.signature == null ? other.signature != null : !this.signature.equals(other.signature)) {
            return false;
        }
        if (this.signatureMethod == null ? other.signatureMethod != null : !this.signatureMethod.equals(other.signatureMethod)) {
            return false;
        }
        if (this.channel == null ? other.channel != null : !this.channel.equals((Object)other.channel)) {
            return false;
        }
        return !(this.instanceId == null ? other.instanceId != null : !this.instanceId.equals(other.instanceId));
    }

    public String toString() {
        return "SessionCredentials [instanceId=" + this.instanceId + "accessKey=" + this.accessKey + ", secretKey=" + this.secretKey + ", signature=" + this.signature + ", signatureMethod=" + this.signatureMethod + ", onsChannel=" + (Object)((Object)this.channel) + "]";
    }
}

