/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.client;

import com.alipay.sofa.sofamq.client.GenericMessageImpl;
import com.alipay.sofa.sofamq.client.MQUtil;
import com.alipay.sofa.sofamq.client.Metrics;
import com.alipay.sofa.sofamq.client.SofaMQConsumerAbstract;
import com.alipay.sofa.sofamq.client.codec.MessageDecoder;
import com.alipay.sofa.sofamq.client.codec.SpecificDecoder;
import com.alipay.sofa.sofamq.client.trace.ConsumeMessageContext;
import com.alipay.sofa.sofamq.client.trace.TraceUtils;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.consumer.listener.AsyncMessageListenerConcurrently;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.UtilAll;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.message.MessageExt;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.protocol.heartbeat.MessageModel;
import io.openmessaging.api.Action;
import io.openmessaging.api.ConsumeContext;
import io.openmessaging.api.Message;
import io.openmessaging.api.batch.BatchConsumer;
import io.openmessaging.api.batch.BatchMessageListener;
import io.openmessaging.api.batch.GenericBatchMessageListener;
import io.openmessaging.api.exception.OMSRuntimeException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class BatchConsumerImpl
extends SofaMQConsumerAbstract
implements BatchConsumer {
    private static final int MAX_BATCH_SIZE = 32;
    private static final int MIN_BATCH_SIZE = 1;
    protected final ConcurrentMap<String, Object> subscribeTable = new ConcurrentHashMap<String, Object>();
    protected final ConcurrentMap<String, MessageDecoder<?>> messageDecoders = new ConcurrentHashMap();

    public BatchConsumerImpl(Properties properties) {
        super(properties);
        boolean postSubscriptionWhenPull = Boolean.parseBoolean(properties.getProperty("postSubscriptionWhenPull", "false"));
        this.defaultMQPushConsumer.setPostSubscriptionWhenPull(postSubscriptionWhenPull);
        String messageModel = properties.getProperty("messageModel", "CLUSTERING");
        this.defaultMQPushConsumer.setMessageModel(MessageModel.valueOf(messageModel));
        String consumeBatchSize = properties.getProperty("consumeMessageBatchMaxSize");
        if (!UtilAll.isBlank(consumeBatchSize)) {
            int batchSize = Math.min(32, Integer.valueOf(consumeBatchSize));
            batchSize = Math.max(1, batchSize);
            this.defaultMQPushConsumer.setConsumeMessageBatchMaxSize(batchSize);
        }
    }

    @Override
    public void start() {
        this.defaultMQPushConsumer.registerMessageListener(new BatchMessageListenerImpl());
        super.start();
    }

    @Override
    public void subscribe(String topic, String subExpression, BatchMessageListener listener) {
        this.checkSubscribeParams(topic, listener);
        this.subscribeTable.put(topic, listener);
        super.subscribe(topic, subExpression);
    }

    @Override
    public <T> void subscribe(String topic, String subExpression, GenericBatchMessageListener<T> listener) {
        this.subscribe(topic, listener);
        super.subscribe(topic, subExpression);
    }

    protected <T> void subscribe(String topic, GenericBatchMessageListener<T> listener) {
        this.checkSubscribeParams(topic, listener);
        Class clazz = listener.payloadClass();
        this.checkSubscribeCompatibility(topic, clazz);
        this.subscribeTable.put(topic, listener);
        this.messageDecoders.put(topic, new SpecificDecoder(clazz, this.schemaProvider));
    }

    @Override
    public void unsubscribe(String topic) {
        if (null != topic) {
            this.subscribeTable.remove(topic);
            super.unsubscribe(topic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConsumeConcurrentlyStatus consumeMessage0(List<MessageExt> rmqMsgList, ConsumeConcurrentlyContext rmqCtx) {
        ConsumeMessageContext ctx = TraceUtils.consumeMsgStart(rmqCtx.getConsumeMessageContext());
        ctx.setStatus("01");
        try {
            Action action;
            ArrayList<Message> msgList = new ArrayList<Message>();
            for (MessageExt rmqMsg : rmqMsgList) {
                Message msg = MQUtil.msgConvert(rmqMsg);
                Map<String, String> propertiesMap = rmqMsg.getProperties();
                msg.setMsgID(rmqMsg.getMsgId());
                if (propertiesMap != null && propertiesMap.get("__transactionId__") != null) {
                    msg.setMsgID(propertiesMap.get("__transactionId__"));
                }
                msgList.add(msg);
            }
            Object listener = this.subscribeTable.get(((Message)msgList.get(0)).getTopic());
            if (null == listener) {
                throw new OMSRuntimeException("BatchMessageListener is null");
            }
            if (listener instanceof BatchMessageListener) {
                action = ((BatchMessageListener)listener).consume(msgList, new ConsumeContext());
            } else if (listener instanceof GenericBatchMessageListener) {
                MessageDecoder messageDecoder = (MessageDecoder)this.messageDecoders.get(((Message)msgList.get(0)).getTopic());
                if (messageDecoder == null) {
                    throw new OMSRuntimeException("messageDecoder is null");
                }
                ArrayList messages = new ArrayList();
                for (Message msg : msgList) {
                    messages.add(new GenericMessageImpl(msg, messageDecoder));
                }
                action = ((GenericBatchMessageListener)listener).consume(messages, new ConsumeContext());
            } else {
                throw new OMSRuntimeException("unknown type of message listener: " + listener.getClass());
            }
            ctx.setStatus(MQUtil.consumeStatusConvert(action));
            ConsumeConcurrentlyStatus consumeConcurrentlyStatus = MQUtil.statusConvert(action);
            return consumeConcurrentlyStatus;
        }
        finally {
            TraceUtils.consumeMsgEnd(ctx);
            Metrics.consume(ctx);
        }
    }

    class BatchMessageListenerImpl
    implements AsyncMessageListenerConcurrently {
        BatchMessageListenerImpl() {
        }

        @Override
        public void consumeMessage(List<MessageExt> rmqMsgList, ConsumeConcurrentlyContext contextRMQ) {
            ConsumeConcurrentlyStatus status = BatchConsumerImpl.this.consumeMessage0(rmqMsgList, contextRMQ);
            contextRMQ.confirmConsume(status);
        }
    }
}

