/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.client;

import com.alipay.sofa.sofamq.com.shade.alibaba.fastjson.JSON;
import com.alipay.sofa.sofamq.com.shade.alibaba.fastjson.serializer.SerializerFeature;
import com.alipay.sofa.sofamq.org.shade.apache.commons.codec.binary.Base64;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ClientId {
    public static final String ANTQ_PREFIX = "@ANTQ@";
    public static final String EXT_DATA_CENTER_KEY = "0";
    public static final String EXT_DEV_GROUP_KEY = "1";
    private String clientId;
    private String clientIP;
    private String instanceName;
    private String unitName;
    private String dataCenter;
    private boolean antq;
    private String devGroup;

    public ClientId(String clientId) {
        this.clientId = clientId;
        if (clientId.startsWith(ANTQ_PREFIX)) {
            this.antq = true;
            return;
        }
        String[] clientParts = clientId.split("@");
        if (clientParts.length > 0) {
            this.clientIP = clientParts[0];
        }
        if (clientParts.length > 1) {
            this.instanceName = clientParts[1];
            String[] instanceNameParts = this.instanceName.split("#");
            if (instanceNameParts.length > 4) {
                Map<String, Object> ext = ClientId.base642Map(instanceNameParts[4]);
                this.dataCenter = (String)ext.get(EXT_DATA_CENTER_KEY);
                this.devGroup = (String)ext.get(EXT_DEV_GROUP_KEY);
            }
        }
        if (clientParts.length > 2) {
            this.unitName = clientParts[2];
        }
    }

    public static Map<String, Object> extractExtMap(String fullClientId) {
        String[] clientParts = fullClientId.split("@");
        if (clientParts.length > 1) {
            String instanceName = clientParts[1];
            String[] instanceNameParts = instanceName.split("#");
            return ClientId.extractExtMap(instanceNameParts);
        }
        return Collections.emptyMap();
    }

    private static Map<String, Object> extractExtMap(String[] instanceNameParts) {
        int extInfoIdx = 3;
        if (instanceNameParts.length >= 4) {
            return ClientId.base642Map(instanceNameParts[3]);
        }
        return Collections.emptyMap();
    }

    public static String key2Base64(Object ... kvs) {
        if (kvs.length % 2 != 0) {
            throw new IllegalArgumentException("kvs args num should be mean, kvs=" + Arrays.toString(kvs));
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < kvs.length; i += 2) {
            if (kvs[i] == null || kvs[i + 1] == null) continue;
            map.put(kvs[i].toString(), kvs[i + 1]);
        }
        return Base64.encodeBase64String(JSON.toJSONBytes(map, new SerializerFeature[0]));
    }

    public static Map<String, Object> base642Map(String base64Str) {
        return JSON.parseObject(new String(Base64.decodeBase64(base64Str)));
    }

    public String getClientIP() {
        return this.clientIP;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public String getDataCenter() {
        return this.dataCenter;
    }

    public boolean isAntq() {
        return this.antq;
    }

    public String getDevGroup() {
        return this.devGroup;
    }

    public void setDevGroup(String devGroup) {
        this.devGroup = devGroup;
    }

    public String toString() {
        return this.clientId;
    }
}

