/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.client;

import com.alipay.sofa.sofamq.client.GenericMessageImpl;
import com.alipay.sofa.sofamq.client.MQUtil;
import com.alipay.sofa.sofamq.client.Metrics;
import com.alipay.sofa.sofamq.client.SofaMQConsumerAbstract;
import com.alipay.sofa.sofamq.client.codec.MessageDecoder;
import com.alipay.sofa.sofamq.client.codec.SpecificDecoder;
import com.alipay.sofa.sofamq.client.trace.ConsumeMessageContext;
import com.alipay.sofa.sofamq.client.trace.TraceUtils;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.consumer.listener.AsyncMessageListenerConcurrently;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.message.MessageExt;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.protocol.heartbeat.MessageModel;
import io.openmessaging.api.Action;
import io.openmessaging.api.AsyncConsumeContext;
import io.openmessaging.api.AsyncGenericMessageListener;
import io.openmessaging.api.AsyncMessageListener;
import io.openmessaging.api.ConsumeContext;
import io.openmessaging.api.Consumer;
import io.openmessaging.api.GenericListener;
import io.openmessaging.api.GenericMessageListener;
import io.openmessaging.api.Message;
import io.openmessaging.api.MessageListener;
import io.openmessaging.api.MessageSelector;
import io.openmessaging.api.exception.OMSRuntimeException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ConsumerImpl
extends SofaMQConsumerAbstract
implements Consumer {
    protected final ConcurrentMap<String, Object> subscribeTable = new ConcurrentHashMap<String, Object>();
    protected final ConcurrentMap<String, MessageDecoder<?>> messageDecoders = new ConcurrentHashMap();

    public ConsumerImpl(Properties properties) {
        super(properties);
        boolean postSubscriptionWhenPull = Boolean.parseBoolean(properties.getProperty("postSubscriptionWhenPull", "false"));
        this.defaultMQPushConsumer.setPostSubscriptionWhenPull(postSubscriptionWhenPull);
        String messageModel = properties.getProperty("messageModel", "CLUSTERING");
        this.defaultMQPushConsumer.setMessageModel(MessageModel.valueOf(messageModel));
    }

    @Override
    public void start() {
        this.defaultMQPushConsumer.registerMessageListener(new AsyncMessageListenerImpl());
        super.start();
    }

    @Override
    public void subscribe(String topic, String subExpression, MessageListener listener) {
        this.checkSubscribeParams(topic, listener);
        this.subscribeTable.put(topic, listener);
        super.subscribe(topic, subExpression);
    }

    @Override
    public void subscribe(String topic, MessageSelector selector, MessageListener listener) {
        this.checkSubscribeParams(topic, listener);
        this.subscribeTable.put(topic, listener);
        super.subscribe(topic, selector);
    }

    @Override
    public <T> void subscribe(String topic, String subExpression, GenericMessageListener<T> listener) {
        this.subscribe(topic, listener);
        super.subscribe(topic, subExpression);
    }

    @Override
    public <T> void subscribe(String topic, MessageSelector selector, GenericMessageListener<T> listener) {
        this.subscribe(topic, listener);
        super.subscribe(topic, selector);
    }

    @Override
    public void subscribe(String topic, String subExpression, AsyncMessageListener listener) {
        this.checkSubscribeParams(topic, listener);
        this.subscribeTable.put(topic, listener);
        super.subscribe(topic, subExpression);
    }

    @Override
    public void subscribe(String topic, MessageSelector selector, AsyncMessageListener listener) {
        this.checkSubscribeParams(topic, listener);
        this.subscribeTable.put(topic, listener);
        super.subscribe(topic, selector);
    }

    @Override
    public <T> void subscribe(String topic, String subExpression, AsyncGenericMessageListener<T> listener) {
        this.subscribe(topic, listener);
        super.subscribe(topic, subExpression);
    }

    @Override
    public <T> void subscribe(String topic, MessageSelector selector, AsyncGenericMessageListener<T> listener) {
        this.subscribe(topic, listener);
        super.subscribe(topic, selector);
    }

    protected <T> void subscribe(String topic, GenericListener<T> listener) {
        this.checkSubscribeParams(topic, listener);
        Class<T> clazz = listener.payloadClass();
        this.checkSubscribeCompatibility(topic, clazz);
        this.subscribeTable.put(topic, listener);
        this.messageDecoders.put(topic, new SpecificDecoder<T>(clazz, this.schemaProvider));
    }

    @Override
    public void unsubscribe(String topic) {
        if (null != topic) {
            this.subscribeTable.remove(topic);
            this.messageDecoders.remove(topic);
            super.unsubscribe(topic);
        }
    }

    public void setRate(String topic, int tps) {
        this.defaultMQPushConsumer.setRate(topic, tps);
    }

    class AsyncMessageListenerImpl
    implements AsyncMessageListenerConcurrently {
        AsyncMessageListenerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void consumeMessage(List<MessageExt> msgs, final ConsumeConcurrentlyContext rmqCtx) {
            block11: {
                ConsumeMessageContext ctx = TraceUtils.consumeMsgStart(rmqCtx.getConsumeMessageContext());
                ctx.setStatus("01");
                try {
                    Object listener;
                    MessageExt msgRMQ = msgs.get(0);
                    Message msg = MQUtil.msgConvert(msgRMQ);
                    Map<String, String> stringStringMap = msgRMQ.getProperties();
                    msg.setMsgID(msgRMQ.getMsgId());
                    if (stringStringMap != null && stringStringMap.get("__transactionId__") != null) {
                        msg.setMsgID(stringStringMap.get("__transactionId__"));
                    }
                    if (null == (listener = ConsumerImpl.this.subscribeTable.get(msg.getTopic()))) {
                        throw new OMSRuntimeException("MessageListener is null");
                    }
                    if (listener instanceof MessageListener) {
                        Action action = ((MessageListener)listener).consume(msg, new ConsumeContext());
                        ctx.setStatus(MQUtil.consumeStatusConvert(action));
                        rmqCtx.confirmConsume(MQUtil.statusConvert(action));
                        break block11;
                    }
                    if (listener instanceof GenericMessageListener) {
                        MessageDecoder messageDecoder = (MessageDecoder)ConsumerImpl.this.messageDecoders.get(msg.getTopic());
                        if (messageDecoder == null) {
                            throw new OMSRuntimeException("messageDecoder is null");
                        }
                        Action action = ((GenericMessageListener)listener).consume(new GenericMessageImpl(msg, messageDecoder), new ConsumeContext());
                        ctx.setStatus(MQUtil.consumeStatusConvert(action));
                        rmqCtx.confirmConsume(MQUtil.statusConvert(action));
                        break block11;
                    }
                    if (listener instanceof AsyncMessageListener) {
                        final ConsumeMessageContext asyncCtx = ctx.clone();
                        ((AsyncMessageListener)listener).consume(msg, new AsyncConsumeContext(){

                            @Override
                            public void commit(Action action) {
                                rmqCtx.confirmConsume(MQUtil.statusConvert(action));
                                asyncCtx.setStatus(MQUtil.consumeStatusConvert(action));
                                asyncCtx.setRecover(true);
                                TraceUtils.consumeMsgEnd(asyncCtx);
                                Metrics.consume(asyncCtx);
                            }
                        });
                        ctx.setStatus("02");
                        break block11;
                    }
                    if (listener instanceof AsyncGenericMessageListener) {
                        final ConsumeMessageContext asyncCtx = ctx.clone();
                        MessageDecoder messageDecoder = (MessageDecoder)ConsumerImpl.this.messageDecoders.get(msg.getTopic());
                        if (messageDecoder == null) {
                            throw new OMSRuntimeException("messageDecoder is null");
                        }
                        ((AsyncGenericMessageListener)listener).consume(new GenericMessageImpl(msg, messageDecoder), new AsyncConsumeContext(){

                            @Override
                            public void commit(Action action) {
                                rmqCtx.confirmConsume(MQUtil.statusConvert(action));
                                asyncCtx.setStatus(MQUtil.consumeStatusConvert(action));
                                asyncCtx.setRecover(true);
                                TraceUtils.consumeMsgEnd(asyncCtx);
                                Metrics.consume(asyncCtx);
                            }
                        });
                        ctx.setStatus("02");
                        break block11;
                    }
                    throw new OMSRuntimeException("unknown type of message listener: " + listener.getClass());
                }
                finally {
                    TraceUtils.consumeMsgEnd(ctx);
                    Metrics.consume(ctx);
                }
            }
        }
    }
}

