/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.client;

import com.alipay.routeclient.RouteStrategyConfig;
import com.alipay.routeclient.RouterValue;
import com.alipay.routeclient.ZoneInfo;
import com.alipay.routeclient.ZoneRouteStrategy;
import com.alipay.sofa.sofamq.client.ClientLoggerUtil;
import com.alipay.sofa.sofamq.org.shade.apache.commons.lang3.StringUtils;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.hook.SendMessageContext;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.hook.SendMessageHook;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.message.Message;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.logging.InternalLogger;
import com.alipay.zoneclient.internal.DefaultRouteStrategyFactory;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

public class LdcSendMessageHook
implements SendMessageHook {
    private static final InternalLogger log = ClientLoggerUtil.getClientLogger();
    private static final String APP_NAME = "sofamq";
    private static final long LOG_INTERVAL = TimeUnit.MINUTES.toMillis(1L);
    private boolean mock = false;
    private String currentCell;
    private String currentCity;
    private ZoneRouteStrategy strategy;
    private boolean isElastic;
    private long lastedLogTimestamp = 0L;

    public LdcSendMessageHook(Properties properties) {
        this.currentCell = properties.getProperty("cell");
        if ("true".equals(System.getProperty("com.alipay.sofamq.ldc.mock"))) {
            this.mock = true;
            return;
        }
        if (StringUtils.isBlank(System.getProperty("com.alipay.ldc.zone"))) {
            System.setProperty("com.alipay.ldc.zone", this.currentCell);
        }
        DefaultRouteStrategyFactory factory = DefaultRouteStrategyFactory.getInstance();
        RouteStrategyConfig config = new RouteStrategyConfig();
        config.setAppName(APP_NAME);
        config.setZonemngUrl("http://zonemng-pool");
        if (LdcSendMessageHook.isHighVersionZoneClient()) {
            config.setDefaultLocalZone(this.currentCell);
        }
        factory.creatZoneRouteStrategy(config);
        this.strategy = factory.getZoneRouteStrategy(APP_NAME);
        this.currentCity = this.strategy.queryZoneInfo(this.currentCell).zoneIdcGet().cityIdcInfoGet().getName();
        this.isElastic = this.strategy.queryZoneInfo(this.currentCell).isElastic();
    }

    @Override
    public String hookName() {
        return null;
    }

    @Override
    public void sendMessageBefore(SendMessageContext context) {
        Message message = context.getMessage();
        message.putUserProperty("__UNIT.ORICELL", this.currentCell);
        if (this.mock) {
            return;
        }
        try {
            ZoneInfo czoneZoneInfo = this.strategy.getDefaultCzone();
            if (czoneZoneInfo != null) {
                message.putUserProperty("__UNIT.TARGET_C", czoneZoneInfo.getZoneName());
            } else if (System.currentTimeMillis() - this.lastedLogTimestamp > LOG_INTERVAL) {
                log.warn("zoneclient getDefaultCzone return null");
                this.lastedLogTimestamp = System.currentTimeMillis();
            }
            ZoneInfo gzoneZoneInfo = this.strategy.getDefaultGzone();
            if (gzoneZoneInfo != null) {
                message.putUserProperty("__UNIT.TARGET_G", gzoneZoneInfo.getZoneName());
            } else if (System.currentTimeMillis() - this.lastedLogTimestamp > LOG_INTERVAL) {
                log.warn("zoneclient getDefaultGzone return null");
                this.lastedLogTimestamp = System.currentTimeMillis();
            }
            String cellUid = message.getProperty("__UNIT.CELL_UID");
            if (cellUid != null) {
                ZoneInfo zoneInfo;
                RouterValue routerValue;
                if (this.isElastic) {
                    routerValue = new RouterValue();
                    routerValue.setUidValue(cellUid);
                    routerValue.setEid("-1");
                    zoneInfo = this.strategy.elasticRoute(routerValue);
                } else {
                    routerValue = new RouterValue();
                    routerValue.setUidValue(cellUid);
                    zoneInfo = this.strategy.route(routerValue);
                }
                if (zoneInfo != null) {
                    message.putUserProperty("__UNIT.TARGET_R", zoneInfo.getZoneName());
                }
            }
            Map allCities = this.strategy.getAllCityCzone(false, false);
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : allCities.entrySet()) {
                if (((String)entry.getKey()).equals(this.currentCity)) continue;
                sb.append(((ZoneInfo)entry.getValue()).getZoneName()).append(";");
            }
            if (sb.length() != 0) {
                message.putUserProperty("__UNIT.TARGET_O_C", sb.toString());
            }
        }
        catch (Throwable e) {
            log.error("target zone calculate unknown error", e);
        }
    }

    @Override
    public void sendMessageAfter(SendMessageContext context) {
    }

    private static boolean isHighVersionZoneClient() {
        try {
            return null != RouteStrategyConfig.class.getMethod("setDefaultLocalZone", String.class);
        }
        catch (Exception e) {
            return false;
        }
    }
}

