/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.client;

import com.alipay.sofa.sofamq.client.MessageAccessor;
import com.alipay.sofa.sofamq.com.shade.alibaba.fastjson.JSON;
import com.alipay.sofa.sofamq.com.shade.alibaba.fastjson.JSONObject;
import com.alipay.sofa.sofamq.org.shade.apache.commons.lang3.StringUtils;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.message.Message;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.message.MessageExt;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.message.MessageQueue;
import io.openmessaging.api.Action;
import io.openmessaging.api.TopicPartition;
import io.openmessaging.api.exception.OMSRuntimeException;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MQUtil {
    public static final String SITE_DEST_ZONES_CURRENT_ENV = "SOFAMQ_SITE_DEST_ZONES_CURRENT_ENV";
    public static final String SITE_DEST_ZONES_INCLUDE_PROD = "SOFAMQ_SITE_DEST_ZONES_INCLUDE_PROD";
    public static final String LDC_ELASTIC_NAMESPACE = "SOFAMQ_LDC_ELASTIC";
    private static final Set<String> RESERVED_KEY_SET_RMQ = new HashSet<String>();
    private static final Set<String> RESERVED_KEY_SET_ONS = new HashSet<String>();
    private static final String EMBEDDED_USER_PROPS_KEY = "__SOFAMQ.USERPROPS";
    private static final Set<String> RESERVED_KEY_SET_KEEP = new HashSet<String>();
    private static final String TOPIC_PARTITION_SEPARATOR = "#";
    public static final Pattern endpointPattern = Pattern.compile("(antvip://(.*/)?[^.]*).*");
    public static String LOCAL_DOMAIN_NAME;
    public static String LOCAL_CELL;
    public static String LOCAL_CONFREG_URL;

    public static Message msgConvert(io.openmessaging.api.Message message) {
        Properties userProperties;
        Properties systemProperties;
        Message msgRMQ = new Message();
        if (message == null) {
            throw new OMSRuntimeException("'message' is null");
        }
        if (message.getTopic() != null) {
            msgRMQ.setTopic(message.getTopic());
        }
        if (message.getKey() != null) {
            msgRMQ.setKeys(message.getKey());
        }
        if (message.getTag() != null) {
            msgRMQ.setTags(message.getTag());
        }
        if (message.getStartDeliverTime() > 0L) {
            msgRMQ.putUserProperty("TIMER_DELIVER_MS", String.valueOf(message.getStartDeliverTime()));
        }
        if (message.getBody() != null) {
            msgRMQ.setBody(message.getBody());
        }
        if (message.getShardingKey() != null && !message.getShardingKey().isEmpty()) {
            msgRMQ.putUserProperty("__SHARDINGKEY", message.getShardingKey());
        }
        if ((systemProperties = MessageAccessor.getSystemProperties(message)) != null) {
            for (Map.Entry<Object, Object> next : systemProperties.entrySet()) {
                String key = next.getKey().toString();
                if (RESERVED_KEY_SET_ONS.contains(key) && !RESERVED_KEY_SET_KEEP.contains(key)) continue;
                com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.message.MessageAccessor.putProperty(msgRMQ, next.getKey().toString(), next.getValue().toString());
            }
        }
        if ((userProperties = message.getUserProperties()) != null) {
            for (Map.Entry<Object, Object> next : userProperties.entrySet()) {
                String key = next.getKey().toString();
                if (RESERVED_KEY_SET_RMQ.contains(next.getKey().toString()) && !RESERVED_KEY_SET_KEEP.contains(key)) continue;
                com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.message.MessageAccessor.putProperty(msgRMQ, next.getKey().toString(), next.getValue().toString());
            }
        }
        return msgRMQ;
    }

    public static io.openmessaging.api.Message msgConvert(MessageExt msgRMQ) {
        io.openmessaging.api.Message message = new io.openmessaging.api.Message();
        if (msgRMQ.getTopic() != null) {
            message.setTopic(msgRMQ.getTopic());
        }
        if (msgRMQ.getKeys() != null) {
            message.setKey(msgRMQ.getKeys());
        }
        if (msgRMQ.getTags() != null) {
            message.setTag(msgRMQ.getTags());
        }
        if (msgRMQ.getBody() != null) {
            message.setBody(msgRMQ.getBody());
        }
        if (msgRMQ.getUserProperty("TIMER_DELIVER_MS") != null) {
            long ms = Long.valueOf(msgRMQ.getUserProperty("TIMER_DELIVER_MS"));
            msgRMQ.getProperties().remove("TIMER_DELIVER_MS");
            message.setStartDeliverTime(ms);
        }
        message.putSystemProperties("__CONSUMEOFFSET", Long.toString(msgRMQ.getQueueOffset()));
        message.putSystemProperties("__PARTITION", msgRMQ.getBrokerName() + TOPIC_PARTITION_SEPARATOR + msgRMQ.getQueueId());
        message.setReconsumeTimes(msgRMQ.getReconsumeTimes());
        message.setBornTimestamp(msgRMQ.getBornTimestamp());
        message.setBornHost(String.valueOf(msgRMQ.getBornHost()));
        Map<String, String> properties = msgRMQ.getProperties();
        if (properties != null) {
            for (Map.Entry<String, String> next : properties.entrySet()) {
                if (RESERVED_KEY_SET_RMQ.contains(next.getKey()) || RESERVED_KEY_SET_ONS.contains(next.getKey())) {
                    MessageAccessor.putSystemProperties(message, next.getKey(), next.getValue());
                    continue;
                }
                if (EMBEDDED_USER_PROPS_KEY.equals(next.getKey())) continue;
                message.putUserProperties(next.getKey(), next.getValue());
            }
            String embeddedUserProps = properties.get(EMBEDDED_USER_PROPS_KEY);
            if (embeddedUserProps != null) {
                JSONObject json = JSON.parseObject(embeddedUserProps);
                for (Map.Entry<String, Object> entry : json.entrySet()) {
                    message.putUserProperties(entry.getKey(), entry.getValue().toString());
                }
            }
        }
        return message;
    }

    public static ConsumeConcurrentlyStatus statusConvert(Action action) {
        if (action != null) {
            switch (action) {
                case CommitMessage: {
                    return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
                }
                case ReconsumeLater: {
                    return ConsumeConcurrentlyStatus.RECONSUME_LATER;
                }
            }
        }
        return null;
    }

    public static String consumeStatusConvert(Action action) {
        if (action == null) {
            return "01";
        }
        return action == Action.CommitMessage ? "00" : "01";
    }

    public static Properties extractProperties(Properties properties) {
        Properties newPro = new Properties();
        Properties inner = null;
        try {
            Field field = Properties.class.getDeclaredField("defaults");
            field.setAccessible(true);
            inner = (Properties)field.get(properties);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (inner != null) {
            for (Map.Entry<Object, Object> entry : inner.entrySet()) {
                newPro.setProperty(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
            }
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            newPro.setProperty(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
        }
        return newPro;
    }

    public static Set<TopicPartition> convertToTopicPartitions(Collection<MessageQueue> messageQueues) {
        HashSet<TopicPartition> topicPartitions = new HashSet<TopicPartition>();
        for (MessageQueue messageQueue : messageQueues) {
            TopicPartition topicPartition = MQUtil.convertToTopicPartition(messageQueue);
            topicPartitions.add(topicPartition);
        }
        return topicPartitions;
    }

    public static Set<MessageQueue> convertToMessageQueues(Collection<TopicPartition> topicPartitions) {
        HashSet<MessageQueue> messageQueues = new HashSet<MessageQueue>();
        for (TopicPartition topicPartition : topicPartitions) {
            messageQueues.add(MQUtil.convertToMessageQueue(topicPartition));
        }
        return messageQueues;
    }

    public static String getPartition(String brokerName, int queueId) {
        return brokerName + TOPIC_PARTITION_SEPARATOR + queueId;
    }

    public static TopicPartition convertToTopicPartition(MessageQueue messageQueue) {
        String topic = messageQueue.getTopic();
        String partition = MQUtil.getPartition(messageQueue.getBrokerName(), messageQueue.getQueueId());
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        return topicPartition;
    }

    public static MessageQueue convertToMessageQueue(TopicPartition topicPartition) {
        String topic = topicPartition.getTopic();
        String[] tmp = topicPartition.getPartition().split(TOPIC_PARTITION_SEPARATOR);
        if (tmp.length != 2) {
            throw new OMSRuntimeException("Failed to get message queue");
        }
        String brokerName = tmp[0];
        int queueId = Integer.valueOf(tmp[1]);
        return new MessageQueue(topic, brokerName, queueId);
    }

    public static Map<String, String> splitQuery(String url) {
        try {
            String[] pairs;
            LinkedHashMap<String, String> queryPairs = new LinkedHashMap<String, String>();
            String query = new URI(url).getQuery();
            if (StringUtils.isBlank(query)) {
                return Collections.emptyMap();
            }
            for (String pair : pairs = query.split("&")) {
                int idx = pair.indexOf("=");
                queryPairs.put(URLDecoder.decode(pair.substring(0, idx), "UTF-8"), URLDecoder.decode(pair.substring(idx + 1), "UTF-8"));
            }
            return queryPairs;
        }
        catch (Exception ex) {
            return Collections.emptyMap();
        }
    }

    public static Map<String, String> getEndpointImpliedInfo(String endpoint) {
        Pattern pattern;
        Matcher matcher;
        if (endpoint == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (endpoint.startsWith("antvip://")) {
            map.put("site", "antfin");
        }
        if (!(matcher = (pattern = Pattern.compile("antvip://(.+?)/.+?\\.(.+?)\\..*")).matcher(endpoint)).matches()) {
            return map;
        }
        String address = matcher.group(1);
        String cell = matcher.group(2);
        if (address == null) {
            return map;
        }
        if ((address.startsWith("antvip-pool") || address.startsWith("iantvip-pool")) && StringUtils.isNotBlank(cell)) {
            map.put("cell", cell.toUpperCase());
        }
        return map;
    }

    public static Properties getServerConf() {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(System.getProperty("user.home") + "/conf/server.conf"));
        }
        catch (IOException e) {
            try {
                properties.load(new FileInputStream(System.getProperty("user.home") + "/server.conf"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return properties;
    }

    public static void initEnv() {
        String confregUrl;
        String cell;
        Properties properties = MQUtil.getServerConf();
        String domainName = properties.getProperty("domainname");
        if (StringUtils.isNotBlank(domainName) && LOCAL_DOMAIN_NAME == null) {
            LOCAL_DOMAIN_NAME = domainName.trim();
        }
        if (StringUtils.isNotBlank(cell = properties.getProperty("zone")) && LOCAL_CELL == null) {
            LOCAL_CELL = cell.trim().toUpperCase();
        }
        if (StringUtils.isBlank(LOCAL_CELL)) {
            LOCAL_CELL = System.getenv("ALIPAY_ZONE");
        }
        if (StringUtils.isNotBlank(confregUrl = properties.getProperty("confregurl")) && LOCAL_CONFREG_URL == null) {
            LOCAL_CONFREG_URL = confregUrl.trim();
        }
    }

    public static String getLocalDomainName() {
        return LOCAL_DOMAIN_NAME;
    }

    public static String getLocalConfregUrl() {
        return LOCAL_CONFREG_URL;
    }

    public static String getLocalCell() {
        return LOCAL_CELL;
    }

    public static void replaceEndpoint(Properties properties, String domain) {
        String endpoint = properties.getProperty("endpoint");
        int questionMarkIndex = endpoint.indexOf(63);
        String query = questionMarkIndex < 0 ? "" : endpoint.substring(questionMarkIndex);
        String string = endpoint = questionMarkIndex < 0 ? endpoint : endpoint.substring(0, questionMarkIndex);
        if (StringUtils.isBlank(endpoint)) {
            throw new IllegalArgumentException(String.format("cannot find endpoint in properties", new Object[0]));
        }
        Matcher matcher = endpointPattern.matcher(endpoint);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format(String.format("endpoint %s is invalid", endpoint), new Object[0]));
        }
        String shortDomainEndpoint = matcher.group(1);
        properties.put("endpoint", shortDomainEndpoint + "." + domain + query);
    }

    static {
        MQUtil.initEnv();
        RESERVED_KEY_SET_RMQ.add("KEYS");
        RESERVED_KEY_SET_RMQ.add("TAGS");
        RESERVED_KEY_SET_RMQ.add("WAIT");
        RESERVED_KEY_SET_RMQ.add("DELAY");
        RESERVED_KEY_SET_RMQ.add("RETRY_TOPIC");
        RESERVED_KEY_SET_RMQ.add("REAL_TOPIC");
        RESERVED_KEY_SET_RMQ.add("REAL_QID");
        RESERVED_KEY_SET_RMQ.add("TRAN_MSG");
        RESERVED_KEY_SET_RMQ.add("PGROUP");
        RESERVED_KEY_SET_RMQ.add("MIN_OFFSET");
        RESERVED_KEY_SET_RMQ.add("MAX_OFFSET");
        RESERVED_KEY_SET_ONS.add("__TAG");
        RESERVED_KEY_SET_ONS.add("__KEY");
        RESERVED_KEY_SET_ONS.add("__MSGID");
        RESERVED_KEY_SET_ONS.add("__RECONSUMETIMES");
        RESERVED_KEY_SET_ONS.add("__STARTDELIVERTIME");
        RESERVED_KEY_SET_ONS.add("__BORNHOST");
        RESERVED_KEY_SET_ONS.add("__BORNTIMESTAMP");
        RESERVED_KEY_SET_ONS.add("__SHARDINGKEY");
        RESERVED_KEY_SET_ONS.add("__UNIT.TARGET_R");
        RESERVED_KEY_SET_ONS.add("__UNIT.TARGET_G");
        RESERVED_KEY_SET_ONS.add("__UNIT.TARGET_C");
        RESERVED_KEY_SET_ONS.add("__UNIT.TARGET_O_C");
        RESERVED_KEY_SET_ONS.add("__UNIT.ORICELL");
        RESERVED_KEY_SET_ONS.add("__SCHEMA.ID");
        RESERVED_KEY_SET_KEEP.add("__UNIT.TARGET_R");
        RESERVED_KEY_SET_KEEP.add("__UNIT.TARGET_G");
        RESERVED_KEY_SET_KEEP.add("__UNIT.TARGET_C");
        RESERVED_KEY_SET_KEEP.add("__UNIT.TARGET_O_C");
        RESERVED_KEY_SET_KEEP.add("__UNIT.ORICELL");
        RESERVED_KEY_SET_KEEP.add("__SCHEMA.ID");
    }
}

