/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.client;

import com.alipay.openmeta.schema.Schema;
import com.alipay.sofa.sofamq.client.schema.GenericAvroRecord;
import com.alipay.sofa.sofamq.client.schema.GenericSchema;
import com.alipay.sofa.sofamq.client.schema.SchemaValidator;
import com.alipay.sofa.sofamq.client.util.Arguments;
import com.alipay.sofa.sofamq.client.util.Pair;
import io.openmessaging.api.Message;
import io.openmessaging.api.MessageBuilder;
import java.util.Properties;

public class MessageBuilderImpl<T>
implements MessageBuilder<T> {
    private String key;
    private String tags;
    private String shardingKey;
    private String topic;
    private T value;
    private SchemaValidator schemaValidator;
    private final Properties userProperties = new Properties();

    public MessageBuilderImpl(SchemaValidator schemaValidator) {
        this();
        this.schemaValidator = Arguments.requireNotNull(schemaValidator, "schemaProvider");
    }

    public MessageBuilderImpl() {
    }

    @Override
    public MessageBuilder withTopic(String topic) {
        this.topic = Arguments.requireNotEmpty(topic, "topic");
        return this;
    }

    @Override
    public MessageBuilder withKey(String key) {
        this.key = Arguments.requireNotEmpty(key, "key");
        return this;
    }

    @Override
    public MessageBuilder withTags(String tags) {
        this.tags = Arguments.requireNotEmpty(tags, "tags");
        return this;
    }

    @Override
    public MessageBuilder withShardingKey(String shardingKey) {
        this.shardingKey = Arguments.requireNotEmpty(shardingKey, "shardingKey");
        return this;
    }

    @Override
    public MessageBuilder withProperty(String key, String value) {
        this.userProperties.put(Arguments.requireNotEmpty(key, "key"), Arguments.requireNotEmpty(value, "value"));
        return this;
    }

    @Override
    public MessageBuilder withValue(T t) {
        this.value = Arguments.requireNotNull(t, "t");
        return this;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public Message build() {
        Message message = new Message();
        message.setTopic(this.topic);
        message.setTag(this.tags);
        message.setKey(this.key);
        message.setUserProperties(this.userProperties);
        message.setShardingKey(this.shardingKey);
        if (this.value instanceof byte[]) {
            message.setBody((byte[])this.value);
        } else if (this.schemaValidator != null) {
            if (this.value instanceof GenericAvroRecord) {
                GenericAvroRecord record = (GenericAvroRecord)this.value;
                String schema = record.getSchema().toString();
                Pair<Long, GenericSchema> writeSchema = this.schemaValidator.validateWriteGenericSchema(this.topic, schema);
                message.putSystemProperties("__SCHEMA.ID", String.valueOf(writeSchema.getFirst()));
                message.setBody(writeSchema.getSecond().encode(this.value));
            } else {
                Pair<Long, Schema> writeSchema = this.schemaValidator.validateWriteSchema(this.topic, this.value.getClass());
                message.putSystemProperties("__SCHEMA.ID", String.valueOf(writeSchema.getFirst()));
                message.setBody(writeSchema.getSecond().encode(this.value));
            }
        } else {
            throw new UnsupportedOperationException(String.format("type(%s) of value is not supported with no OMSBuiltinKeys.OPEN_META_URL configured", this.value.getClass().toString()));
        }
        return message;
    }
}

