/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.client;

import com.alipay.common.tracer.context.MQLogContext;
import com.alipay.sofa.lookout.metrics.MetricsService;
import com.alipay.sofa.lookout.metrics.type.Counter;
import com.alipay.sofa.sofamq.client.ClientLoggerUtil;
import com.alipay.sofa.sofamq.client.trace.ConsumeMessageContext;
import com.alipay.sofa.sofamq.client.trace.SendMessageContext;
import com.alipay.sofa.sofamq.client.trace.TraceUtils;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.logging.InternalLogger;

public class Metrics {
    private static final InternalLogger logger = ClientLoggerUtil.getClientLogger();
    private static final String LOOKOUT2_METRICS_CLASS_NAME = "com.alipay.sofa.lookout.metrics.MetricsService";
    private static boolean metricsEnable;
    private static final String TOPIC_LABEL = "topic";
    private static final String MSG_TYPE_LABEL = "msg_type";
    private static final String RESULT_LABEL = "result";
    private static final String GROUP_LABEL = "group";
    private static Counter send;
    private static Counter sendRt;
    private static Counter consume;
    private static Counter consumeRt;

    public static void send(SendMessageContext context) {
        if (!metricsEnable) {
            return;
        }
        String topic = context.getMessage().getTopic();
        ((Counter.Child)send.labels(new String[]{topic, TraceUtils.getSendResult(context), Integer.toString(TraceUtils.getMsgType(context))})).inc();
        long cost = System.currentTimeMillis() - context.getStartTimestamp();
        ((Counter.Child)sendRt.labels(new String[]{topic, TraceUtils.getSendResult(context), Integer.toString(TraceUtils.getMsgType(context))})).inc((double)cost);
    }

    public static void consume(ConsumeMessageContext context) {
        if (!metricsEnable) {
            return;
        }
        if (context.getTracerContext() == null || !(context.getTracerContext() instanceof MQLogContext)) {
            return;
        }
        MQLogContext logContext = (MQLogContext)context.getTracerContext();
        String topic = logContext.getTopic();
        String group = logContext.getGroup();
        ((Counter.Child)consume.labels(new String[]{topic, group, context.getStatus()})).inc();
        ((Counter.Child)consumeRt.labels(new String[]{topic, group, context.getStatus()})).inc((double)(System.currentTimeMillis() - context.getStartTimestamp()));
    }

    static {
        try {
            Class<?> mqTracerClass = Class.forName(LOOKOUT2_METRICS_CLASS_NAME);
            metricsEnable = mqTracerClass != null;
        }
        catch (ClassNotFoundException e) {
            metricsEnable = false;
        }
        catch (Throwable e) {
            logger.error("Exception occurred when init mq tracer!", e);
            metricsEnable = false;
        }
        if (!metricsEnable) {
            logger.warn("{} class not found and mq client trace disable", (Object)LOOKOUT2_METRICS_CLASS_NAME);
        } else {
            logger.info("{} class found, mq client traceEnable [{}]", (Object)LOOKOUT2_METRICS_CLASS_NAME, (Object)metricsEnable);
            send = ((Counter.Builder)MetricsService.middlewareCounterBuilder((String)"sofamq_send", (String)"sofamq send counter metrics").labelNames(new String[]{TOPIC_LABEL, RESULT_LABEL, MSG_TYPE_LABEL})).create();
            sendRt = ((Counter.Builder)MetricsService.middlewareCounterBuilder((String)"sofamq_send_rt", (String)"sofamq send rt metrics").labelNames(new String[]{TOPIC_LABEL, RESULT_LABEL, MSG_TYPE_LABEL})).create();
            consume = ((Counter.Builder)MetricsService.middlewareCounterBuilder((String)"sofamq_consume", (String)"sofamq consume counter metrics").labelNames(new String[]{TOPIC_LABEL, GROUP_LABEL, RESULT_LABEL})).create();
            consumeRt = ((Counter.Builder)MetricsService.middlewareCounterBuilder((String)"sofamq_consume_rt", (String)"sofamq consume rt counter metrics").labelNames(new String[]{TOPIC_LABEL, GROUP_LABEL, RESULT_LABEL})).create();
        }
    }
}

