/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.client;

import com.alipay.sofa.sofamq.client.GenericMessageImpl;
import com.alipay.sofa.sofamq.client.MultiTransactionChecker;
import com.alipay.sofa.sofamq.client.codec.MessageDecoder;
import com.alipay.sofa.sofamq.client.codec.SpecificDecoder;
import com.alipay.sofa.sofamq.client.schema.SchemaProvider;
import io.openmessaging.api.Message;
import io.openmessaging.api.transaction.GenericLocalTransactionChecker;
import io.openmessaging.api.transaction.TransactionStatus;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class MultiGenericTransactionCheckerImpl
implements MultiTransactionChecker {
    private Map<String, GenericLocalTransactionChecker> genericLocalTransactionCheckerMap = new ConcurrentHashMap<String, GenericLocalTransactionChecker>();
    private ConcurrentMap<String, MessageDecoder<?>> messageDecoders = new ConcurrentHashMap();

    @Override
    public TransactionStatus check(Message msg) {
        String topic = msg.getTopic();
        GenericLocalTransactionChecker checker = this.genericLocalTransactionCheckerMap.get(topic);
        if (checker == null) {
            throw new IllegalStateException(String.format("transactionChecker is not registered for %s", topic));
        }
        return checker.check(new GenericMessageImpl(msg, (MessageDecoder)this.messageDecoders.get(topic)));
    }

    public synchronized <T> void registerGenericTransactionChecker(String topic, GenericLocalTransactionChecker<T> transactionChecker, SchemaProvider schemaProvider) {
        if (this.genericLocalTransactionCheckerMap.containsKey(topic)) {
            throw new IllegalArgumentException(String.format("transactionChecker for %s can not be registered twice", topic));
        }
        this.genericLocalTransactionCheckerMap.put(topic, transactionChecker);
        this.messageDecoders.put(topic, new SpecificDecoder<T>(transactionChecker.payloadClass(), schemaProvider));
    }

    @Override
    public boolean isTransactionCheckerRegistered(String topic) {
        return this.genericLocalTransactionCheckerMap.containsKey(topic);
    }
}

