/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.client;

import com.alipay.sofa.sofamq.client.MultiTransactionChecker;
import io.openmessaging.api.Message;
import io.openmessaging.api.transaction.LocalTransactionChecker;
import io.openmessaging.api.transaction.TransactionStatus;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MultiTransactionCheckerImpl
implements MultiTransactionChecker {
    private Map<String, LocalTransactionChecker> localTransactionCheckerMap = new ConcurrentHashMap<String, LocalTransactionChecker>();

    @Override
    public TransactionStatus check(Message msg) {
        String topic = msg.getTopic();
        LocalTransactionChecker checker = this.localTransactionCheckerMap.get(topic);
        if (checker == null) {
            throw new IllegalStateException(String.format("transactionChecker is not registered for %s", topic));
        }
        return checker.check(msg);
    }

    public synchronized void registerTransactionChecker(String topic, LocalTransactionChecker transactionChecker) {
        if (this.localTransactionCheckerMap.containsKey(topic)) {
            throw new IllegalArgumentException(String.format("transactionChecker for %s can not be registered twice", topic));
        }
        this.localTransactionCheckerMap.put(topic, transactionChecker);
    }

    @Override
    public boolean isTransactionCheckerRegistered(String topic) {
        return this.localTransactionCheckerMap.containsKey(topic);
    }
}

