/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.client;

import com.alipay.sofa.sofamq.client.GenericMessageImpl;
import com.alipay.sofa.sofamq.client.MQUtil;
import com.alipay.sofa.sofamq.client.Metrics;
import com.alipay.sofa.sofamq.client.SofaMQConsumerAbstract;
import com.alipay.sofa.sofamq.client.codec.MessageDecoder;
import com.alipay.sofa.sofamq.client.codec.SpecificDecoder;
import com.alipay.sofa.sofamq.client.trace.ConsumeMessageContext;
import com.alipay.sofa.sofamq.client.trace.TraceUtils;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.consumer.listener.ConsumeOrderlyContext;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.consumer.listener.ConsumeOrderlyStatus;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.consumer.listener.MessageListenerOrderly;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.UtilAll;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.message.MessageExt;
import io.openmessaging.api.Message;
import io.openmessaging.api.MessageSelector;
import io.openmessaging.api.exception.OMSRuntimeException;
import io.openmessaging.api.order.ConsumeOrderContext;
import io.openmessaging.api.order.GenericMessageOrderListener;
import io.openmessaging.api.order.MessageOrderListener;
import io.openmessaging.api.order.OrderAction;
import io.openmessaging.api.order.OrderConsumer;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class OrderConsumerImpl
extends SofaMQConsumerAbstract
implements OrderConsumer {
    protected final ConcurrentMap<String, Object> subscribeTable = new ConcurrentHashMap<String, Object>();
    protected final ConcurrentMap<String, MessageDecoder<?>> messageDecoders = new ConcurrentHashMap();

    public OrderConsumerImpl(Properties properties) {
        super(properties);
        String suspendTimeMillis = properties.getProperty("suspendTimeMills");
        if (!UtilAll.isBlank(suspendTimeMillis)) {
            try {
                this.defaultMQPushConsumer.setSuspendCurrentQueueTimeMillis(Long.parseLong(suspendTimeMillis));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        boolean enableOrderlyConsumeAccelerator = Boolean.parseBoolean(properties.getProperty("enableOrderlyConsumeAccelerator"));
        this.defaultMQPushConsumer.setOrderlyConsumeAccelerator(enableOrderlyConsumeAccelerator);
    }

    @Override
    public void start() {
        this.defaultMQPushConsumer.registerMessageListener(new MessageListenerOrderlyImpl());
        super.start();
    }

    @Override
    public void subscribe(String topic, String subExpression, MessageOrderListener listener) {
        this.checkSubscribeParams(topic, listener);
        this.subscribeTable.put(topic, listener);
        super.subscribe(topic, subExpression);
    }

    @Override
    public void subscribe(String topic, MessageSelector selector, MessageOrderListener listener) {
        this.checkSubscribeParams(topic, listener);
        this.subscribeTable.put(topic, listener);
        super.subscribe(topic, selector);
    }

    @Override
    public <T> void subscribe(String topic, String subExpression, GenericMessageOrderListener<T> listener) {
        this.subscribe(topic, listener);
        super.subscribe(topic, subExpression);
    }

    @Override
    public <T> void subscribe(String topic, MessageSelector selector, GenericMessageOrderListener<T> listener) {
        this.subscribe(topic, listener);
        super.subscribe(topic, selector);
    }

    protected <T> void subscribe(String topic, GenericMessageOrderListener<T> listener) {
        this.checkSubscribeParams(topic, listener);
        Class clazz = listener.payloadClass();
        this.checkSubscribeCompatibility(topic, clazz);
        this.subscribeTable.put(topic, listener);
        this.messageDecoders.put(topic, new SpecificDecoder(clazz, this.schemaProvider));
    }

    public ConsumeOrderlyStatus consumeMessage0(List<MessageExt> arg0, ConsumeOrderlyContext args1) {
        OrderAction action;
        MessageExt msgRMQ = arg0.get(0);
        Message msg = MQUtil.msgConvert(msgRMQ);
        msg.setMsgID(msgRMQ.getMsgId());
        Object listener = this.subscribeTable.get(msg.getTopic());
        if (null == listener) {
            throw new OMSRuntimeException("MessageOrderListener is null");
        }
        if (listener instanceof MessageOrderListener) {
            action = ((MessageOrderListener)listener).consume(msg, new ConsumeOrderContext());
        } else if (listener instanceof GenericMessageOrderListener) {
            MessageDecoder messageDecoder = (MessageDecoder)this.messageDecoders.get(msg.getTopic());
            if (messageDecoder == null) {
                throw new OMSRuntimeException("messageDecoder is null");
            }
            action = ((GenericMessageOrderListener)listener).consume(new GenericMessageImpl(msg, messageDecoder), new ConsumeOrderContext());
        } else {
            throw new OMSRuntimeException("unknown type of message listener: " + listener.getClass());
        }
        if (action != null) {
            switch (action) {
                case Success: {
                    return ConsumeOrderlyStatus.SUCCESS;
                }
                case Suspend: {
                    return ConsumeOrderlyStatus.SUSPEND_CURRENT_QUEUE_A_MOMENT;
                }
            }
        }
        return ConsumeOrderlyStatus.SUSPEND_CURRENT_QUEUE_A_MOMENT;
    }

    @Override
    public void unsubscribe(String topic) {
        if (null != topic) {
            this.subscribeTable.remove(topic);
            this.messageDecoders.remove(topic);
            super.unsubscribe(topic);
        }
    }

    class MessageListenerOrderlyImpl
    implements MessageListenerOrderly {
        MessageListenerOrderlyImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ConsumeOrderlyStatus consumeMessage(List<MessageExt> messages, ConsumeOrderlyContext rmqCtx) {
            ConsumeMessageContext ctx = TraceUtils.consumeMsgStart(rmqCtx.getConsumeMessageContext());
            ctx.setStatus("01");
            try {
                ConsumeOrderlyStatus status = OrderConsumerImpl.this.consumeMessage0(messages, rmqCtx);
                ctx.setStatus(status == ConsumeOrderlyStatus.SUCCESS ? "00" : "01");
                ConsumeOrderlyStatus consumeOrderlyStatus = status;
                return consumeOrderlyStatus;
            }
            finally {
                TraceUtils.consumeMsgEnd(ctx);
                Metrics.consume(ctx);
            }
        }
    }
}

