/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.client;

import com.alipay.sofa.sofamq.client.ClientLoggerUtil;
import com.alipay.sofa.sofamq.client.GenericMessageImpl;
import com.alipay.sofa.sofamq.client.MQClientRPCHook;
import com.alipay.sofa.sofamq.client.MQUtil;
import com.alipay.sofa.sofamq.client.SofaMQClientAbstract;
import com.alipay.sofa.sofamq.client.codec.MessageDecoder;
import com.alipay.sofa.sofamq.client.codec.SpecificDecoder;
import com.alipay.sofa.sofamq.org.shade.apache.commons.lang3.StringUtils;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.consumer.DefaultLitePullConsumer;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.consumer.MessageQueueListener;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.consumer.TopicMessageQueueChangeListener;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.exception.MQClientException;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.UtilAll;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.message.MessageExt;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.message.MessageQueue;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.protocol.heartbeat.MessageModel;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.logging.InternalLogger;
import io.openmessaging.api.GenericMessage;
import io.openmessaging.api.Message;
import io.openmessaging.api.MessageSelector;
import io.openmessaging.api.PullConsumer;
import io.openmessaging.api.TopicPartition;
import io.openmessaging.api.exception.OMSRuntimeException;
import io.openmessaging.api.schema.GenericRecord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class PullConsumerImpl
extends SofaMQClientAbstract
implements PullConsumer {
    private static final InternalLogger LOGGER = ClientLoggerUtil.getClientLogger();
    private static final int MAX_CACHED_MESSAGE_SIZE_IN_MIB = 1024;
    private static final int MIN_CACHED_MESSAGE_SIZE_IN_MIB = 16;
    private static final int MAX_CACHED_MESSAGE_AMOUNT = 50000;
    private static final int MIN_CACHED_MESSAGE_AMOUNT = 100;
    private DefaultLitePullConsumer litePullConsumer;
    private int maxCachedMessageSizeInMiB = 512;
    private int maxCachedMessageAmount = 5000;
    private MessageDecoder<GenericRecord> messageDecoder;

    public PullConsumerImpl(Properties properties) {
        super(properties);
        String autoCommit;
        String configuredCachedMessageSizeInMiB;
        String configuredCachedMessageAmount;
        String consumerGroup = properties.getProperty("groupId", properties.getProperty("groupId"));
        if (StringUtils.isEmpty(consumerGroup)) {
            throw new OMSRuntimeException("Unable to get GROUP_ID property");
        }
        this.litePullConsumer = new DefaultLitePullConsumer(this.getNamespace(), consumerGroup, new MQClientRPCHook(this.sessionCredentials));
        String messageModel = properties.getProperty("messageModel", "CLUSTERING");
        this.litePullConsumer.setMessageModel(MessageModel.valueOf(messageModel));
        String maxBatchMessageCount = properties.getProperty("maxBatchMessageCount");
        if (!UtilAll.isBlank(maxBatchMessageCount)) {
            this.litePullConsumer.setPullBatchSize(Integer.valueOf(maxBatchMessageCount));
        }
        boolean isVipChannelEnabled = Boolean.parseBoolean(properties.getProperty("isVipChannelEnabled", "false"));
        this.litePullConsumer.setVipChannelEnabled(isVipChannelEnabled);
        this.litePullConsumer.setInstanceName(this.buildInstanceName());
        this.litePullConsumer.setNamesrvAddr(this.getNameServerAddr());
        String consumeThreadNums = properties.getProperty("consumeThreadNums");
        if (!UtilAll.isBlank(consumeThreadNums)) {
            this.litePullConsumer.setPullThreadNums(Integer.valueOf(consumeThreadNums));
        }
        if (!UtilAll.isBlank(configuredCachedMessageAmount = properties.getProperty("maxCachedMessageAmount"))) {
            this.maxCachedMessageAmount = Math.min(50000, Integer.valueOf(configuredCachedMessageAmount));
            this.maxCachedMessageAmount = Math.max(100, this.maxCachedMessageAmount);
            this.litePullConsumer.setPullThresholdForAll(this.maxCachedMessageAmount);
        }
        if (!UtilAll.isBlank(configuredCachedMessageSizeInMiB = properties.getProperty("maxCachedMessageSizeInMiB"))) {
            this.maxCachedMessageSizeInMiB = Math.min(1024, Integer.valueOf(configuredCachedMessageSizeInMiB));
            this.maxCachedMessageSizeInMiB = Math.max(16, this.maxCachedMessageSizeInMiB);
            this.litePullConsumer.setPullThresholdSizeForQueue(this.maxCachedMessageSizeInMiB);
        }
        if (!UtilAll.isBlank(autoCommit = properties.getProperty("autoCommit"))) {
            this.litePullConsumer.setAutoCommit(Boolean.valueOf(autoCommit));
        }
    }

    @Override
    protected void updateNameServerAddr(String nameServerAddresses) {
        this.litePullConsumer.updateNameServerAddress(nameServerAddresses);
    }

    @Override
    public Set<TopicPartition> topicPartitions(String topic) {
        try {
            Collection<MessageQueue> messageQueues = this.litePullConsumer.fetchMessageQueues(topic);
            HashSet<TopicPartition> topicPartitions = new HashSet<TopicPartition>();
            for (MessageQueue messageQueue : messageQueues) {
                topicPartitions.add(MQUtil.convertToTopicPartition(messageQueue));
            }
            return topicPartitions;
        }
        catch (MQClientException ex) {
            throw new OMSRuntimeException("defaultMQPushConsumer subscribe exception", (Throwable)ex);
        }
    }

    @Override
    public void subscribe(String topic, String subExpression) {
        try {
            this.litePullConsumer.subscribe(topic, subExpression);
        }
        catch (MQClientException e) {
            throw new OMSRuntimeException(String.format("PullConsumer subscribe error, topic=%s subExpression=%s", topic, subExpression), (Throwable)e);
        }
    }

    @Override
    public void subscribe(String topic, MessageSelector selector) {
        try {
            this.litePullConsumer.subscribe(topic, this.toMessageSelector(selector));
        }
        catch (MQClientException e) {
            throw new OMSRuntimeException(String.format("PullConsumer subscribe error, topic=%s selectorType=%s selectorExpression=%s", new Object[]{topic, selector.getType(), selector.getSubExpression()}), (Throwable)e);
        }
    }

    @Override
    public void assign(Collection<TopicPartition> topicPartitions) {
        HashSet<MessageQueue> messageQueues = new HashSet<MessageQueue>();
        for (TopicPartition topicPartition : topicPartitions) {
            messageQueues.add(MQUtil.convertToMessageQueue(topicPartition));
        }
        this.litePullConsumer.assign(messageQueues);
    }

    @Override
    public void registerTopicPartitionChangedListener(String topic, final PullConsumer.TopicPartitionChangeListener callback) {
        TopicMessageQueueChangeListener listener = new TopicMessageQueueChangeListener(){

            @Override
            public void onChanged(String topic, Set<MessageQueue> messageQueues) {
                callback.onChanged(MQUtil.convertToTopicPartitions(messageQueues));
            }
        };
        try {
            this.litePullConsumer.registerTopicMessageQueueChangeListener(topic, listener);
        }
        catch (MQClientException ex) {
            LOGGER.warn("Register listener error", ex);
            throw new OMSRuntimeException("Failed to register topic partition listener", (Throwable)ex);
        }
    }

    @Override
    public void registerAssignedTopicPartitionChangedListener(String topic, final PullConsumer.AssignedTopicPartitionChangeListener callback) {
        this.litePullConsumer.registerMessageQueueListener(topic, new MessageQueueListener(){

            @Override
            public void messageQueueChanged(String topic, Set<MessageQueue> mqAll, Set<MessageQueue> mqDivided) {
                Set<TopicPartition> all = MQUtil.convertToTopicPartitions(mqAll);
                Set<TopicPartition> divided = MQUtil.convertToTopicPartitions(mqDivided);
                callback.onChanged(topic, all, divided);
            }
        });
    }

    @Override
    public List<Message> poll(long timeout) {
        List<MessageExt> rmqMsgList = this.litePullConsumer.poll(timeout);
        ArrayList<Message> msgList = new ArrayList<Message>();
        for (MessageExt rmqMsg : rmqMsgList) {
            Message msg = MQUtil.msgConvert(rmqMsg);
            Map<String, String> propertiesMap = rmqMsg.getProperties();
            msg.setMsgID(rmqMsg.getMsgId());
            if (propertiesMap != null && propertiesMap.get("__transactionId__") != null) {
                msg.setMsgID(propertiesMap.get("__transactionId__"));
            }
            msgList.add(msg);
        }
        return msgList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GenericMessage<GenericRecord>> pollGenericMessages(long timeout) {
        if (this.schemaProvider == null) {
            throw new UnsupportedOperationException("unsupport pollGenericMessages with no OPEN_META_URL configured");
        }
        if (this.messageDecoder == null) {
            PullConsumerImpl pullConsumerImpl = this;
            synchronized (pullConsumerImpl) {
                if (this.messageDecoder == null) {
                    this.messageDecoder = new SpecificDecoder<GenericRecord>(GenericRecord.class, this.schemaProvider);
                }
            }
        }
        ArrayList<GenericMessage<GenericRecord>> result = new ArrayList<GenericMessage<GenericRecord>>();
        for (Message message : this.poll(timeout)) {
            GenericMessageImpl<GenericRecord> genericMessage = new GenericMessageImpl<GenericRecord>(message, this.messageDecoder);
            result.add(genericMessage);
        }
        return result;
    }

    @Override
    public void seek(TopicPartition topicPartition, long offset) {
        MessageQueue messageQueue = MQUtil.convertToMessageQueue(topicPartition);
        try {
            this.litePullConsumer.seek(messageQueue, offset);
        }
        catch (MQClientException ex) {
            LOGGER.warn("Topic partition: {} seek to: {} error", topicPartition, offset, ex);
            throw new OMSRuntimeException("Seek offset failed", (Throwable)ex);
        }
    }

    @Override
    public void seekToBeginning(TopicPartition topicPartition) {
        try {
            this.litePullConsumer.seekToBegin(MQUtil.convertToMessageQueue(topicPartition));
        }
        catch (MQClientException ex) {
            LOGGER.warn("Topic partition: {} seek to beginning error", (Object)topicPartition, (Object)ex);
            throw new OMSRuntimeException("Seek offset to beginning failed", (Throwable)ex);
        }
    }

    @Override
    public void seekToEnd(TopicPartition topicPartition) {
        try {
            this.litePullConsumer.seekToEnd(MQUtil.convertToMessageQueue(topicPartition));
        }
        catch (MQClientException ex) {
            LOGGER.warn("Topic partition: {} seek to end error", (Object)topicPartition, (Object)ex);
            throw new OMSRuntimeException("Seek offset to end failed", (Throwable)ex);
        }
    }

    @Override
    public void pause(Collection<TopicPartition> topicPartitions) {
        this.litePullConsumer.pause(MQUtil.convertToMessageQueues(topicPartitions));
    }

    @Override
    public void resume(Collection<TopicPartition> topicPartitions) {
        this.litePullConsumer.resume(MQUtil.convertToMessageQueues(topicPartitions));
    }

    @Override
    public Long offsetForTimestamp(TopicPartition topicPartition, Long timestamp) {
        try {
            return this.litePullConsumer.offsetForTimestamp(MQUtil.convertToMessageQueue(topicPartition), timestamp);
        }
        catch (MQClientException ex) {
            LOGGER.warn("Get offset for topic partition:{} with timestamp:{} error", topicPartition, timestamp, ex);
            throw new OMSRuntimeException("Failed to get offset", (Throwable)ex);
        }
    }

    @Override
    public Long committed(TopicPartition topicPartition) {
        try {
            return this.litePullConsumer.committed(MQUtil.convertToMessageQueue(topicPartition));
        }
        catch (MQClientException ex) {
            LOGGER.warn("Get committed offset for topic partition: {} error", (Object)topicPartition, (Object)ex);
            throw new OMSRuntimeException("Failed to get committed offset", (Throwable)ex);
        }
    }

    @Override
    public void commitSync() {
        this.litePullConsumer.commitSync();
    }

    @Override
    public void start() {
        try {
            if (this.started.compareAndSet(false, true)) {
                this.litePullConsumer.start();
                super.start();
            }
        }
        catch (Exception e) {
            throw new OMSRuntimeException(e.getMessage());
        }
    }

    @Override
    public void shutdown() {
        if (this.started.compareAndSet(true, false)) {
            this.litePullConsumer.shutdown();
        }
        super.shutdown();
    }
}

