/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.client;

import com.alipay.openmeta.client.ClientOption;
import com.alipay.openmeta.client.DefaultOpenMetaClient;
import com.alipay.sofa.openmeta.client.addressing.AntVIPBasedServerAddressing;
import com.alipay.sofa.sofamq.auth.authority.SessionCredentials;
import com.alipay.sofa.sofamq.client.ClientId;
import com.alipay.sofa.sofamq.client.ClientLoggerUtil;
import com.alipay.sofa.sofamq.client.MQUtil;
import com.alipay.sofa.sofamq.client.address.AntVipAddressing;
import com.alipay.sofa.sofamq.client.address.RealNode;
import com.alipay.sofa.sofamq.client.function.Predicate;
import com.alipay.sofa.sofamq.client.schema.NoopSchemaValidator;
import com.alipay.sofa.sofamq.client.schema.OpenMetaBasedSchemaProvider;
import com.alipay.sofa.sofamq.client.schema.SchemaProvider;
import com.alipay.sofa.sofamq.client.schema.SchemaValidator;
import com.alipay.sofa.sofamq.client.schema.SofaMQSchemaValidator;
import com.alipay.sofa.sofamq.client.trace.dispatch.AsyncDispatcher;
import com.alipay.sofa.sofamq.client.util.Arguments;
import com.alipay.sofa.sofamq.client.util.DevGroupUtils;
import com.alipay.sofa.sofamq.org.shade.apache.commons.lang3.StringUtils;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.consumer.MessageSelector;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.exception.MQClientException;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.impl.producer.DefaultMQProducerImpl;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.producer.SendResult;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.UtilAll;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.namesrv.TopAddressing;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.logging.InternalLogger;
import io.openmessaging.api.OMSResponseStatus;
import io.openmessaging.api.exception.OMSRuntimeException;
import io.openmessaging.api.exception.OMSTimeOutException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class SofaMQClientAbstract {
    private static final InternalLogger LOGGER = ClientLoggerUtil.getClientLogger();
    protected final Properties properties;
    protected final SessionCredentials sessionCredentials = new SessionCredentials();
    protected String nameServerAddr;
    protected String dataCenter;
    protected String cell;
    protected boolean ldc;
    protected boolean antfinMode;
    protected boolean shared;
    protected AsyncDispatcher traceDispatcher = null;
    protected final AtomicBoolean started = new AtomicBoolean(false);
    private final ScheduledExecutorService scheduledExecutorService = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "SofaMQClient-UpdateNameServerThread");
        }
    });
    protected SchemaProvider schemaProvider;
    protected SchemaValidator schemaValidator;

    public SofaMQClientAbstract(final Properties properties) {
        this.fillSystemProperty(properties, "instanceId", "com.alipay.instanceid", "SOFAMQ_DEFAULT_INS");
        this.fillSystemProperty(properties, "cell", "com.alipay.ldc.zone");
        this.fillSystemProperty(properties, "ldc", "zmode");
        this.fillSystemProperty(properties, "accessKey", "com.antcloud.mw.access", "SOFAMQ_DEFAULT_AK");
        this.fillSystemProperty(properties, "secretKey", "com.antcloud.mw.secret", "SOFAMQ_DEFAULT_SK");
        this.fillSystemProperty(properties, "dataCenter", "com.alipay.ldc.datacenter");
        this.fillSystemProperty(properties, "shared", "com.alipay.env");
        this.properties = properties;
        this.updateCredential(properties);
        this.shared = "shared".equals(this.properties.getProperty("shared"));
        String endpoint = this.properties.getProperty("endpoint");
        if (endpoint != null && !this.shared) {
            this.fillMissingProperty(MQUtil.splitQuery(endpoint), this.properties);
            this.fillMissingProperty(MQUtil.getEndpointImpliedInfo(endpoint), this.properties);
            if ((!this.properties.containsKey("cell") || StringUtils.isBlank(this.properties.get("cell").toString())) && StringUtils.isNotBlank(MQUtil.getLocalCell())) {
                this.properties.put("cell", MQUtil.getLocalCell());
            }
        }
        String instanceId = this.properties.getProperty("instanceId");
        this.ldc = "true".equals(this.properties.get("ldc"));
        this.cell = StringUtils.upperCase(this.properties.getProperty("cell"));
        if (this.cell != null) {
            this.properties.put("cell", this.cell);
        }
        this.antfinMode = "antfin".equals(this.properties.getProperty("site"));
        if ((this.ldc || this.antfinMode) && this.cell == null) {
            throw new OMSRuntimeException(String.format("please set Cell. [props:%s]", properties));
        }
        this.dataCenter = properties.getProperty("dataCenter");
        if (endpoint == null) {
            if (this.shared) {
                String endpointAddr = System.getProperty("com.antcloud.antvip.endpoint");
                if (endpointAddr != null) {
                    this.properties.put("endpoint", String.format("acvip://%s/%s-%s", endpointAddr, instanceId, "SOFAMQ"));
                }
            } else if (this.ldc || this.antfinMode) {
                this.properties.put("endpoint", String.format("antvip://antvip-pool/sofamqnamesrv-pool.%s.alipay.com", this.cell));
            }
        }
        this.nameServerAddr = this.fetchNameServerAddr();
        if (null == this.nameServerAddr) {
            throw new OMSRuntimeException("Can not find name server, May be your network problem.");
        }
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    String nsAddrs = SofaMQClientAbstract.this.fetchNameServerAddr();
                    if (nsAddrs != null && !SofaMQClientAbstract.this.nameServerAddr.equals(nsAddrs)) {
                        SofaMQClientAbstract.this.nameServerAddr = nsAddrs;
                        if (SofaMQClientAbstract.this.isStarted()) {
                            SofaMQClientAbstract.this.updateNameServerAddr(nsAddrs);
                        }
                    }
                }
                catch (Throwable e) {
                    LOGGER.error("update name server periodically failed. [props:%s]", (Object)properties, (Object)e);
                }
            }
        }, 10000L, 90000L, TimeUnit.MILLISECONDS);
        String openMetaUrl = properties.getProperty("schemaRegistryUrl");
        if (!Arguments.isEmpty(openMetaUrl)) {
            LOGGER.info("init openmeta client with {}", (Object)openMetaUrl);
            AntVIPBasedServerAddressing serverAddressing = new AntVIPBasedServerAddressing(openMetaUrl);
            this.schemaProvider = new OpenMetaBasedSchemaProvider(new DefaultOpenMetaClient(serverAddressing, new ClientOption[0]));
            this.schemaValidator = new SofaMQSchemaValidator(this.schemaProvider);
        } else {
            this.schemaValidator = new NoopSchemaValidator();
        }
    }

    protected abstract void updateNameServerAddr(String var1);

    private void fillSystemProperty(Properties properties, String propertyKey, String systemPropertyKey) {
        this.fillSystemProperty(properties, propertyKey, systemPropertyKey, null);
    }

    private void fillSystemProperty(Properties properties, String propertyKey, String systemPropertyKey, String defaultValue) {
        if (properties.getProperty(propertyKey) == null) {
            String value = System.getProperty(systemPropertyKey);
            if (StringUtils.isNotBlank(value)) {
                properties.put(propertyKey, value);
            } else if (defaultValue != null) {
                properties.put(propertyKey, defaultValue);
            }
        }
    }

    private void fillMissingProperty(Map<String, String> src, Properties dest) {
        for (String key : src.keySet()) {
            if (dest.containsKey(key)) continue;
            dest.put(key, src.get(key));
        }
    }

    private String fetchNameServerAddr() {
        String nsAddrs = null;
        String endpoint = this.properties.getProperty("endpoint");
        if (endpoint != null) {
            if (endpoint.startsWith("acvip://")) {
                final HashSet dataCenters = new HashSet();
                final LinkedList<RealNode> realNodes = new LinkedList<RealNode>();
                String instanceId = this.properties.getProperty("instanceId");
                nsAddrs = new AntVipAddressing(endpoint).instanceId(instanceId).accessKey(this.properties.getProperty("accessKey")).secretKey(this.properties.getProperty("secretKey")).fetchNSAddr(new Predicate<RealNode>(){

                    @Override
                    public boolean test(RealNode realNode) {
                        if (StringUtils.isNotBlank(realNode.getDataCenter())) {
                            dataCenters.add(realNode.getDataCenter());
                        }
                        realNodes.add(realNode);
                        return StringUtils.equals(SofaMQClientAbstract.this.dataCenter, realNode.getDataCenter()) || StringUtils.isBlank(SofaMQClientAbstract.this.dataCenter) && StringUtils.isBlank(realNode.getDataCenter());
                    }
                });
                if (nsAddrs == null && dataCenters.size() < 2) {
                    nsAddrs = AntVipAddressing.combineAddrs(realNodes, AntVipAddressing.MATCH_ALL);
                }
                if (nsAddrs == null && dataCenters.size() != 0) {
                    throw new OMSRuntimeException(String.format("Can not find name server with endpoint[%s] dataCenter[%s], available dataCenter %s.\nYou can set dataCenter in two ways:\n1. set (PropertyKeyConst.DATA_CENTER, xxx) when init AccessPoint.\n2. set java vm option -Dcom.alipay.ldc.datacenter=xxx. [props:%s]", endpoint, this.dataCenter, dataCenters, this.properties));
                }
                if (nsAddrs == null && StringUtils.isNotBlank(this.dataCenter)) {
                    throw new OMSRuntimeException(String.format("Can not find name server with endpoint[%s] dataCenter[%s], available dataCenter %s.\nYou can remove dataCenter setting or set dataCenter to empty. [props:%s]", endpoint, this.dataCenter, dataCenters, this.properties));
                }
                if (nsAddrs == null && realNodes.size() == 0) {
                    throw new OMSRuntimeException(String.format("Can not find name server with endpoint[%s] instanceId[%s], please check whether config is correct. [props:%s]", endpoint, instanceId, this.properties));
                }
            } else {
                nsAddrs = endpoint.startsWith("antvip://") ? new AntVipAddressing(endpoint).fetchNSAddr() : (endpoint.startsWith("namesrv://") ? endpoint.replaceFirst("namesrv://", "") : new TopAddressing(endpoint).fetchNSAddr());
            }
        }
        if (nsAddrs != null) {
            LOGGER.info("connected to endpoint {} success, {}", (Object)endpoint, (Object)nsAddrs);
            return nsAddrs;
        }
        throw new OMSRuntimeException(String.format("Can not find name server with endpoint %s. [props:%s]", endpoint, this.properties));
    }

    public String getNameServerAddr() {
        return this.nameServerAddr;
    }

    protected String buildInstanceName() {
        String extInfo;
        if (DevGroupUtils.clientEnableDevGroup()) {
            String devGroupName = DevGroupUtils.getDevGroupNameFromEnv();
            extInfo = ClientId.key2Base64("0", this.dataCenter, "1", devGroupName);
        } else {
            extInfo = ClientId.key2Base64("0", this.dataCenter);
        }
        return Integer.toHexString(UtilAll.getPid()) + "#" + Integer.toHexString(this.nameServerAddr.hashCode()) + "#" + Long.toHexString(System.nanoTime()) + "#" + extInfo;
    }

    protected String getNamespace() {
        String namespace = null;
        String namespaceFromProperty = this.properties.getProperty("instanceId", null);
        if (StringUtils.isNotEmpty(namespaceFromProperty)) {
            namespace = namespaceFromProperty;
            LOGGER.info("User specify namespace by property: {}.", (Object)namespace);
        }
        if (this.ldc || this.antfinMode) {
            namespace = namespace + "|" + this.cell;
        }
        return namespace;
    }

    protected void checkProducerServiceState(DefaultMQProducerImpl producer) {
        switch (producer.getServiceState()) {
            case CREATE_JUST: {
                throw new OMSRuntimeException(String.format("You do not have start the producer[" + UtilAll.getPid() + "], %s", new Object[]{producer.getServiceState()}));
            }
            case SHUTDOWN_ALREADY: {
                throw new OMSRuntimeException(String.format("Your producer has been shut down, %s", new Object[]{producer.getServiceState()}));
            }
            case START_FAILED: {
                throw new OMSRuntimeException(String.format("When you start your service throws an exception, %s", new Object[]{producer.getServiceState()}));
            }
            case RUNNING: {
                break;
            }
        }
    }

    public void start() {
        if (null != this.traceDispatcher) {
            try {
                this.traceDispatcher.start();
            }
            catch (MQClientException e) {
                LOGGER.warn("trace dispatcher start failed ", e);
            }
        }
    }

    public void updateCredential(Properties credentialProperties) {
        if (null == credentialProperties.getProperty("accessKey") || "".equals(credentialProperties.getProperty("accessKey"))) {
            throw new OMSRuntimeException("update credential failed. please set access key.");
        }
        if (null == credentialProperties.getProperty("secretKey") || "".equals(credentialProperties.getProperty("secretKey"))) {
            throw new OMSRuntimeException("update credential failed. please set secret key");
        }
        this.sessionCredentials.updateContent(credentialProperties);
    }

    public void shutdown() {
        if (null != this.traceDispatcher) {
            this.traceDispatcher.shutdown();
        }
        if (this.schemaProvider != null) {
            try {
                this.schemaProvider.close();
            }
            catch (Exception e) {
                LOGGER.warn("close SchemaProvider exception", e);
            }
        }
        this.scheduledExecutorService.shutdown();
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public boolean isClosed() {
        return !this.isStarted();
    }

    protected void checkSendResultRMQ(SendResult sendResult) throws OMSRuntimeException {
        if (sendResult == null) {
            return;
        }
        switch (sendResult.getSendStatus()) {
            case SEND_OK: {
                return;
            }
            case FLUSH_DISK_TIMEOUT: 
            case FLUSH_SLAVE_TIMEOUT: {
                throw new OMSTimeOutException(OMSResponseStatus.STATUS_1504.getStatusCode(), sendResult.getSendStatus().name());
            }
            case SLAVE_NOT_AVAILABLE: {
                throw new OMSTimeOutException(OMSResponseStatus.STATUS_1503.getStatusCode(), "SLAVE_NOT_AVAILABLE");
            }
        }
        throw new OMSRuntimeException(String.format("Unknown response %s", sendResult.getSendStatus().name()));
    }

    protected MessageSelector toMessageSelector(io.openmessaging.api.MessageSelector selector) {
        MessageSelector messageSelector;
        String subExpression = "*";
        String type = "TAG";
        if (selector != null) {
            if (selector.getType() == null) {
                throw new OMSRuntimeException("Expression type is null!");
            }
            subExpression = selector.getSubExpression();
            type = selector.getType().name();
        }
        if ("SQL92".equals(type)) {
            messageSelector = MessageSelector.bySql(subExpression);
        } else if ("TAG".equals(type)) {
            messageSelector = MessageSelector.byTag(subExpression);
        } else {
            throw new OMSRuntimeException(String.format("Expression type %s is unknown!", type));
        }
        return messageSelector;
    }
}

