/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.client.address;

import com.alipay.sofa.cloud.auth.BasicCredentials;
import com.alipay.sofa.cloud.auth.HmacSHA256Signer;
import com.alipay.sofa.sofamq.client.ClientLoggerUtil;
import com.alipay.sofa.sofamq.client.MQUtil;
import com.alipay.sofa.sofamq.client.address.AntvipDirectRequestUtil;
import com.alipay.sofa.sofamq.client.address.PollingRequest;
import com.alipay.sofa.sofamq.client.address.RealNode;
import com.alipay.sofa.sofamq.client.function.Predicate;
import com.alipay.sofa.sofamq.client.util.HttpTinyClientExt;
import com.alipay.sofa.sofamq.com.shade.alibaba.fastjson.JSON;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.AntVipClient;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.AntVipConfigure;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.DefaultAntVipClient;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.RealServer;
import com.alipay.sofa.sofamq.org.shade.apache.commons.lang3.StringUtils;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.utils.HttpTinyClient;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.logging.InternalLogger;
import io.openmessaging.api.exception.OMSRuntimeException;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AntVipAddressing {
    private static final InternalLogger log = ClientLoggerUtil.getClientLogger();
    public static final String PRODUCT_NAME = "SOFAMQ";
    private static final String APP_NAME = "sofamq";
    private static final String ANTVIP_ENDPOINT_ENFORCE = "com.alipay.antvip.endpoint.enforce";
    private static final int DEFAULT_PORT = Integer.valueOf(System.getProperty("com.alipay.sofamq.namesrv.port", "9876"));
    private static final String ACVIP_PATH = ":9003/antcloud/antvip/instances/get";
    public static final Predicate<RealNode> MATCH_ALL = new Predicate<RealNode>(){

        @Override
        public boolean test(RealNode realNode) {
            return true;
        }
    };
    private static final Map<String, AntVipClient> antVipClientMap = new ConcurrentHashMap<String, AntVipClient>();
    private static final Map<String, String> endpoint2domain = new ConcurrentHashMap<String, String>();
    public static Pattern shortDomainPattern = Pattern.compile("antvip://(.*/)?[^.]*");
    public static Pattern shortEndpointPattern = Pattern.compile("antvip://([^/]*)");
    public static Pattern longEndpointPattern = Pattern.compile("antvip://([^/]*)/([^/]*)");
    private AntVipClient antVipClient;
    private String endpoint;
    private Mode mode;
    private String instanceId;
    private String accessKey;
    private String secretKey;
    private String domain;
    private Set<String> dataCenters;

    public AntVipAddressing(String endpoint) {
        try {
            URI uri = new URI(endpoint);
            if ("acvip".equals(uri.getScheme())) {
                this.mode = Mode.ACVIP;
                this.dataCenters = uri.getQuery() == null ? Collections.emptySet() : new HashSet<String>(Arrays.asList(HttpTinyClientExt.splitQuery(uri.getQuery()).get("dataCenters").split(",")));
                this.endpoint = uri.getAuthority();
                if (StringUtils.isNotBlank(uri.getPath())) {
                    this.domain = uri.getPath().substring(1);
                }
            } else {
                this.mode = Mode.ANTVIP;
                this.antVipClient = this.getAntVipClient(endpoint.split("\\?")[0]);
            }
        }
        catch (Exception e) {
            throw new OMSRuntimeException("bad endpoint uri " + endpoint, (Throwable)e);
        }
    }

    public AntVipAddressing instanceId(String instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    public AntVipAddressing accessKey(String accessKey) {
        this.accessKey = accessKey;
        return this;
    }

    public AntVipAddressing secretKey(String secretKey) {
        this.secretKey = secretKey;
        return this;
    }

    public String fetchNSAddr() {
        if (this.mode == Mode.ANTVIP) {
            return this.fetchAntvipAddress();
        }
        if (this.mode == Mode.ACVIP && !this.dataCenters.isEmpty()) {
            return this.fetchNSAddr(this.domain, new Predicate<RealNode>(){

                @Override
                public boolean test(RealNode realNode) {
                    return AntVipAddressing.this.dataCenters.contains(realNode.getDataCenter());
                }
            });
        }
        return this.fetchNSAddr(this.domain, MATCH_ALL);
    }

    public String fetchNSAddr(Predicate<RealNode> matcher) {
        return this.fetchNSAddr(this.domain, matcher);
    }

    public String fetchAntvipAddress() {
        try {
            StringBuilder nsAddr = new StringBuilder();
            List<RealServer> servers = this.antVipClient.getRealServers(this.domain);
            for (RealServer server : servers) {
                nsAddr.append(server.getIp()).append(":").append(DEFAULT_PORT).append(";");
            }
            return nsAddr.length() == 0 ? null : nsAddr.toString();
        }
        catch (Exception e) {
            throw new OMSRuntimeException(String.format("fetch name server address from %s fail", this.endpoint), (Throwable)e);
        }
    }

    private String fetchNSAddr(String domainName, Predicate<RealNode> matcher) {
        if (domainName == null && this.mode == Mode.ACVIP) {
            domainName = this.instanceId + "-" + PRODUCT_NAME;
        }
        String reqUrl = "http://" + this.endpoint + ACVIP_PATH;
        PollingRequest request = AntvipDirectRequestUtil.buildVipDomainRequest(domainName, APP_NAME);
        HashMap<String, Object> extParams = new HashMap<String, Object>();
        extParams.put("appName", APP_NAME);
        extParams.putAll(this.buildSecurityContext());
        request.setExtensionParams(extParams);
        String requestStr = JSON.toJSONString(request);
        try {
            HttpTinyClient.HttpResult result = HttpTinyClientExt.httpPostJSON(reqUrl, null, requestStr, "UTF-8", 10000L);
            if (result.code != 200) {
                log.error("fetch name server address fail, {}", (Object)JSON.toJSONString(result));
                return null;
            }
            String responseStr = result.content;
            List<RealNode> realNodes = AntvipDirectRequestUtil.parseToRealNodes(responseStr, domainName);
            return AntVipAddressing.combineAddrs(realNodes, matcher);
        }
        catch (IOException e) {
            log.error("fetch name server address exception", e);
            throw new OMSRuntimeException(String.format("fetch name server address from %s fail", this.endpoint), (Throwable)e);
        }
    }

    public static String combineAddrs(List<RealNode> realNodes, Predicate<RealNode> matcher) {
        StringBuilder nsAddr = new StringBuilder();
        for (RealNode node : realNodes) {
            if (!node.isAvailable() || matcher != null && !matcher.test(node)) continue;
            nsAddr.append(node.getIp()).append(":").append(DEFAULT_PORT).append(";");
        }
        return nsAddr.length() == 0 ? null : nsAddr.toString();
    }

    private Map<String, Object> buildSecurityContext() {
        HashMap<String, Object> extParams = new HashMap<String, Object>();
        if (StringUtils.isBlank(this.accessKey) || StringUtils.isBlank(this.secretKey)) {
            return extParams;
        }
        Long cacheTime = 300000L;
        Long timestamp = System.currentTimeMillis() / cacheTime * cacheTime;
        String content = this.instanceId + timestamp;
        extParams.put("accessKey", this.accessKey);
        extParams.put("accessInstanceId", this.instanceId);
        extParams.put("accessAlgorithm", "HmacSHA256");
        extParams.put("accessContent", this.instanceId + timestamp);
        String signature = HmacSHA256Signer.INSTANCE.sign(content.getBytes(Charset.forName("UTF-8")), new BasicCredentials(this.accessKey, this.secretKey));
        extParams.put("accessSignature", signature);
        extParams.put("accessTimestamp", String.valueOf(timestamp));
        return extParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AntVipClient getAntVipClient(String endpoint) {
        Matcher shortDomainMatcher = shortDomainPattern.matcher(endpoint);
        if (shortDomainMatcher.matches()) {
            if (StringUtils.isBlank(MQUtil.getLocalDomainName())) {
                throw new OMSRuntimeException(String.format("short domain endpoint %s is incomplete, cannot find domainname from server.conf", endpoint));
            }
            endpoint = endpoint + "." + MQUtil.getLocalDomainName();
        }
        this.antVipClient = antVipClientMap.get(endpoint);
        if (this.antVipClient != null) {
            this.domain = endpoint2domain.get(endpoint);
            return this.antVipClient;
        }
        Map<String, AntVipClient> map = antVipClientMap;
        synchronized (map) {
            Matcher longEndpointMatcher;
            this.antVipClient = antVipClientMap.get(endpoint);
            if (this.antVipClient != null) {
                this.domain = endpoint2domain.get(endpoint);
                return this.antVipClient;
            }
            AntVipConfigure config = new AntVipConfigure();
            config.setAppName(APP_NAME);
            Matcher shortEndpointMatcher = shortEndpointPattern.matcher(endpoint);
            if (shortEndpointMatcher.matches()) {
                this.domain = shortEndpointMatcher.group(1);
            }
            if ((longEndpointMatcher = longEndpointPattern.matcher(endpoint)).matches()) {
                config.setEndpoint(longEndpointMatcher.group(1));
                if (StringUtils.isBlank(System.getProperty(ANTVIP_ENDPOINT_ENFORCE))) {
                    System.setProperty(ANTVIP_ENDPOINT_ENFORCE, "true");
                }
                this.domain = longEndpointMatcher.group(2);
            }
            this.antVipClient = new DefaultAntVipClient(config);
            endpoint2domain.put(endpoint, this.domain);
            antVipClientMap.put(endpoint, this.antVipClient);
        }
        this.endpoint = endpoint;
        return this.antVipClient;
    }

    static enum Mode {
        ANTVIP,
        ACVIP;

    }
}

