/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.client.address;

import com.alipay.sofa.sofamq.client.address.PollingRequest;
import com.alipay.sofa.sofamq.client.address.PollingResponse;
import com.alipay.sofa.sofamq.client.address.RealNode;
import com.alipay.sofa.sofamq.client.address.VipDomain;
import com.alipay.sofa.sofamq.com.shade.alibaba.fastjson.JSON;
import com.alipay.sofa.sofamq.org.shade.apache.commons.lang3.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class AntvipDirectRequestUtil {
    public static final String CHECKSUM_NO_DATA = "N";
    public static final String PARAM_FROM_CLIENT_SUFFIX = "-client";
    public static final String HTTP_DIRECT_REQUEST_JSON = "direct_http_json";

    public static List<RealNode> parseToRealNodes(String data, String domainName) {
        VipDomain vipDomain = AntvipDirectRequestUtil.parseToVipDomain(data, domainName);
        if (null == vipDomain || null == vipDomain.getRealNodes()) {
            return new ArrayList<RealNode>();
        }
        return vipDomain.getRealNodes();
    }

    public static VipDomain parseToVipDomain(String data, String domainName) {
        PollingResponse pollingResponse = JSON.parseObject(data, PollingResponse.class);
        if (null != pollingResponse.getVipDomains()) {
            for (VipDomain vipDomain : pollingResponse.getVipDomains()) {
                if (!StringUtils.equals(domainName, vipDomain.getName())) continue;
                return vipDomain;
            }
        }
        return null;
    }

    public static PollingRequest buildVipDomainRequest(String domain, String appName) {
        if (StringUtils.isEmpty(domain)) {
            throw new IllegalArgumentException("domain should not be empty");
        }
        PollingRequest request = AntvipDirectRequestUtil.buildBase(appName);
        HashMap<String, String> vipDomainName2ChecksumMap = new HashMap<String, String>();
        vipDomainName2ChecksumMap.put(domain, CHECKSUM_NO_DATA);
        request.setVipDomainName2ChecksumMap(vipDomainName2ChecksumMap);
        return request;
    }

    private static PollingRequest buildBase(String appName) {
        PollingRequest request = new PollingRequest();
        request.setAllowPolling(false);
        request.setFrom(appName + PARAM_FROM_CLIENT_SUFFIX);
        request.setStartTime(System.currentTimeMillis());
        request.setClientVersion(HTTP_DIRECT_REQUEST_JSON);
        return request;
    }
}

