/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.client.codec;

import com.alipay.openmeta.exception.SchemaNotExistException;
import com.alipay.sofa.sofamq.client.codec.MessageDecoder;
import com.alipay.sofa.sofamq.client.schema.SchemaProvider;
import com.alipay.sofa.sofamq.client.util.Arguments;
import io.openmessaging.api.Message;

public class SpecificDecoder<T>
implements MessageDecoder<T> {
    private Class userClazz;
    private SchemaProvider schemaProvider;

    public SpecificDecoder(Class<T> userClazz, SchemaProvider schemaProvider) {
        this.userClazz = userClazz;
        this.schemaProvider = schemaProvider;
    }

    @Override
    public T decode(Message message) {
        if (byte[].class.equals((Object)this.userClazz)) {
            return (T)message.getBody();
        }
        String schemaIdStr = message.getSystemProperties("__SCHEMA.ID");
        if (Arguments.isEmpty(schemaIdStr)) {
            throw new IllegalArgumentException("message has not 'schemaId' property");
        }
        long schemaId = Long.valueOf(schemaIdStr);
        try {
            return this.schemaProvider.getReadSchema(schemaId, this.userClazz).decode(message.getBody());
        }
        catch (SchemaNotExistException e) {
            throw new RuntimeException(e);
        }
    }
}

