/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.client.elastic;

import com.alipay.sofa.sofamq.client.MQUtil;
import com.alipay.sofa.sofamq.client.OrderConsumerImpl;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.utils.ThreadUtils;
import io.openmessaging.api.MessageSelector;
import io.openmessaging.api.order.GenericMessageOrderListener;
import io.openmessaging.api.order.MessageOrderListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class ElasticOrderConsumerImpl
extends OrderConsumerImpl {
    private static final ScheduledExecutorService scheduler = ThreadUtils.newSingleThreadScheduledExecutor("SofaMQElasticMetaSync", false);
    private Map<String, OrderConsumerImpl> elasticConsumers = new ConcurrentHashMap<String, OrderConsumerImpl>();
    private Properties baseProperties;
    private Map<String, Object[]> subscription = new HashMap<String, Object[]>();
    private ScheduledFuture elasticSyncFuture;

    public ElasticOrderConsumerImpl(Properties properties) {
        super(properties);
        this.baseProperties = properties;
    }

    @Override
    public synchronized void subscribe(String topic, String subExpression, MessageOrderListener listener) {
        super.subscribe(topic, subExpression, listener);
        this.subscription.put(topic, new Object[]{subExpression, listener});
        for (OrderConsumerImpl consumer : this.elasticConsumers.values()) {
            consumer.subscribe(topic, subExpression, listener);
        }
    }

    @Override
    public synchronized void subscribe(String topic, MessageSelector selector, MessageOrderListener listener) {
        super.subscribe(topic, selector, listener);
        this.subscription.put(topic, new Object[]{selector, listener});
        for (OrderConsumerImpl consumer : this.elasticConsumers.values()) {
            consumer.subscribe(topic, selector, listener);
        }
    }

    @Override
    public synchronized <T> void subscribe(String topic, String subExpression, GenericMessageOrderListener<T> listener) {
        super.subscribe(topic, subExpression, listener);
        this.subscription.put(topic, new Object[]{subExpression, listener});
        for (OrderConsumerImpl consumer : this.elasticConsumers.values()) {
            consumer.subscribe(topic, subExpression, listener);
        }
    }

    @Override
    public synchronized <T> void subscribe(String topic, MessageSelector selector, GenericMessageOrderListener<T> listener) {
        super.subscribe(topic, selector, listener);
        this.subscription.put(topic, new Object[]{selector, listener});
        for (OrderConsumerImpl consumer : this.elasticConsumers.values()) {
            consumer.subscribe(topic, selector, listener);
        }
    }

    @Override
    public synchronized void unsubscribe(String topic) {
        super.unsubscribe(topic);
        this.subscription.remove(topic);
        for (OrderConsumerImpl consumer : this.elasticConsumers.values()) {
            consumer.unsubscribe(topic);
        }
    }

    @Override
    public void start() {
        super.start();
        if ("antfin".equals(this.baseProperties.getProperty("site")) && this.elasticSyncFuture == null) {
            this.elasticSyncFuture = scheduler.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    try {
                        ElasticOrderConsumerImpl.this.syncElasticCells();
                    }
                    catch (Exception e) {
                        LOGGER.warn("elasticSyncFuture wait ex", e);
                    }
                }
            }, 0L, 30L, TimeUnit.SECONDS);
        }
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.elasticSyncFuture != null) {
            this.elasticSyncFuture.cancel(true);
            try {
                this.elasticSyncFuture.get();
            }
            catch (Exception e) {
                LOGGER.warn("elasticSyncFuture wait ex", e);
            }
            for (OrderConsumerImpl consumer : this.elasticConsumers.values()) {
                consumer.shutdown();
            }
            this.elasticConsumers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncElasticCells() throws Exception {
        Map<String, String> elasticCells = this.getElasticCells();
        if (elasticCells == null) {
            return;
        }
        for (String elasticCell : elasticCells.keySet()) {
            if (this.elasticConsumers.containsKey(elasticCell)) continue;
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)this.baseProperties);
            properties.put("cell", elasticCell);
            MQUtil.replaceEndpoint(properties, elasticCells.get(elasticCell));
            try {
                OrderConsumerImpl consumer = new OrderConsumerImpl(properties);
                ElasticOrderConsumerImpl elasticOrderConsumerImpl = this;
                synchronized (elasticOrderConsumerImpl) {
                    for (Map.Entry<String, Object[]> entry : this.subscription.entrySet()) {
                        if (entry.getValue()[0] instanceof String && entry.getValue()[1] instanceof MessageOrderListener) {
                            consumer.subscribe(entry.getKey(), (String)entry.getValue()[0], (MessageOrderListener)entry.getValue()[1]);
                            continue;
                        }
                        if (entry.getValue()[0] instanceof MessageSelector && entry.getValue()[1] instanceof MessageOrderListener) {
                            consumer.subscribe(entry.getKey(), (MessageSelector)entry.getValue()[0], (MessageOrderListener)entry.getValue()[1]);
                            continue;
                        }
                        if (entry.getValue()[0] instanceof String && entry.getValue()[1] instanceof GenericMessageOrderListener) {
                            consumer.subscribe(entry.getKey(), (String)entry.getValue()[0], (GenericMessageOrderListener)entry.getValue()[1]);
                            continue;
                        }
                        consumer.subscribe(entry.getKey(), (MessageSelector)entry.getValue()[0], (GenericMessageOrderListener)entry.getValue()[1]);
                    }
                    consumer.start();
                    LOGGER.info("start elastic {} consumer with props[{}]", (Object)elasticCell, (Object)properties);
                    this.elasticConsumers.put(elasticCell, consumer);
                }
            }
            catch (Throwable e) {
                LOGGER.warn("start elastic consumer fail, props[{}]", (Object)properties);
            }
        }
        for (String cell : this.elasticConsumers.keySet()) {
            if (elasticCells.containsKey(cell)) continue;
            OrderConsumerImpl consumer = this.elasticConsumers.remove(cell);
            consumer.shutdown();
            LOGGER.info("shutdown elastic {} consumer", (Object)cell);
        }
    }
}

