/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.client.rebalance;

import com.alipay.sofa.sofamq.client.ClientId;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.consumer.AllocateMessageQueueStrategy;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.consumer.rebalance.AllocateMessageQueueAveragely;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.message.MessageQueue;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class LocalFirstAllocateMessageQueueStrategy
implements AllocateMessageQueueStrategy {
    private static final String SOFAMQ_CID_COMPATIBLE_SUFFIX = "@SOFAMQ";
    private AllocateMessageQueueStrategy strategy;
    private AllocateMessageQueueStrategy antqStrategy = new AllocateMessageQueueAveragely();

    public LocalFirstAllocateMessageQueueStrategy(AllocateMessageQueueStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public List<MessageQueue> allocate(String consumerGroup, String currentCID, List<MessageQueue> mqAll, List<String> cidAll) {
        ClientId currentClientId = new ClientId(currentCID);
        LinkedList<ClientId> clientAll = new LinkedList<ClientId>();
        LinkedList<String> cidWithoutDataCenter = new LinkedList<String>();
        boolean antqCompatible = false;
        HashMap<String, LinkedList<String>> dataCenterCidMap = new HashMap<String, LinkedList<String>>();
        for (String string : cidAll) {
            ClientId clientId = new ClientId(string);
            if (clientId.isAntq()) {
                antqCompatible = true;
                break;
            }
            if (clientId.getDataCenter() == null) {
                cidWithoutDataCenter.add(string);
                continue;
            }
            clientAll.add(new ClientId(string));
            LinkedList<String> cidList = (LinkedList<String>)dataCenterCidMap.get(clientId.getDataCenter());
            if (cidList == null) {
                cidList = new LinkedList<String>();
                dataCenterCidMap.put(clientId.getDataCenter(), cidList);
            }
            cidList.add(string);
        }
        if (antqCompatible) {
            LinkedList<String> newCidAll = new LinkedList<String>();
            for (String cid : cidAll) {
                if (cid.startsWith("@ANTQ@")) {
                    newCidAll.add(cid.replaceFirst("@ANTQ@", ""));
                    continue;
                }
                newCidAll.add(cid + SOFAMQ_CID_COMPATIBLE_SUFFIX);
            }
            Collections.sort(newCidAll);
            return this.antqStrategy.allocate(consumerGroup, currentCID + SOFAMQ_CID_COMPATIBLE_SUFFIX, mqAll, newCidAll);
        }
        HashMap<String, LinkedList<MessageQueue>> dataCenterMessageQueuesMap = new HashMap<String, LinkedList<MessageQueue>>();
        for (MessageQueue messageQueue : mqAll) {
            String[] parts = messageQueue.getBrokerName().split("@");
            String dataCenter = parts.length > 1 ? parts[0] : "%SOFAMQ_DEFAULT%";
            LinkedList<MessageQueue> messageQueues = (LinkedList<MessageQueue>)dataCenterMessageQueuesMap.get(dataCenter);
            if (messageQueues == null) {
                messageQueues = new LinkedList<MessageQueue>();
                dataCenterMessageQueuesMap.put(dataCenter, messageQueues);
            }
            messageQueues.add(messageQueue);
        }
        LinkedList<MessageQueue> linkedList = new LinkedList<MessageQueue>();
        for (String dataCenter : dataCenterMessageQueuesMap.keySet()) {
            if (dataCenterCidMap.containsKey(dataCenter) && dataCenter.equals(currentClientId.getDataCenter())) {
                linkedList.addAll(this.strategy.allocate(consumerGroup, currentCID, (List)dataCenterMessageQueuesMap.get(dataCenter), (List)dataCenterCidMap.get(dataCenter)));
                continue;
            }
            if (dataCenterCidMap.containsKey(dataCenter)) continue;
            linkedList.addAll(this.strategy.allocate(consumerGroup, currentCID, (List)dataCenterMessageQueuesMap.get(dataCenter), cidAll));
        }
        return linkedList;
    }

    @Override
    public String getName() {
        return "LOCAL";
    }
}

