/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.client.schema;

import com.alipay.sofa.sofamq.client.schema.GenericAvroRecord;
import com.alipay.sofa.sofamq.client.schema.GenericAvroSchema;
import com.alipay.sofa.sofamq.client.schema.GenericRecordBuilder;
import io.openmessaging.api.schema.Field;
import org.apache.avro.generic.GenericRecord;

public class AvroRecordBuilderImpl
implements GenericRecordBuilder {
    private final GenericAvroSchema genericAvroSchema;
    private final org.apache.avro.generic.GenericRecordBuilder avroRecordBuilder;

    public AvroRecordBuilderImpl(GenericAvroSchema genericAvroSchema) {
        this.genericAvroSchema = genericAvroSchema;
        this.avroRecordBuilder = new org.apache.avro.generic.GenericRecordBuilder(this.genericAvroSchema.getAvroSchema());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public GenericRecordBuilder set(String fieldName, Object value) {
        if (value instanceof io.openmessaging.api.schema.GenericRecord) {
            if (!(value instanceof GenericAvroRecord)) throw new IllegalArgumentException("Avro Record Builder doesn't support non-avro record as a field");
            this.avroRecordBuilder.set(fieldName, (Object)((GenericAvroRecord)value).getAvroRecord());
            return this;
        } else {
            this.avroRecordBuilder.set(fieldName, value);
        }
        return this;
    }

    @Override
    public GenericRecordBuilder set(Field field, Object value) {
        return this.set(field.getName(), value);
    }

    @Override
    public GenericRecordBuilder clear(String fieldName) {
        this.avroRecordBuilder.clear(fieldName);
        return this;
    }

    @Override
    public GenericRecordBuilder clear(Field field) {
        return this.clear(field.getName());
    }

    @Override
    public io.openmessaging.api.schema.GenericRecord build() {
        return new GenericAvroRecord(this.genericAvroSchema.getAvroSchema(), this.genericAvroSchema.getFields(), (GenericRecord)this.avroRecordBuilder.build());
    }
}

