/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.client.schema;

import com.alipay.sofa.sofamq.client.util.Converter;
import io.openmessaging.api.schema.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;

public class GenericAvroRecord
implements io.openmessaging.api.schema.GenericRecord {
    private final Schema schema;
    private final GenericRecord record;
    private final List<Field> fields;
    private final String schemaId;

    public GenericAvroRecord(Schema schema, List<Field> fields, GenericRecord record) {
        this.schemaId = null;
        this.fields = fields;
        this.schema = schema;
        this.record = record;
    }

    public GenericAvroRecord(long schemaId, Schema schema, List<Field> fields, GenericRecord record) {
        this.schemaId = String.valueOf(schemaId);
        this.fields = fields;
        this.schema = schema;
        this.record = record;
    }

    @Override
    public String getSchemaId() {
        return this.schemaId;
    }

    @Override
    public List<Field> getFields() {
        return this.fields;
    }

    @Override
    public Object getField(Field field) {
        return this.getField(field.getName());
    }

    @Override
    public Object getField(String fieldName) {
        Object value = this.record.get(fieldName);
        if (value instanceof Utf8) {
            return ((Utf8)value).toString();
        }
        if (value instanceof GenericRecord) {
            GenericRecord avroRecord = (GenericRecord)value;
            Schema recordSchema = avroRecord.getSchema();
            ArrayList<Field> fields = new ArrayList<Field>();
            List fieldList = recordSchema.getFields();
            for (Schema.Field f : fieldList) {
                fields.add(Converter.toField(f));
            }
            return new GenericAvroRecord(this.schema, fields, avroRecord);
        }
        return value;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public GenericRecord getAvroRecord() {
        return this.record;
    }
}

