/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.client.schema;

import com.alipay.openmeta.exception.DecodeException;
import com.alipay.sofa.sofamq.client.schema.GenericAvroRecord;
import com.alipay.sofa.sofamq.client.util.Converter;
import io.openmessaging.api.schema.Field;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;

public class GenericAvroRecordDecoder
implements com.alipay.openmeta.common.Decoder<GenericAvroRecord> {
    private final GenericDatumReader<GenericRecord> reader;
    private final Schema schema;
    private final List<Field> fields;
    private static final ThreadLocal<BinaryDecoder> decoders = new ThreadLocal();

    public GenericAvroRecordDecoder(Schema schema) {
        this(null, schema);
    }

    public GenericAvroRecordDecoder(Schema writerSchema, Schema readerSchema) {
        this.schema = readerSchema;
        this.fields = new ArrayList<Field>();
        for (Schema.Field field : this.schema.getFields()) {
            this.fields.add(Converter.toField(field));
        }
        this.reader = writerSchema == null ? new GenericDatumReader(readerSchema) : new GenericDatumReader(writerSchema, readerSchema);
    }

    @Override
    public GenericAvroRecord decode(byte[] bytes) {
        try {
            BinaryDecoder decoderCache = decoders.get();
            BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(bytes, decoderCache);
            if (decoderCache == null) {
                decoders.set(decoder);
            }
            GenericRecord genericRecord = (GenericRecord)this.reader.read(null, (Decoder)decoder);
            return new GenericAvroRecord(this.schema, this.fields, genericRecord);
        }
        catch (IOException e) {
            throw new DecodeException(e);
        }
    }
}

