/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.client.schema;

import com.alipay.openmeta.exception.EncodeException;
import com.alipay.sofa.sofamq.client.schema.GenericAvroRecord;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;

public class GenericAvroRecordEncoder
implements com.alipay.openmeta.common.Encoder<GenericAvroRecord> {
    private final GenericDatumWriter<GenericRecord> writer;
    private static final ThreadLocal<BinaryEncoder> encoders = new ThreadLocal();
    private static final ThreadLocal<ByteArrayOutputStream> outputStreams = new ThreadLocal();

    public GenericAvroRecordEncoder(Schema schema) {
        this.writer = new GenericDatumWriter(schema);
    }

    @Override
    public byte[] encode(GenericAvroRecord data) {
        ByteArrayOutputStream outputStream = this.getOrCreateOutputStream();
        BinaryEncoder encoder = this.getOrCreateEncoder(outputStream);
        try {
            this.writer.write((Object)data.getAvroRecord(), (Encoder)encoder);
            encoder.flush();
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new EncodeException(e);
        }
        finally {
            outputStream.reset();
        }
    }

    private ByteArrayOutputStream getOrCreateOutputStream() {
        ByteArrayOutputStream outputStreamCache = outputStreams.get();
        if (outputStreamCache == null) {
            outputStreamCache = new ByteArrayOutputStream();
            outputStreams.set(outputStreamCache);
        }
        return outputStreamCache;
    }

    private BinaryEncoder getOrCreateEncoder(ByteArrayOutputStream outputStream) {
        BinaryEncoder encoderCache = encoders.get();
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)outputStream, encoderCache);
        if (encoderCache == null) {
            encoders.set(encoder);
        }
        return encoder;
    }
}

