/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.client.schema;

import com.alipay.openmeta.client.OpenMetaClient;
import com.alipay.openmeta.common.SchemaDetail;
import com.alipay.openmeta.common.SchemaInfo;
import com.alipay.openmeta.common.SchemaType;
import com.alipay.openmeta.common.SerializationType;
import com.alipay.openmeta.exception.SchemaNotExistException;
import com.alipay.openmeta.exception.SubjectNotExistException;
import com.alipay.openmeta.schema.AvroSchema;
import com.alipay.sofa.sofamq.client.schema.GenericAvroSchema;
import com.alipay.sofa.sofamq.client.schema.GenericSchema;
import com.alipay.sofa.sofamq.client.schema.SchemaProvider;
import com.alipay.sofa.sofamq.client.util.Pair;
import io.openmessaging.api.exception.OMSRuntimeException;
import io.openmessaging.api.schema.GenericRecord;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.avro.Schema;
import org.apache.avro.reflect.ReflectData;

public class OpenMetaBasedSchemaProvider
implements SchemaProvider {
    private final ConcurrentMap<Long, ConcurrentMap<Class, com.alipay.openmeta.schema.Schema>> readSchemaCache = new ConcurrentHashMap<Long, ConcurrentMap<Class, com.alipay.openmeta.schema.Schema>>();
    private final ConcurrentMap<Class, Pair<Long, com.alipay.openmeta.schema.Schema>> writeSchemaCache0 = new ConcurrentHashMap<Class, Pair<Long, com.alipay.openmeta.schema.Schema>>();
    private final ConcurrentMap<String, Pair<Long, com.alipay.openmeta.schema.Schema>> writeSchemaCache1 = new ConcurrentHashMap<String, Pair<Long, com.alipay.openmeta.schema.Schema>>();
    private final ConcurrentMap<String, Pair<Long, GenericSchema>> writeGenericSchemaCache = new ConcurrentHashMap<String, Pair<Long, GenericSchema>>();
    private final OpenMetaClient openMetaClient;

    public OpenMetaBasedSchemaProvider(OpenMetaClient openMetaClient) {
        this.openMetaClient = openMetaClient;
    }

    @Override
    public <T> boolean validateCompatibility(String topic, Class<T> tClass, boolean read) throws SubjectNotExistException, SchemaNotExistException {
        Schema schema = ReflectData.get().getSchema(tClass);
        return this.openMetaClient.checkReadCompatible(topic, SchemaType.AVRO, schema.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> com.alipay.openmeta.schema.Schema getReadSchema(long writerSchemaUniqueId, Class<T> readerClass) throws SchemaNotExistException {
        AvroSchema schema;
        ConcurrentHashMap cachedSchema = (ConcurrentHashMap)this.readSchemaCache.get(writerSchemaUniqueId);
        if (cachedSchema == null) {
            OpenMetaBasedSchemaProvider openMetaBasedSchemaProvider = this;
            synchronized (openMetaBasedSchemaProvider) {
                cachedSchema = (ConcurrentMap)this.readSchemaCache.get(writerSchemaUniqueId);
                if (cachedSchema == null) {
                    cachedSchema = new ConcurrentHashMap();
                    this.readSchemaCache.put(writerSchemaUniqueId, cachedSchema);
                }
            }
        }
        if ((schema = (AvroSchema)cachedSchema.get(readerClass)) == null) {
            OpenMetaBasedSchemaProvider openMetaBasedSchemaProvider = this;
            synchronized (openMetaBasedSchemaProvider) {
                schema = (com.alipay.openmeta.schema.Schema)cachedSchema.get(readerClass);
                if (schema == null) {
                    SchemaDetail schemaDetail = this.openMetaClient.getSchemaById(writerSchemaUniqueId);
                    if (schemaDetail.getType() != SchemaType.AVRO) {
                        throw new RuntimeException("unsupport schema type: " + schemaDetail.getType().name());
                    }
                    SchemaInfo writeSchema = new SchemaInfo();
                    writeSchema.setId(schemaDetail.getUniqId());
                    writeSchema.setVersion(schemaDetail.getVersion());
                    writeSchema.setSerializationType(schemaDetail.getSerialization());
                    writeSchema.setSchemaType(schemaDetail.getType());
                    writeSchema.setSchema(schemaDetail.getContent());
                    if (readerClass == GenericRecord.class) {
                        schema = new GenericAvroSchema(writeSchema);
                    } else {
                        SchemaInfo readSchema = new SchemaInfo();
                        readSchema.setSerializationType(SerializationType.AVRO);
                        readSchema.setSchemaType(SchemaType.AVRO);
                        readSchema.setSchema(ReflectData.get().getSchema(readerClass).toString());
                        schema = new AvroSchema(writeSchema, readSchema);
                    }
                    cachedSchema.put(readerClass, schema);
                }
            }
        }
        return schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pair<Long, com.alipay.openmeta.schema.Schema> getWriteSchema(String topic, String schema) throws SchemaNotExistException {
        Pair cachedSchema = (Pair)this.writeSchemaCache1.get(schema);
        if (cachedSchema == null) {
            OpenMetaBasedSchemaProvider openMetaBasedSchemaProvider = this;
            synchronized (openMetaBasedSchemaProvider) {
                cachedSchema = (Pair)this.writeSchemaCache1.get(schema);
                if (cachedSchema == null) {
                    SchemaInfo schemaInfo = this.getSchemaInfo(topic, schema);
                    AvroSchema avroSchema = new AvroSchema(schemaInfo);
                    cachedSchema = new Pair(schemaInfo.getId(), avroSchema);
                    this.writeSchemaCache1.put(schema, cachedSchema);
                }
            }
        }
        return cachedSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pair<Long, GenericSchema> getGenericWriteSchema(String topic, String schema) throws SchemaNotExistException {
        Pair<Long, GenericAvroSchema> cachedSchema = (Pair<Long, GenericAvroSchema>)this.writeGenericSchemaCache.get(schema);
        if (cachedSchema == null) {
            OpenMetaBasedSchemaProvider openMetaBasedSchemaProvider = this;
            synchronized (openMetaBasedSchemaProvider) {
                cachedSchema = (Pair)this.writeGenericSchemaCache.get(schema);
                if (cachedSchema == null) {
                    SchemaInfo schemaInfo = this.getSchemaInfo(topic, schema);
                    GenericAvroSchema genericSchema = new GenericAvroSchema(schemaInfo);
                    cachedSchema = new Pair<Long, GenericAvroSchema>(schemaInfo.getId(), genericSchema);
                    this.writeGenericSchemaCache.put(schema, cachedSchema);
                }
            }
        }
        return cachedSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Pair<Long, com.alipay.openmeta.schema.Schema> getWriteSchema(String topic, Class<T> tClass) throws SchemaNotExistException {
        Pair cachedSchema = (Pair)this.writeSchemaCache0.get(tClass);
        if (cachedSchema == null) {
            OpenMetaBasedSchemaProvider openMetaBasedSchemaProvider = this;
            synchronized (openMetaBasedSchemaProvider) {
                cachedSchema = (Pair)this.writeSchemaCache0.get(tClass);
                if (cachedSchema == null) {
                    String schemaContent = ReflectData.get().getSchema(tClass).toString();
                    SchemaInfo schemaInfo = this.getSchemaInfo(topic, schemaContent);
                    AvroSchema schema = new AvroSchema(schemaInfo);
                    cachedSchema = new Pair(schemaInfo.getId(), schema);
                    this.writeSchemaCache0.put(tClass, cachedSchema);
                }
            }
        }
        return cachedSchema;
    }

    private SchemaInfo getSchemaInfo(String topic, String schemaContent) throws SchemaNotExistException {
        SchemaDetail schemaDetail = this.openMetaClient.searchSchema(topic, schemaContent);
        if (schemaDetail.getType() != SchemaType.AVRO) {
            throw new OMSRuntimeException("unsupport schema type: " + (Object)((Object)schemaDetail.getType()));
        }
        SchemaInfo schemaInfo = new SchemaInfo();
        schemaInfo.setId(schemaDetail.getUniqId());
        schemaInfo.setVersion(schemaDetail.getVersion());
        schemaInfo.setSerializationType(schemaDetail.getSerialization());
        schemaInfo.setSchemaType(schemaDetail.getType());
        schemaInfo.setSchema(schemaDetail.getContent());
        return schemaInfo;
    }

    @Override
    public void close() throws Exception {
        this.openMetaClient.close();
    }
}

