/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.client.schema;

import com.alipay.openmeta.exception.SchemaNotExistException;
import com.alipay.openmeta.exception.SubjectNotExistException;
import com.alipay.openmeta.schema.Schema;
import com.alipay.sofa.sofamq.client.exception.ConfigurationException;
import com.alipay.sofa.sofamq.client.schema.GenericSchema;
import com.alipay.sofa.sofamq.client.schema.SchemaProvider;
import com.alipay.sofa.sofamq.client.schema.SchemaValidator;
import com.alipay.sofa.sofamq.client.util.Arguments;
import com.alipay.sofa.sofamq.client.util.Pair;
import io.openmessaging.api.exception.OMSRuntimeException;
import io.openmessaging.api.schema.GenericRecord;

public class SofaMQSchemaValidator
implements SchemaValidator {
    private SchemaProvider schemaProvider;

    public SofaMQSchemaValidator(SchemaProvider schemaProvider) {
        this.schemaProvider = schemaProvider;
    }

    @Override
    public Pair<Long, Schema> validateWriteSchema(String topic, Class clazz) {
        if (this.schemaProvider == null) {
            throw new IllegalStateException(String.format("schema is not enabled, topic=%s", topic));
        }
        try {
            return this.schemaProvider.getWriteSchema(topic, clazz);
        }
        catch (SchemaNotExistException e) {
            throw new ConfigurationException(String.format("schema enabled and no schema registered for %s of class: %s", topic, clazz.toString()), e);
        }
    }

    @Override
    public Pair<Long, GenericSchema> validateWriteGenericSchema(String topic, String schemaInfo) {
        if (this.schemaProvider == null) {
            throw new IllegalStateException(String.format("schema is not enabled, topic=%s", topic));
        }
        try {
            return this.schemaProvider.getGenericWriteSchema(topic, schemaInfo);
        }
        catch (SchemaNotExistException e) {
            throw new ConfigurationException(String.format("schema enabled and no schema registered for %s of schema: %s", topic, schemaInfo), e);
        }
    }

    @Override
    public boolean validateReadSchema(String topic, Class clazz) {
        boolean compatible;
        Arguments.requireNotNull(clazz, "payloadClass");
        if (GenericRecord.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (byte[].class.equals((Object)clazz)) {
            return true;
        }
        try {
            compatible = this.schemaProvider.validateCompatibility(topic, clazz, true);
        }
        catch (SubjectNotExistException e) {
            throw new OMSRuntimeException(String.format("subscribe topic(%s) exception", topic), (Throwable)e);
        }
        catch (SchemaNotExistException e) {
            throw new OMSRuntimeException(String.format("subscribe topic(%s) exception", topic), (Throwable)e);
        }
        return compatible;
    }
}

