/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.client.trace;

import com.alipay.common.tracer.context.MQLogContext;
import com.alipay.common.tracer.core.appender.builder.XStringBuilder;
import com.alipay.common.tracer.core.appender.encoder.SpanEncoder;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.middleware.messagequeue.digest.MQAbstractContextEncoder;
import com.alipay.common.tracer.tracer.MQTracer;
import com.alipay.common.tracer.util.Timestamp;

public class SofaBootMQTracer
extends MQTracer {
    protected SpanEncoder<SofaTracerSpan> getClientDigestEncoder() {
        return new MQAbstractContextEncoder(){

            protected void doEncode(SofaTracerSpan span) {
                this.appendSlot((XStringBuilder)this.xsb, (MQLogContext)span);
            }

            private void appendSlot(XStringBuilder xsb, MQLogContext ctx) {
                xsb.append(Timestamp.format((long)ctx.getLogTime())).append(ctx.getCurrentApp()).append(ctx.getTraceId()).append(ctx.getRpcId()).append(ctx.getMessageId()).append(ctx.getResultCode()).append(ctx.getTopic()).append(ctx.getTag()).append(ctx.getServer()).append(ctx.getQueueId()).append(ctx.getOffset()).append(ctx.getDelaySeconds()).append(ctx.getReconsumeTimes()).append(ctx.getMessageType()).append(ctx.getGroup()).append(ctx.getConsumeLatency() + "ms").append(ctx.getElapsedTime() + "ms").appendEscape(ctx.getCurrentThreadName()).append(ctx.getPenetrateSystemAttr()).appendEnd(ctx.getPenetrateAttributes());
            }
        };
    }

    protected SpanEncoder<SofaTracerSpan> getServerDigestEncoder() {
        return new MQAbstractContextEncoder(){

            protected void doEncode(SofaTracerSpan sofaTracerSpan) {
                this.appendSlot((XStringBuilder)this.xsb, (MQLogContext)sofaTracerSpan);
            }

            private void appendSlot(XStringBuilder xsb, MQLogContext ctx) {
                xsb.append(Timestamp.format((long)ctx.getLogTime())).append(ctx.getCurrentApp()).append(ctx.getTraceId()).append(ctx.getRpcId()).append(ctx.getMessageId()).append(ctx.getResultCode()).append(ctx.getTopic()).append(ctx.getTag()).append(ctx.getServer()).append(ctx.getQueueId()).append(ctx.getOffset()).append(this.getDefaultBooleanFlag(ctx.isBatchMessage())).append(ctx.getBatchSize()).append(ctx.getDelaySeconds()).append(ctx.getReconsumeTimes()).append(ctx.getMessageType()).append(ctx.getGroup()).append(ctx.getPubMode()).append(ctx.getElapsedTime() + "ms").appendEscape(ctx.getCurrentThreadName()).append(ctx.getPenetrateSystemAttr()).appendEnd(ctx.getPenetrateAttributes());
            }
        };
    }
}

