/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.client.trace;

import com.alipay.common.tracer.context.AbstractLogContext;
import com.alipay.common.tracer.context.MQLogContext;
import com.alipay.common.tracer.util.TracerContextUtil;
import com.alipay.common.tracer.util.TracerUtils;
import com.alipay.sofa.runtime.SofaFramework;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeManager;
import com.alipay.sofa.sofamq.client.ClientLoggerUtil;
import com.alipay.sofa.sofamq.client.trace.ConsumeMessageContext;
import com.alipay.sofa.sofamq.client.trace.MQTracer;
import com.alipay.sofa.sofamq.client.trace.SendMessageContext;
import com.alipay.sofa.sofamq.client.trace.utils.MixUtils;
import com.alipay.sofa.sofamq.org.shade.apache.commons.lang3.StringUtils;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.impl.CommunicationMode;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.producer.SendResult;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.producer.SendStatus;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.message.Message;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.message.MessageClientIDSetter;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.message.MessageExt;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.message.MessageType;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.protocol.NamespaceUtil;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.logging.InternalLogger;
import java.util.HashMap;

public class TraceUtils {
    private static final InternalLogger logger = ClientLoggerUtil.getClientLogger();
    private static final String NON_MESSAGE_ID = "";
    private static final int NON_QUEUE_ID = -1;
    private static final long NON_OFFSET = -1L;
    private static final String NON_BROKER = "";
    private static final String MQ_TRACER_CLASS_NAME = "com.alipay.common.tracer.tracer.MQTracer";
    private static final String SOFA_FRAMEWORK_CLASS_NAME = "com.alipay.sofa.runtime.SofaFramework";
    private static final String DEFAULT_APPNAME = "SOFAMQ";
    private static boolean traceEnable;
    private static volatile boolean traceOpened;
    private static volatile boolean sofaRuntime;
    private static String appName;
    private static volatile MQTracer mqTracer;

    public static boolean isTraceAble() {
        return traceEnable && traceOpened;
    }

    public static boolean isTraceEnable() {
        return traceEnable;
    }

    public static boolean isTraceOpened() {
        return traceOpened;
    }

    public static void openMQTrace() {
        traceOpened = true;
    }

    public static void closeMQTrace() {
        traceOpened = false;
    }

    public static MQLogContext startMsg() {
        if (!TraceUtils.isTraceAble()) {
            return null;
        }
        MQLogContext ctx = null;
        try {
            ctx = TraceUtils.getMQTracer().start();
            if (StringUtils.isBlank(ctx.getRpcId())) {
                ctx.setRpcId("0");
            }
        }
        catch (Throwable e) {
            logger.error("exception occurred when createMsg in TracerUtils", e);
        }
        return ctx;
    }

    public static SendMessageContext producerSendStart(Message msgRMQ) {
        SendMessageContext sendMessageContext = new SendMessageContext();
        sendMessageContext.setMessage(msgRMQ);
        if (msgRMQ.getProperty("TIMER_DELIVER_MS") != null || msgRMQ.getProperty("DELAY") != null) {
            sendMessageContext.setMsgType(MessageType.Delay_Msg);
        }
        if (!TraceUtils.isTraceAble()) {
            return sendMessageContext;
        }
        try {
            MQLogContext logContext = TraceUtils.startMsg();
            TraceUtils.convertTraceCtxToInnerCtx(logContext, msgRMQ);
            TraceUtils.getMQTracer().producerSend();
            AbstractLogContextWrapper wrapper = new AbstractLogContextWrapper();
            wrapper.set(TracerContextUtil.cloneLogContext());
            AbstractLogContext.set((AbstractLogContext)(null == AbstractLogContext.get() ? null : AbstractLogContext.get().getParentLogContext()));
            sendMessageContext.setMqTraceContext(wrapper);
        }
        catch (Throwable e) {
            logger.error("exception occurred when producerSendStart in TracerUtils", e);
        }
        return sendMessageContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void producerSendEnd(SendMessageContext ctx) {
        if (!TraceUtils.isTraceAble()) {
            return;
        }
        try {
            if (ctx.getMqTraceContext().exist()) {
                AbstractLogContext.set((AbstractLogContext)((AbstractLogContext)ctx.getMqTraceContext().get()));
            }
            MQLogContext logContext = TraceUtils.getMQTracer().getLogContext();
            logContext.setCurrentApp(TraceUtils.getAppName());
            SendResult sendResult = ctx.getSendResult();
            if (sendResult == null) {
                String msgId = MessageClientIDSetter.getUniqID(ctx.getMessage());
                logContext.setMessageId(StringUtils.isNotBlank(msgId) ? msgId : "");
                logContext.setQueueId(-1);
                logContext.setOffset(-1L);
                logContext.setServer("");
            } else {
                logContext.setMessageId(ctx.getSendResult().getMsgId());
                logContext.setQueueId(sendResult.getMessageQueue().getQueueId());
                logContext.setOffset(sendResult.getQueueOffset());
                logContext.setServer(sendResult.getMessageQueue().getBrokerName());
            }
            Message message = ctx.getMessage();
            logContext.setTopic(NamespaceUtil.withoutNamespace(message.getTopic()));
            logContext.setTag(message.getTags());
            try {
                String deliverMs = message.getUserProperty("TIMER_DELIVER_MS");
                if (deliverMs != null) {
                    logContext.setDelaySeconds(Long.valueOf(deliverMs).longValue());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            logContext.setMessageType(TraceUtils.getMsgType(ctx));
            logContext.setReconsumeTimes(0);
            logContext.setPubMode(ctx.getCommunicationMode().name());
            logContext.setGroup(NamespaceUtil.withoutNamespace(ctx.getGroup()));
        }
        catch (Throwable e) {
            logger.error("exception occurred when producerSendEnd in TracerUtils", e);
        }
        finally {
            TraceUtils.getMQTracer().producerReceive(TraceUtils.getSendResult(ctx));
        }
    }

    public static int getMsgType(SendMessageContext ctx) {
        switch (ctx.getMsgType()) {
            case Normal_Msg: {
                return 0;
            }
            case Trans_Msg_Half: {
                return 1;
            }
            case Delay_Msg: {
                return 2;
            }
            case Order_Msg: {
                return 3;
            }
            case Trans_msg_Commit: {
                switch (ctx.getTransactionState()) {
                    case COMMIT_MESSAGE: {
                        return 4;
                    }
                    case ROLLBACK_MESSAGE: {
                        return 5;
                    }
                    case UNKNOW: {
                        return 6;
                    }
                }
                return -1;
            }
        }
        return -1;
    }

    public static String getSendResult(SendMessageContext ctx) {
        if (ctx.getException() != null) {
            return "99";
        }
        if (CommunicationMode.ONEWAY == ctx.getCommunicationMode()) {
            return "00";
        }
        if (MessageType.Trans_msg_Commit.equals((Object)ctx.getMsgType())) {
            return "00";
        }
        SendResult sendResult = ctx.getSendResult();
        if (sendResult != null) {
            SendStatus status = sendResult.getSendStatus();
            if (status == SendStatus.SEND_OK) {
                return "00";
            }
            if (status == SendStatus.FLUSH_DISK_TIMEOUT || status == SendStatus.FLUSH_SLAVE_TIMEOUT) {
                return "01";
            }
            return "99";
        }
        return "99";
    }

    public static ConsumeMessageContext consumeMsgStart(com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.hook.ConsumeMessageContext rmqCtx) {
        if (!TraceUtils.isTraceAble()) {
            return new ConsumeMessageContext();
        }
        try {
            MessageExt message = rmqCtx.getMsgList().get(0);
            TraceUtils.fillTraceContext(message);
            MQLogContext logContext = TraceUtils.getMQTracer().consumerReceive();
            if (StringUtils.isBlank(logContext.getRpcId())) {
                logContext.setRpcId("0");
            }
            logContext.setRpcId(TracerUtils.appendHostToRpcId((String)logContext.getRpcId(), (String)MixUtils.HOSTNAME));
            logContext.setCurrentApp(TraceUtils.getAppName());
            logContext.setMessageId(message.getMsgId());
            logContext.setTopic(NamespaceUtil.withoutNamespace(message.getTopic()));
            logContext.setTag(message.getTags());
            logContext.setQueueId(rmqCtx.getMq().getQueueId());
            logContext.setOffset(message.getQueueOffset());
            try {
                String deliverMs = message.getUserProperty("TIMER_DELIVER_MS");
                if (deliverMs != null) {
                    logContext.setDelaySeconds(Long.valueOf(deliverMs).longValue());
                }
            }
            catch (Throwable deliverMs) {
                // empty catch block
            }
            logContext.setMessageType(0);
            logContext.setReconsumeTimes(message.getReconsumeTimes());
            logContext.setServer(rmqCtx.getMq().getBrokerName());
            logContext.setGroup(NamespaceUtil.withoutNamespace(rmqCtx.getConsumerGroup()));
            logContext.setConsumeLatency(System.currentTimeMillis() - message.getStoreTimestamp());
            ConsumeMessageContext ctx = new ConsumeMessageContext();
            ctx.setTracerContext(logContext);
            return ctx;
        }
        catch (Throwable e) {
            logger.error("exception occurred when consumeMsgStart in TracerUtils", e);
            return null;
        }
    }

    public static void consumeMsgEnd(ConsumeMessageContext ctx) {
        if (!TraceUtils.isTraceAble()) {
            return;
        }
        AbstractLogContext oldCtx = AbstractLogContext.get();
        AbstractLogContext.set((AbstractLogContext)((AbstractLogContext)ctx.getTracerContext()));
        try {
            TraceUtils.getMQTracer().consumerMsgProcessed(ctx.getStatus());
        }
        catch (Throwable e) {
            logger.error("exception occurred when consumeMsgEnd in TracerUtils", e);
        }
        finally {
            if (ctx.isRecover()) {
                AbstractLogContext.set((AbstractLogContext)oldCtx);
            }
        }
    }

    public static void convertTraceCtxToInnerCtx(MQLogContext ctx, Message message) {
        if (!TraceUtils.isTraceAble()) {
            return;
        }
        try {
            String traceId = ctx.getTraceId();
            String rpcId = ctx.getRpcId();
            String penetrateAttributes = ctx.getSerializedPenetrateAttributes();
            String sysPenAttributes = ctx.getSerializedPenetrateSystemAttrs();
            if (StringUtils.isNotBlank(traceId)) {
                message.putUserProperty("sofaTraceId", traceId);
            }
            if (StringUtils.isNotBlank(rpcId)) {
                message.putUserProperty("sofaRpcId", rpcId);
            }
            if (StringUtils.isNotBlank(penetrateAttributes)) {
                message.putUserProperty("sofaPenAttrs", penetrateAttributes);
            }
            if (StringUtils.isNotBlank(sysPenAttributes)) {
                message.putUserProperty("sysPenAttrs", sysPenAttributes);
            }
        }
        catch (Throwable e) {
            logger.error("exception occurred when convertTraceCtxToInnerCtx in TracerUtils", e);
        }
    }

    private static void fillTraceContext(MessageExt message) {
        String traceId = message.getUserProperty("sofaTraceId");
        String rpcId = message.getUserProperty("sofaRpcId");
        String penetrateAttributes = message.getUserProperty("sofaPenAttrs");
        String sysPenAttributes = message.getUserProperty("sysPenAttrs");
        HashMap<String, String> ctxMap = new HashMap<String, String>();
        if (StringUtils.isNotBlank(traceId)) {
            ctxMap.put("sofaTraceId", traceId);
        }
        if (StringUtils.isNotBlank(rpcId)) {
            ctxMap.put("sofaRpcId", rpcId);
        }
        if (StringUtils.isNotBlank(penetrateAttributes)) {
            ctxMap.put("sofaPenAttrs", penetrateAttributes);
        }
        if (StringUtils.isNotBlank(sysPenAttributes)) {
            ctxMap.put("sysPenAttrs", sysPenAttributes);
        }
        TraceUtils.getMQTracer().setLogContext(ctxMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAppName() {
        if (appName != null) {
            return appName;
        }
        Class<TraceUtils> clazz = TraceUtils.class;
        synchronized (TraceUtils.class) {
            if (appName != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return appName;
            }
            if (!sofaRuntime) {
                appName = DEFAULT_APPNAME;
                logger.info("sofaRuntime is disable, use default appName[{}]", (Object)appName);
                // ** MonitorExit[var0] (shouldn't be in output)
                return appName;
            }
            try {
                for (SofaRuntimeManager manager : SofaFramework.getRuntimeSet()) {
                    if (!StringUtils.isNotBlank(manager.getAppName())) continue;
                    appName = manager.getAppName();
                    logger.info("sofaRuntime is enable, use appName[{}]", (Object)appName);
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return appName;
                }
                if (appName == null) {
                    appName = DEFAULT_APPNAME;
                    logger.info("cannot fin appName from SofaRuntimeManager, use default appName[{}]", (Object)appName);
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return appName;
            }
            catch (Throwable e) {
                logger.error("get appName from SofaFramework fail", e);
                appName = DEFAULT_APPNAME;
                // ** MonitorExit[var0] (shouldn't be in output)
                return appName;
            }
        }
    }

    public static synchronized MQTracer getMQTracer() {
        if (mqTracer == null) {
            mqTracer = new MQTracer();
        }
        return mqTracer;
    }

    static {
        traceOpened = true;
        sofaRuntime = false;
        try {
            Class<?> mqTracerClass = Class.forName(MQ_TRACER_CLASS_NAME);
            traceEnable = mqTracerClass != null;
        }
        catch (ClassNotFoundException e) {
            traceEnable = false;
        }
        catch (Throwable e) {
            logger.error("Exception occurred when init mq tracer!", e);
            traceEnable = false;
        }
        if (!traceEnable) {
            logger.warn("{} class not found and mq client trace disable", (Object)MQ_TRACER_CLASS_NAME);
        } else {
            logger.info("{} class found, mq client traceEnable [{}]", (Object)MQ_TRACER_CLASS_NAME, (Object)traceEnable);
        }
        try {
            Class<?> clazz = Class.forName(SOFA_FRAMEWORK_CLASS_NAME);
            sofaRuntime = clazz != null;
        }
        catch (ClassNotFoundException e) {
            sofaRuntime = false;
        }
        catch (Throwable e) {
            logger.error("Exception occurred when lookup SofaFramework!", e);
            sofaRuntime = false;
        }
    }

    public static class AbstractLogContextWrapper {
        private Object abstractLogContext;

        public boolean exist() {
            return this.abstractLogContext != null;
        }

        public Object get() {
            return this.abstractLogContext;
        }

        public void set(Object abstractLogContext) {
            this.abstractLogContext = abstractLogContext;
        }
    }
}

