/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.client.trace.common;

import com.alipay.sofa.sofamq.client.trace.common.TraceBean;
import com.alipay.sofa.sofamq.client.trace.common.TraceType;
import com.alipay.sofa.sofamq.org.shade.apache.commons.lang3.StringUtils;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.message.MessageClientIDSetter;
import java.util.List;
import java.util.Set;

public class TraceContext
implements Comparable<TraceContext> {
    private TraceType traceType;
    private long timeStamp = System.currentTimeMillis();
    private String regionId = "";
    private String regionName = "";
    private String groupName = "";
    private int costTime = 0;
    private boolean isSuccess = true;
    private String requestId = MessageClientIDSetter.createUniqID();
    private int contextCode = 0;
    private int exactlyOnceStatus = 0;
    private List<TraceBean> traceBeans;
    private Set<String> brokerSet;
    private String currentCell;
    private String nextTraceCell;

    public int getContextCode() {
        return this.contextCode;
    }

    public void setContextCode(int contextCode) {
        this.contextCode = contextCode;
    }

    public int getExactlyOnceStatus() {
        return this.exactlyOnceStatus;
    }

    public void setExactlyOnceStatus(int exactlyOnceStatus) {
        this.exactlyOnceStatus = exactlyOnceStatus;
    }

    public List<TraceBean> getTraceBeans() {
        return this.traceBeans;
    }

    public void setTraceBeans(List<TraceBean> traceBeans) {
        this.traceBeans = traceBeans;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public TraceType getTraceType() {
        return this.traceType;
    }

    public void setTraceType(TraceType traceType) {
        this.traceType = traceType;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public int getCostTime() {
        return this.costTime;
    }

    public void setCostTime(int costTime) {
        this.costTime = costTime;
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public void setSuccess(boolean success) {
        this.isSuccess = success;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public Set<String> getBrokerSet() {
        return this.brokerSet;
    }

    public void setBrokerSet(Set<String> brokerSet) {
        this.brokerSet = brokerSet;
    }

    public String getNextTraceCell() {
        return this.nextTraceCell;
    }

    public void setNextTraceCell(String nextTraceCell) {
        this.nextTraceCell = nextTraceCell;
    }

    public String getCurrentCell() {
        return this.currentCell;
    }

    public void setCurrentCell(String currentCell) {
        this.currentCell = currentCell;
    }

    @Override
    public int compareTo(TraceContext o) {
        return (int)(this.timeStamp - o.getTimeStamp());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append((Object)this.traceType).append("_").append(this.groupName).append("_").append(this.regionId).append("_").append(this.isSuccess).append("_");
        if (StringUtils.isNotBlank(this.nextTraceCell)) {
            sb.append(this.nextTraceCell).append("_");
        }
        if (StringUtils.isNotBlank(this.currentCell)) {
            sb.append(this.currentCell).append("_");
        }
        if (this.traceBeans != null && this.traceBeans.size() > 0) {
            for (TraceBean bean : this.traceBeans) {
                sb.append(bean.getMsgId() + "_" + bean.getTopic() + "_");
            }
        }
        return "TraceContext{" + sb.toString() + '}';
    }
}

