/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.client.trace.common;

import com.alipay.sofa.sofamq.client.trace.common.TraceBean;
import com.alipay.sofa.sofamq.client.trace.common.TraceContext;
import com.alipay.sofa.sofamq.client.trace.common.TraceTransferBean;
import com.alipay.sofa.sofamq.client.trace.common.TraceType;
import com.alipay.sofa.sofamq.org.shade.apache.commons.lang3.StringUtils;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.message.MessageType;
import java.util.ArrayList;
import java.util.List;

public class TraceDataEncoder {
    public static List<TraceContext> decoderFromTraceDataString(String traceData, Long traceMsgTime) {
        String[] contextList;
        ArrayList<TraceContext> resList = new ArrayList<TraceContext>();
        if (traceData == null || traceData.length() <= 0) {
            return resList;
        }
        for (String context : contextList = traceData.split(String.valueOf('\u0002'))) {
            TraceBean bean;
            String[] line = context.split(String.valueOf('\u0001'));
            if (line[0].equals(TraceType.Pub.name())) {
                TraceContext pubContext = new TraceContext();
                pubContext.setTraceType(TraceType.Pub);
                pubContext.setTimeStamp(Long.parseLong(line[1]));
                pubContext.setRegionId(line[2]);
                pubContext.setGroupName(line[3]);
                bean = new TraceBean();
                bean.setTopic(line[4]);
                bean.setMsgId(line[5]);
                bean.setTags(line[6]);
                bean.setKeys(line[7]);
                bean.setStoreHost(line[8]);
                bean.setBodyLength(Integer.parseInt(line[9]));
                pubContext.setCostTime(Integer.parseInt(line[10]));
                bean.setMsgType(MessageType.values()[Integer.parseInt(line[11])]);
                if (line.length == 13) {
                    pubContext.setSuccess(Boolean.parseBoolean(line[12]));
                } else if (line.length == 14) {
                    bean.setOffsetMsgId(line[12]);
                    pubContext.setSuccess(Boolean.parseBoolean(line[13]));
                } else if (line.length == 15) {
                    bean.setOffsetMsgId(line[12]);
                    pubContext.setSuccess(Boolean.parseBoolean(line[13]));
                    pubContext.setCurrentCell(line[14]);
                }
                pubContext.setTraceBeans(new ArrayList<TraceBean>(1));
                pubContext.getTraceBeans().add(bean);
                resList.add(pubContext);
                continue;
            }
            if (line[0].equals(TraceType.SubBefore.name())) {
                TraceContext subBeforeContext = new TraceContext();
                subBeforeContext.setTraceType(TraceType.SubBefore);
                subBeforeContext.setTimeStamp(Long.parseLong(line[1]));
                subBeforeContext.setRegionId(line[2]);
                subBeforeContext.setGroupName(line[3]);
                subBeforeContext.setRequestId(line[4]);
                bean = new TraceBean();
                bean.setMsgId(line[5]);
                bean.setRetryTimes(Integer.parseInt(line[6]));
                bean.setKeys(line[7]);
                subBeforeContext.setTraceBeans(new ArrayList<TraceBean>(1));
                subBeforeContext.getTraceBeans().add(bean);
                resList.add(subBeforeContext);
                continue;
            }
            if (!line[0].equals(TraceType.SubAfter.name())) continue;
            TraceContext subAfterContext = new TraceContext();
            if (traceMsgTime != null) {
                subAfterContext.setTimeStamp(traceMsgTime);
            }
            subAfterContext.setTraceType(TraceType.SubAfter);
            subAfterContext.setRequestId(line[1]);
            bean = new TraceBean();
            bean.setMsgId(line[2]);
            bean.setKeys(line[5]);
            subAfterContext.setTraceBeans(new ArrayList<TraceBean>(1));
            subAfterContext.getTraceBeans().add(bean);
            subAfterContext.setCostTime(Integer.parseInt(line[3]));
            subAfterContext.setSuccess(Boolean.parseBoolean(line[4]));
            if (line.length >= 7) {
                subAfterContext.setContextCode(Integer.parseInt(line[6]));
            }
            if (line.length >= 8) {
                subAfterContext.setExactlyOnceStatus(Integer.parseInt(line[7]));
            }
            if (line.length >= 9) {
                subAfterContext.setCurrentCell(line[8]);
            }
            if (line.length >= 10) {
                subAfterContext.setNextTraceCell(line[9]);
            }
            resList.add(subAfterContext);
        }
        return resList;
    }

    public static List<TraceContext> decoderFromTraceDataString(String traceData) {
        return TraceDataEncoder.decoderFromTraceDataString(traceData, null);
    }

    public static TraceTransferBean encoderFromContextBean(TraceContext ctx) {
        if (ctx == null) {
            return null;
        }
        TraceTransferBean transferBean = new TraceTransferBean();
        StringBuilder sb = new StringBuilder(256);
        switch (ctx.getTraceType()) {
            case Pub: {
                TraceBean bean = ctx.getTraceBeans().get(0);
                sb.append((Object)ctx.getTraceType()).append('\u0001').append(ctx.getTimeStamp()).append('\u0001').append(ctx.getRegionId()).append('\u0001').append(ctx.getGroupName()).append('\u0001').append(bean.getTopic()).append('\u0001').append(bean.getMsgId()).append('\u0001').append(bean.getTags()).append('\u0001').append(bean.getKeys()).append('\u0001').append(bean.getStoreHost()).append('\u0001').append(bean.getBodyLength()).append('\u0001').append(ctx.getCostTime()).append('\u0001').append(bean.getMsgType().ordinal()).append('\u0001').append(bean.getOffsetMsgId()).append('\u0001').append(ctx.isSuccess()).append('\u0001').append(StringUtils.isNotBlank(ctx.getCurrentCell()) ? ctx.getCurrentCell() : "").append('\u0002');
                break;
            }
            case SubBefore: {
                for (TraceBean bean : ctx.getTraceBeans()) {
                    sb.append((Object)ctx.getTraceType()).append('\u0001').append(ctx.getTimeStamp()).append('\u0001').append(ctx.getRegionId()).append('\u0001').append(ctx.getGroupName()).append('\u0001').append(ctx.getRequestId()).append('\u0001').append(bean.getMsgId()).append('\u0001').append(bean.getRetryTimes()).append('\u0001').append(bean.getKeys()).append('\u0002');
                }
                break;
            }
            case SubAfter: {
                for (TraceBean bean : ctx.getTraceBeans()) {
                    sb.append((Object)ctx.getTraceType()).append('\u0001').append(ctx.getRequestId()).append('\u0001').append(bean.getMsgId()).append('\u0001').append(ctx.getCostTime()).append('\u0001').append(ctx.isSuccess()).append('\u0001').append(bean.getKeys()).append('\u0001').append(ctx.getContextCode()).append('\u0001').append(ctx.getExactlyOnceStatus()).append('\u0001').append(StringUtils.isNotBlank(ctx.getCurrentCell()) ? ctx.getCurrentCell() : "").append('\u0001').append(StringUtils.isNotBlank(ctx.getNextTraceCell()) ? ctx.getNextTraceCell() : "").append('\u0002');
                }
                break;
            }
        }
        transferBean.setTransData(sb.toString());
        for (TraceBean bean : ctx.getTraceBeans()) {
            transferBean.getTransKey().add(bean.getMsgId());
            if (bean.getKeys() == null || bean.getKeys().length() <= 0) continue;
            transferBean.getTransKey().add(bean.getKeys());
        }
        return transferBean;
    }
}

