/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.client.trace.dispatch.impl;

import com.alipay.sofa.sofamq.auth.authority.SessionCredentials;
import com.alipay.sofa.sofamq.client.trace.common.TraceContext;
import com.alipay.sofa.sofamq.client.trace.common.TraceDispatcherType;
import com.alipay.sofa.sofamq.client.trace.dispatch.AsyncDispatcher;
import com.alipay.sofa.sofamq.client.trace.dispatch.NameServerAddressSetter;
import com.alipay.sofa.sofamq.client.trace.dispatch.impl.InnerTraceProducer;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.exception.MQClientException;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.impl.consumer.DefaultMQPullConsumerImpl;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.impl.consumer.DefaultMQPushConsumerImpl;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.impl.producer.DefaultMQProducerImpl;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;

public class AsyncArrayDispatcher
implements AsyncDispatcher {
    private final boolean innerProducerSingleton;
    private final InnerTraceProducer traceProducer;
    private String dispatcherType;
    private DefaultMQProducerImpl hostProducer;
    private DefaultMQPushConsumerImpl hostConsumer;
    private DefaultMQPullConsumerImpl hostPullConsumer;
    private String dispatcherId = UUID.randomUUID().toString();

    public AsyncArrayDispatcher(Properties properties, NameServerAddressSetter nameserverAddressSetter) throws MQClientException {
        this.dispatcherType = properties.getProperty("DispatcherType");
        this.innerProducerSingleton = Boolean.parseBoolean(properties.getProperty("TraceProducerSingleton", "true"));
        this.traceProducer = InnerTraceProducer.getTraceDispatcherProducer(properties, nameserverAddressSetter);
    }

    public AsyncArrayDispatcher(Properties properties, SessionCredentials sessionCredentials, NameServerAddressSetter nameserverAddressSetter) throws MQClientException {
        this.dispatcherType = properties.getProperty("DispatcherType");
        this.innerProducerSingleton = Boolean.parseBoolean(properties.getProperty("TraceProducerSingleton", "true"));
        this.traceProducer = InnerTraceProducer.getTraceDispatcherProducer(properties, sessionCredentials, nameserverAddressSetter);
    }

    public DefaultMQProducerImpl getHostProducer() {
        return this.hostProducer;
    }

    public void setHostProducer(DefaultMQProducerImpl hostProducer) {
        this.hostProducer = hostProducer;
    }

    public DefaultMQPushConsumerImpl getHostConsumer() {
        return this.hostConsumer;
    }

    public void setHostConsumer(DefaultMQPushConsumerImpl hostConsumer) {
        this.hostConsumer = hostConsumer;
    }

    public DefaultMQPullConsumerImpl getHostPullConsumer() {
        return this.hostPullConsumer;
    }

    public void setHostPullConsumer(DefaultMQPullConsumerImpl hostPullConsumer) {
        this.hostPullConsumer = hostPullConsumer;
    }

    @Override
    public void start() throws MQClientException {
        InnerTraceProducer.registerTraceDispatcher(this.dispatcherId, this.traceProducer, this.innerProducerSingleton);
    }

    @Override
    public boolean append(TraceContext ctx) {
        if (ctx.getTraceBeans().isEmpty()) {
            return true;
        }
        String topic = ctx.getTraceBeans().get(0).getTopic();
        Set<String> brokerSet = this.getBrokerSetByTopic(topic);
        ctx.setBrokerSet(brokerSet);
        return this.traceProducer.append(ctx);
    }

    @Override
    public void shutdown() {
        InnerTraceProducer.unregisterTraceDispatcher(this.dispatcherId, this.traceProducer, this.innerProducerSingleton);
    }

    private Set<String> getBrokerSetByTopic(String topic) {
        Set<String> brokerSet = new HashSet<String>();
        if (this.dispatcherType != null && this.dispatcherType.equals(TraceDispatcherType.PRODUCER.name()) && this.hostProducer != null) {
            brokerSet = InnerTraceProducer.tryGetMessageQueueBrokerSet(this.hostProducer, topic);
        }
        if (this.dispatcherType != null && this.dispatcherType.equals(TraceDispatcherType.CONSUMER.name()) && this.hostConsumer != null) {
            brokerSet = InnerTraceProducer.tryGetMessageQueueBrokerSet(this.hostConsumer, topic);
        }
        if (this.dispatcherType != null && this.dispatcherType.equals(TraceDispatcherType.CONSUMER.name()) && this.hostPullConsumer != null) {
            brokerSet = InnerTraceProducer.tryGetMessageQueueBrokerSet(this.hostPullConsumer, topic);
        }
        return brokerSet;
    }
}

