/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.client.trace.hook;

import com.alipay.sofa.sofamq.client.trace.common.TraceBean;
import com.alipay.sofa.sofamq.client.trace.common.TraceContext;
import com.alipay.sofa.sofamq.client.trace.common.TraceType;
import com.alipay.sofa.sofamq.client.trace.dispatch.AsyncDispatcher;
import com.alipay.sofa.sofamq.org.shade.apache.commons.lang3.StringUtils;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.hook.SendMessageContext;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.hook.SendMessageHook;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.impl.CommunicationMode;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.producer.SendStatus;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.protocol.NamespaceUtil;
import java.util.ArrayList;

public class ClientSendMessageHookImpl
implements SendMessageHook {
    private AsyncDispatcher localDispatcher;

    public ClientSendMessageHookImpl(AsyncDispatcher localDispatcher) {
        this.localDispatcher = localDispatcher;
    }

    @Override
    public String hookName() {
        return "ClientSendMessageHook";
    }

    @Override
    public void sendMessageBefore(SendMessageContext context) {
        if (context == null || context.getMessage().getTopic().toLowerCase().startsWith("rmq_sys_")) {
            return;
        }
        TraceContext ctx = new TraceContext();
        ctx.setTraceBeans(new ArrayList<TraceBean>(1));
        context.setMqTraceContext(ctx);
        ctx.setTraceType(TraceType.Pub);
        String userGroup = NamespaceUtil.withoutNamespace(context.getProducerGroup(), context.getNamespace());
        ctx.setGroupName(userGroup);
        TraceBean traceBean = new TraceBean();
        String userTopic = NamespaceUtil.withoutNamespace(context.getMessage().getTopic(), context.getNamespace());
        traceBean.setTopic(userTopic);
        traceBean.setTags(context.getMessage().getTags());
        traceBean.setKeys(context.getMessage().getKeys());
        traceBean.setStoreHost(context.getBrokerAddr());
        traceBean.setBodyLength(context.getMessage().getBody().length);
        traceBean.setMsgType(context.getMsgType());
        ctx.getTraceBeans().add(traceBean);
    }

    @Override
    public void sendMessageAfter(SendMessageContext context) {
        if (context == null || context.getMessage().getTopic().toLowerCase().startsWith("RMQ_SYS_TRACE_TOPIC") || context.getMqTraceContext() == null) {
            return;
        }
        if (context.getSendResult() == null) {
            return;
        }
        TraceContext onsContext = (TraceContext)context.getMqTraceContext();
        if (context.getCommunicationMode().equals((Object)CommunicationMode.ASYNC)) {
            onsContext.setCostTime(-1);
        } else {
            int costTime = (int)((System.currentTimeMillis() - onsContext.getTimeStamp()) / (long)onsContext.getTraceBeans().size());
            onsContext.setCostTime(costTime);
        }
        if (context.getSendResult().getSendStatus().equals((Object)SendStatus.SEND_OK)) {
            onsContext.setSuccess(true);
        } else {
            onsContext.setSuccess(false);
        }
        onsContext.setRegionId(context.getSendResult().getRegionId());
        String currentCell = this.getCurrentCell(context);
        if (StringUtils.isNotBlank(currentCell)) {
            onsContext.setCurrentCell(currentCell);
        }
        TraceBean traceBean = onsContext.getTraceBeans().get(0);
        traceBean.setMsgId(context.getSendResult().getMsgId());
        traceBean.setOffsetMsgId(context.getSendResult().getOffsetMsgId());
        traceBean.setStoreTime(onsContext.getTimeStamp());
        if (context.getSendResult().getRegionId() == null || !context.getSendResult().isTraceOn()) {
            return;
        }
        this.localDispatcher.append(onsContext);
    }

    private String getCurrentCell(SendMessageContext context) {
        String[] tmp;
        String namespace = context.getProducer().getDefaultMQProducer().getNamespace();
        if ((StringUtils.isNotBlank(namespace) || namespace.contains("\\|")) && (tmp = namespace.split("\\|")).length >= 2) {
            return tmp[1];
        }
        return null;
    }
}

