/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.client.trace.hook;

import com.alipay.sofa.sofamq.client.trace.common.TraceBean;
import com.alipay.sofa.sofamq.client.trace.common.TraceContext;
import com.alipay.sofa.sofamq.client.trace.common.TraceType;
import com.alipay.sofa.sofamq.client.trace.dispatch.AsyncDispatcher;
import com.alipay.sofa.sofamq.client.util.DevGroupUtils;
import com.alipay.sofa.sofamq.org.shade.apache.commons.lang3.StringUtils;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.consumer.listener.ConsumeExactlyOnceStatus;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.consumer.listener.ConsumeReturnType;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.hook.ConsumeMessageContext;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.hook.ConsumeMessageHook;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.message.MessageExt;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.protocol.NamespaceUtil;
import java.util.ArrayList;

public class ConsumeMessageHookImpl
implements ConsumeMessageHook {
    private AsyncDispatcher localDispatcher;
    private boolean skipSendConsumeBeforeTrace = false;

    public ConsumeMessageHookImpl(AsyncDispatcher localDispatcher) {
        this.localDispatcher = localDispatcher;
    }

    public ConsumeMessageHookImpl(AsyncDispatcher localDispatcher, boolean skipSendConsumeBeforeTrace) {
        this.localDispatcher = localDispatcher;
        this.skipSendConsumeBeforeTrace = skipSendConsumeBeforeTrace;
    }

    @Override
    public String hookName() {
        return "ConsumeMessageHook";
    }

    @Override
    public void consumeMessageBefore(ConsumeMessageContext context) {
        if (context == null || context.getMsgList() == null || context.getMsgList().isEmpty()) {
            return;
        }
        TraceContext traceContext = new TraceContext();
        context.setMqTraceContext(traceContext);
        traceContext.setTraceType(TraceType.SubBefore);
        String userGroup = NamespaceUtil.withoutNamespace(context.getConsumerGroup(), context.getNamespace());
        traceContext.setGroupName(userGroup);
        ArrayList<TraceBean> beans = new ArrayList<TraceBean>();
        for (MessageExt msg : context.getMsgList()) {
            String originalTopic;
            if (msg == null) continue;
            String regionId = msg.getProperty("MSG_REGION");
            String traceOn = msg.getProperty("TRACE_ON");
            if ("false".equals(traceOn)) continue;
            TraceBean traceBean = new TraceBean();
            String userTopic = msg.getTopic();
            if ("rmq_sys_TP_DEV_GROUP_2".equals(userTopic) && StringUtils.isNotBlank(originalTopic = DevGroupUtils.getOriginalTopic(msg))) {
                userTopic = originalTopic;
            }
            userTopic = NamespaceUtil.withoutNamespace(userTopic, context.getNamespace());
            traceBean.setTopic(userTopic);
            traceBean.setMsgId(msg.getMsgId());
            traceBean.setTags(msg.getTags());
            String keys = msg.getKeys();
            traceBean.setKeys(StringUtils.isBlank(keys) ? null : keys);
            traceBean.setStoreTime(msg.getStoreTimestamp());
            traceBean.setBodyLength(msg.getStoreSize());
            traceBean.setRetryTimes(msg.getReconsumeTimes());
            traceContext.setRegionId(regionId);
            beans.add(traceBean);
        }
        if (beans.size() > 0) {
            traceContext.setTraceBeans(beans);
            traceContext.setTimeStamp(System.currentTimeMillis());
            if (!this.skipSendConsumeBeforeTrace) {
                this.localDispatcher.append(traceContext);
            }
        }
    }

    @Override
    public void consumeMessageAfter(ConsumeMessageContext context) {
        String skipSendConsumeAfterTrace;
        String currentCell;
        String routerTargetCell;
        String exactlyOnceStatus;
        if (context == null || context.getMsgList() == null || context.getMsgList().isEmpty()) {
            return;
        }
        TraceContext subBeforeContext = (TraceContext)context.getMqTraceContext();
        if (subBeforeContext.getTraceBeans() == null || subBeforeContext.getTraceBeans().size() < 1) {
            return;
        }
        TraceContext subAfterContext = new TraceContext();
        subAfterContext.setTraceType(TraceType.SubAfter);
        subAfterContext.setRegionId(subBeforeContext.getRegionId());
        subAfterContext.setGroupName(subBeforeContext.getGroupName());
        subAfterContext.setRequestId(subBeforeContext.getRequestId());
        subAfterContext.setSuccess(context.isSuccess());
        int costTime = (int)((System.currentTimeMillis() - subBeforeContext.getTimeStamp()) / (long)context.getMsgList().size());
        subAfterContext.setCostTime(costTime);
        subAfterContext.setTraceBeans(subBeforeContext.getTraceBeans());
        String contextType = context.getProps().get("ConsumeContextType");
        if (contextType != null) {
            subAfterContext.setContextCode(ConsumeReturnType.valueOf(contextType).ordinal());
        }
        if ((exactlyOnceStatus = context.getProps().get("ConsumeExactlyOnceStatus")) != null) {
            subAfterContext.setExactlyOnceStatus(ConsumeExactlyOnceStatus.valueOf(exactlyOnceStatus).ordinal());
        }
        if (StringUtils.isNotBlank(routerTargetCell = context.getProps().get("__ROUTER.TARGET_CELL"))) {
            subAfterContext.setNextTraceCell(routerTargetCell);
        }
        if (StringUtils.isNotBlank(currentCell = this.getCurrentCell(context.getNamespace()))) {
            subAfterContext.setCurrentCell(currentCell);
        }
        if (!"true".equals(skipSendConsumeAfterTrace = context.getProps().get("SKIP_SEND_CONSUME_AFTER_TRACE"))) {
            this.localDispatcher.append(subAfterContext);
        }
    }

    private String getCurrentCell(String namespace) {
        String[] tmp;
        if ((StringUtils.isNotBlank(namespace) || namespace.contains("\\|")) && (tmp = namespace.split("\\|")).length >= 2) {
            return tmp[1];
        }
        return null;
    }
}

