/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.client.trace.hook;

import com.alipay.sofa.sofamq.client.ClientLoggerUtil;
import com.alipay.sofa.sofamq.client.util.DevGroupUtils;
import com.alipay.sofa.sofamq.org.shade.apache.commons.lang3.StringUtils;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.hook.ConsumeMessageContext;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.client.hook.ConsumeMessageHook;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.message.MessageExt;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.logging.InternalLogger;
import java.util.List;

public class DevGroupConsumeMessageHook
implements ConsumeMessageHook {
    protected static final InternalLogger LOGGER = ClientLoggerUtil.getClientLogger();
    private boolean enable = false;

    public DevGroupConsumeMessageHook() {
        if ("stable".equalsIgnoreCase(System.getenv("SERVER_ENV"))) {
            this.enable = true;
            LOGGER.info("Dev group auto-detection enabled in stable environment.");
        }
    }

    @Override
    public String hookName() {
        return DevGroupConsumeMessageHook.class.getSimpleName();
    }

    @Override
    public void consumeMessageBefore(ConsumeMessageContext context) {
        if (!this.enable) {
            return;
        }
        List<MessageExt> msgList = context.getMsgList();
        for (MessageExt msg : msgList) {
            String devGroup = DevGroupUtils.extractDevGroupFromMessage(msg);
            if (!StringUtils.isNotBlank(devGroup)) continue;
            LOGGER.info("Detected dev group message:[{}], dev group spans to all messages {} within one context.", (Object)msg.getMsgId(), (Object)msgList);
            DevGroupUtils.setDevGroupToTracer(devGroup);
        }
    }

    @Override
    public void consumeMessageAfter(ConsumeMessageContext context) {
    }
}

