/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.client.trace.utils;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;

public class MixUtils {
    public static String HOSTNAME;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getLocalAddress() {
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            ArrayList<String> ipv4Result = new ArrayList<String>();
            ArrayList<String> ipv6Result = new ArrayList<String>();
            block5: while (true) {
                Object networkInterface;
                if (!enumeration.hasMoreElements()) {
                    if (!ipv4Result.isEmpty()) {
                        String ip;
                        networkInterface = ipv4Result.iterator();
                        do {
                            if (networkInterface.hasNext()) continue;
                            return (String)ipv4Result.get(ipv4Result.size() - 1);
                        } while ((ip = (String)networkInterface.next()).startsWith("127.0") || ip.startsWith("192.168"));
                        return ip;
                    }
                    if (!ipv6Result.isEmpty()) {
                        return (String)ipv6Result.get(0);
                    }
                    InetAddress localHost = InetAddress.getLocalHost();
                    return MixUtils.normalizeHostAddress(localHost);
                }
                networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> en = ((NetworkInterface)networkInterface).getInetAddresses();
                while (true) {
                    if (!en.hasMoreElements()) continue block5;
                    InetAddress address = en.nextElement();
                    if (address.isLoopbackAddress()) continue;
                    if (address instanceof Inet6Address) {
                        ipv6Result.add(MixUtils.normalizeHostAddress(address));
                        continue;
                    }
                    ipv4Result.add(MixUtils.normalizeHostAddress(address));
                }
                break;
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
            return null;
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String normalizeHostAddress(InetAddress localHost) {
        if (localHost instanceof Inet6Address) {
            return "[" + localHost.getHostAddress() + "]";
        }
        return localHost.getHostAddress();
    }

    static {
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            HOSTNAME = localhost.getHostName();
        }
        catch (UnknownHostException var4) {
            HOSTNAME = "localhost";
        }
    }
}

