/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.client.util;

import com.alipay.common.tracer.core.holder.SofaTraceContextHolder;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.sofa.sofamq.org.shade.apache.commons.lang3.StringUtils;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.message.MessageAccessor;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.message.MessageExt;
import io.openmessaging.api.Message;
import java.util.Map;

public class DevGroupUtils {
    public static final String TAG_DELIMITER = "@";
    public static final String TRACER_BAGGAGE_DEV_GROUP = "group";
    public static final String ENV_DEV_GROUP_NAME = "SOFA_GROUP_NAME";
    public static final String ENV_DEV_GROUP_DEFAULT = "SOFA_GROUP_DEFAULT";
    public static final String ENV_DEV_GROUP_FORCE_IGNORE = "SOFA_GROUP_FORCE_IGNORE";
    public static final String DEV_GROUP_TOPIC = "rmq_sys_TP_DEV_GROUP_2";

    public static void injectDevGroupOnDemand(com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.message.Message msg) {
        if (!DevGroupUtils.clientEnableDevGroup()) {
            return;
        }
        String devGroup = DevGroupUtils.getDevGroupNameFromEnv();
        if (StringUtils.isBlank(devGroup)) {
            devGroup = DevGroupUtils.getDevGroupFromTracer();
        }
        if (StringUtils.isNotBlank(devGroup)) {
            MessageAccessor.putProperty(msg, "devGroupName", devGroup);
        }
    }

    public static String getDevGroupNameFromEnv() {
        return System.getenv(ENV_DEV_GROUP_NAME);
    }

    public static String getDefaultDevGroupName() {
        return System.getenv(ENV_DEV_GROUP_DEFAULT);
    }

    public static boolean isForceIgnoreDevGroup() {
        if (Boolean.parseBoolean(System.getenv(ENV_DEV_GROUP_FORCE_IGNORE))) {
            return true;
        }
        return Boolean.parseBoolean(System.getProperty(ENV_DEV_GROUP_FORCE_IGNORE));
    }

    public static String extractDevGroupFromMessage(Message message) {
        if (message == null) {
            return null;
        }
        return message.getUserProperties("devGroupName");
    }

    public static String extractDevGroupFromMessage(MessageExt message) {
        if (message == null) {
            return null;
        }
        return message.getProperty("devGroupName");
    }

    public static String extractDevGroupFromProperties(Map<String, String> props) {
        if (props == null) {
            return null;
        }
        return props.get("devGroupName");
    }

    public static String getOriginalTopic(MessageExt msg) {
        return msg.getProperty("devGroupOrigTopic");
    }

    public static int getOriginalQueueId(MessageExt msg) {
        String origQueueIdStr = msg.getProperty("devGroupOrigQueueId");
        if (StringUtils.isNotBlank(origQueueIdStr)) {
            return Integer.parseInt(origQueueIdStr);
        }
        return 0;
    }

    public static void setOriginalTopic(MessageExt msg, String originalTopic) {
        MessageAccessor.putProperty(msg, "devGroupOrigTopic", originalTopic);
    }

    public static void setOriginalTopic(Map<String, String> props, String originalTopic) {
        props.put("devGroupOrigTopic", originalTopic);
    }

    public static void setOriginalQueueId(MessageExt msg, int realQueueId) {
        MessageAccessor.putProperty(msg, "devGroupOrigQueueId", String.valueOf(realQueueId));
    }

    public static void setOriginalQueueId(Map<String, String> props, int realQueueId) {
        props.put("devGroupOrigQueueId", String.valueOf(realQueueId));
    }

    public static String getDevGroupFromTracer() {
        SofaTracerSpan span = SofaTraceContextHolder.getSofaTraceContext().getCurrentSpan();
        if (span == null) {
            return null;
        }
        String groupInTracer = span.getBaggageItem(TRACER_BAGGAGE_DEV_GROUP);
        if (StringUtils.isNotEmpty(groupInTracer)) {
            return groupInTracer;
        }
        return null;
    }

    public static void setDevGroupToTracer(String group) {
        SofaTracerSpan span = SofaTraceContextHolder.getSofaTraceContext().getCurrentSpan();
        if (span == null) {
            return;
        }
        span.setBaggageItem(TRACER_BAGGAGE_DEV_GROUP, group);
    }

    public static boolean inStableEnvironment() {
        return "stable".equalsIgnoreCase(System.getenv("SERVER_ENV"));
    }

    public static boolean devGroupSupportEnabled() {
        if ("stable".equalsIgnoreCase(System.getenv("SERVER_ENV"))) {
            return true;
        }
        return StringUtils.isNotBlank(System.getenv("SOFAMQ_ENABLE_DEV_GROUP")) && Boolean.parseBoolean(System.getenv("SOFAMQ_ENABLE_DEV_GROUP"));
    }

    public static boolean clientEnableDevGroup() {
        if (DevGroupUtils.isForceIgnoreDevGroup()) {
            return false;
        }
        String devGroupName = DevGroupUtils.getDevGroupNameFromEnv();
        String defaultDevGroupName = DevGroupUtils.getDefaultDevGroupName();
        if (StringUtils.isBlank(devGroupName)) {
            return false;
        }
        return !devGroupName.equals(defaultDevGroupName);
    }
}

