/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.client.util;

import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.utils.HttpTinyClient;
import com.alipay.sofa.sofamq.org.shade.apache.rocketmq.common.utils.IOTinyUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class HttpTinyClientExt
extends HttpTinyClient {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpTinyClient.HttpResult httpPostJSON(String url, List<String> headers, String jsonBody, String encoding, long readTimeoutMs) throws IOException {
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setRequestMethod("POST");
            conn.setConnectTimeout(3000);
            conn.setReadTimeout((int)readTimeoutMs);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            HttpTinyClientExt.setHeaders(conn, headers, encoding);
            conn.getOutputStream().write(jsonBody.getBytes("UTF-8"));
            int respCode = conn.getResponseCode();
            String resp = null;
            resp = 200 == respCode ? IOTinyUtils.toString(conn.getInputStream(), encoding) : IOTinyUtils.toString(conn.getErrorStream(), encoding);
            HttpTinyClient.HttpResult httpResult = new HttpTinyClient.HttpResult(respCode, resp);
            return httpResult;
        }
        finally {
            if (null != conn) {
                conn.disconnect();
            }
        }
    }

    static void setHeaders(HttpURLConnection conn, List<String> headers, String encoding) {
        if (null != headers) {
            Iterator<String> iter = headers.iterator();
            while (iter.hasNext()) {
                conn.addRequestProperty(iter.next(), iter.next());
            }
        }
    }

    public static Map<String, String> splitQuery(String query) throws UnsupportedEncodingException {
        String[] pairs;
        LinkedHashMap<String, String> queryPairs = new LinkedHashMap<String, String>();
        for (String pair : pairs = query.split("&")) {
            int idx = pair.indexOf("=");
            queryPairs.put(URLDecoder.decode(pair.substring(0, idx), "UTF-8"), URLDecoder.decode(pair.substring(idx + 1), "UTF-8"));
        }
        return queryPairs;
    }
}

