/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.com.shade.alipay.antvip.client;

import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.AntvipClientType;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.drm.DrmControl;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.drm.DrmSyncControl;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.log.Loggers;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.util.ZoneUtil;
import com.alipay.sofa.sofamq.org.shade.apache.commons.lang.StringUtils;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;

public class AntVipConfigure {
    private boolean diskCacheEnable = true;
    private String diskStoreDir;
    private long requestTimeoutMs = 2000L;
    private String appName = "AntVipDefaultAppName";
    private String zone;
    protected String trFrom = "java-client";
    protected String version;
    protected DrmControl drmControl = new DrmControl();
    protected DrmSyncControl drmSyncControl = new DrmSyncControl();
    private boolean localApiSwitch;
    private boolean pollingNameList = false;
    private int lruCacheMaxCapacity = 64;
    private AntvipClientType antvipClientType = AntvipClientType.JAVA_CLIENT;
    private String endpoint = "antvip-pool";
    private boolean endpointEnforce = false;
    private String userHome;

    public AntVipConfigure() {
        this("antvip.properties");
    }

    public AntVipConfigure(String configFileName) {
        this(configFileName, true);
    }

    public AntVipConfigure(boolean isEnableLocalApi) {
        this(null, isEnableLocalApi);
    }

    public AntVipConfigure(String configFileName, boolean isEnableLocalApi) {
        this.localApiSwitch = isEnableLocalApi;
        String implementationVersion = AntVipConfigure.class.getPackage().getImplementationVersion();
        this.version = implementationVersion != null ? implementationVersion : "Unknown";
        String userHome = System.getProperty("user.home");
        if (userHome == null || userHome.isEmpty()) {
            userHome = "/home/admin";
        }
        if (!userHome.endsWith(File.separator)) {
            userHome = userHome + File.separator;
        }
        this.userHome = userHome;
        this.diskStoreDir = this.userHome + "conf/" + "antvip-java-client-cache4app" + File.separator;
        if (StringUtils.isNotBlank(configFileName)) {
            this.initProperties(configFileName, "com.alipay.antvip.");
        }
        this.initZone();
        this.initEndpoint();
    }

    private void initEndpoint() {
        String confregUrl;
        Map<String, String> envMap;
        String antvipEndpont;
        String enforceStr = System.getProperty("com.alipay.antvip.endpoint.enforce");
        if (null != enforceStr && !enforceStr.isEmpty()) {
            this.endpointEnforce = StringUtils.equalsIgnoreCase(enforceStr, "true");
        }
        this.endpoint = null != (antvipEndpont = System.getProperty("com.alipay.antvip.endpoint")) && !antvipEndpont.isEmpty() ? antvipEndpont : (null != (envMap = System.getenv()) && StringUtils.isNotBlank(envMap.get("ANTVIP_ENDPOINT")) ? envMap.get("ANTVIP_ENDPOINT") : (StringUtils.startsWith(confregUrl = System.getProperty("com.alipay.confreg.url"), "iconfreg") ? "iantvip-pool" : (StringUtils.startsWith(confregUrl, "zmconfreg") ? "zmantvip-pool" : (StringUtils.startsWith(confregUrl, "confregsession-pool") ? "antvip-pool" : (StringUtils.startsWithIgnoreCase(this.zone, "ZM") ? "zmantvip-pool" : (StringUtils.startsWithIgnoreCase(this.zone, "GZ") || StringUtils.startsWithIgnoreCase(this.zone, "RZ") || StringUtils.startsWithIgnoreCase(this.zone, "CZ") ? "antvip-pool" : (StringUtils.startsWithIgnoreCase(this.zone, "utw") || StringUtils.startsWithIgnoreCase(this.zone, "oc27") || StringUtils.startsWithIgnoreCase(this.zone, "UZ99P") || StringUtils.startsWithIgnoreCase(this.zone, "SG") || StringUtils.startsWithIgnoreCase(this.zone, "US") || StringUtils.startsWithIgnoreCase(this.zone, "ID") || StringUtils.startsWithIgnoreCase(this.zone, "VN") || StringUtils.containsIgnoreCase(this.zone, "GZ") && !StringUtils.startsWithIgnoreCase(this.getZone(), "GZ") ? "iantvip-pool" : "antvip-pool")))))));
    }

    public void initZone() {
        String userHome = this.userHome;
        if (StringUtils.isEmpty(this.zone)) {
            this.zone = System.getProperty("com.alipay.ldc.zone");
            if (StringUtils.isBlank(this.zone)) {
                this.zone = ZoneUtil.getZoneFromEnv();
            }
            if (StringUtils.isBlank(this.zone)) {
                this.zone = ZoneUtil.getZoneFromFile(userHome + "server.conf");
            }
            if (StringUtils.isBlank(this.zone)) {
                this.zone = ZoneUtil.getZoneFromFile(userHome + "conf/server.conf");
            }
        }
        if (StringUtils.isBlank(this.zone)) {
            Loggers.STARTUP.error("Error when initialize AntVipConfig, zone is empty.");
        } else {
            this.zone = StringUtils.lowerCase(this.zone);
        }
    }

    protected void initProperties(String configFileName, String prefix) {
        try {
            InputStream in = AntVipConfigure.class.getClassLoader().getResourceAsStream(configFileName);
            Properties props = new Properties();
            if (in != null) {
                props.load(in);
                in.close();
                props.putAll((Map<?, ?>)System.getProperties());
                Class<?> clazz = this.getClass();
                ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields()));
                while (!clazz.equals(AntVipConfigure.class)) {
                    clazz = clazz.getSuperclass();
                    Collections.addAll(fields, clazz.getDeclaredFields());
                }
                for (Field field : fields) {
                    String value;
                    if (Modifier.isStatic(field.getModifiers()) || (value = props.getProperty(prefix + field.getName())) == null) continue;
                    field.setAccessible(true);
                    if (field.getType().equals(Integer.TYPE)) {
                        field.set(this, Integer.parseInt(value));
                        continue;
                    }
                    if (field.getType().equals(Long.TYPE)) {
                        field.set(this, Long.parseLong(value));
                        continue;
                    }
                    if (field.getType().equals(String.class)) {
                        field.set(this, value);
                        continue;
                    }
                    field.set(this, Boolean.parseBoolean(value));
                }
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Error when initialize AntVipConfig", e);
        }
    }

    public void print() {
        Loggers.CONFIG.info("Print AntVipClient(version:%s) configure values:", this.version);
        Field[] fields = AntVipConfigure.class.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            f.setAccessible(true);
            try {
                Loggers.CONFIG.info(f.getName() + "=" + f.get(this));
                continue;
            }
            catch (Exception e) {
                Loggers.CONFIG.error(e.getMessage(), e);
            }
        }
    }

    public boolean isDiskCacheEnable() {
        return this.diskCacheEnable;
    }

    public long getRequestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    public String getDiskStoreDir() {
        return this.diskStoreDir;
    }

    public void setDiskStoreDir(String diskStoreDir) {
        this.diskStoreDir = diskStoreDir;
    }

    public void setDiskCacheEnable(boolean diskCacheEnable) {
        this.diskCacheEnable = diskCacheEnable;
    }

    public void setRequestTimeoutMs(long requestTimeoutMs) {
        this.requestTimeoutMs = requestTimeoutMs;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getZone() {
        return this.zone;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public String getTrFrom() {
        return this.trFrom;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public DrmControl getDrmControl() {
        return this.drmControl;
    }

    public DrmSyncControl getDrmSyncControl() {
        return this.drmSyncControl;
    }

    public boolean isLocalApiSwitch() {
        return this.localApiSwitch;
    }

    public boolean isPollingNameList() {
        return this.pollingNameList;
    }

    public void setPollingNameList(boolean pollingNameList) {
        this.pollingNameList = pollingNameList;
    }

    public int getLruCacheMaxCapacity() {
        return this.lruCacheMaxCapacity;
    }

    public void setLruCacheMaxCapacity(int lruCacheMaxCapacity) {
        this.lruCacheMaxCapacity = lruCacheMaxCapacity;
    }

    public AntvipClientType getAntvipClientType() {
        return this.antvipClientType;
    }

    public void setAntvipClientType(AntvipClientType antvipClientType) {
        this.antvipClientType = antvipClientType;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public boolean isEndpointEnforce() {
        return this.endpointEnforce;
    }

    public void setEndpointEnforce(boolean endpointEnforce) {
        this.endpointEnforce = endpointEnforce;
    }
}

