/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.com.shade.alipay.antvip.client;

import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.AntVipClient;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.AntVipConfigure;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.AntVipListener;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.ExtensionParamsCache;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.RealServer;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.VipResolvedResult;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.exception.AntVipInitializedException;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.exception.ClientClosedException;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.AntVipContext;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.NameListHolder;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.NoAvailableServerException;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.VipDomainWithWeight;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.locator.ServerLocator;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.locator.WebHostServerLocator;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.log.Loggers;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.statistics.ApiStatistics;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.store.ClientDiskStore;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.store.NoopStore;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.transport.VipServerSynchronizer;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.url.AntVipUrl;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.island.IslandListener;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.exception.AntVipException;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.exception.AntVipIOException;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.exception.DomainNotFoundException;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.listener.VipDomainDeleteListener;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.listener.VipDomainListener;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.listener.VipDomainNameListListener;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.model.VipDomain;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.store.Store;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.thread.AntVipUncaughtExceptionHandler;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.thread.ThreadFactoryBuilder;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.utils.AntVipUtils;
import com.alipay.sofa.sofamq.org.shade.apache.commons.lang.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class DefaultAntVipClient
implements AntVipClient,
VipDomainNameListListener,
VipDomainListener,
VipDomainDeleteListener {
    private final ThreadPoolExecutor clientListenerExecutor;
    private final ThreadPoolExecutor asyncInitDomainExecutor;
    private final Store diskStore;
    protected final ServerLocator vipServerLocator;
    protected final VipServerSynchronizer vipServerSynchronizer;
    private final List<AntVipListener> listeners = new ArrayList<AntVipListener>();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final ApiStatistics apiStatistics;
    private final Thread apiStatisticsThread;
    protected final AntVipContext context;
    private final ExtensionParamsCache extensionParamsCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultAntVipClient(AntVipConfigure config) {
        Loggers.STARTUP.info("================== Init started ==================");
        long startTime = System.currentTimeMillis();
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(DefaultAntVipClient.class.getClassLoader());
            if (null == config) {
                throw new AntVipException("config is null!");
            }
            this.context = new AntVipContext(config);
            this.context.getConfig().print();
            this.apiStatistics = new ApiStatistics();
            ThreadFactoryBuilder threadFactoryBuilder = new ThreadFactoryBuilder();
            threadFactoryBuilder.setDaemon(true);
            threadFactoryBuilder.setUncaughtExceptionHandler(AntVipUncaughtExceptionHandler.INSTANCE);
            this.clientListenerExecutor = new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactoryBuilder.setNameFormat("AntVip-ClientListenerExecutor").build());
            this.asyncInitDomainExecutor = new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactoryBuilder.setNameFormat("AntVip-AsyncInitDomainExecutor").build());
            this.asyncInitDomainExecutor.allowCoreThreadTimeOut(true);
            try {
                this.diskStore = this.context.getConfig().isDiskCacheEnable() ? new ClientDiskStore(this.context.getConfig().getDiskStoreDir()) : new NoopStore();
                this.extensionParamsCache = new ExtensionParamsCache(this.diskStore, this.context.getConfig().getZone());
                this.vipServerLocator = new WebHostServerLocator(this.context, this.diskStore);
                this.vipServerSynchronizer = new VipServerSynchronizer(this.context, this.vipServerLocator, this.extensionParamsCache, this.diskStore);
                if (config.isPollingNameList()) {
                    this.loadNameList();
                }
                this.loadResolvedVipDomains();
            }
            catch (AntVipIOException e) {
                throw new AntVipInitializedException(e.getMessage(), e);
            }
            catch (IOException e) {
                throw new AntVipInitializedException(e.getMessage(), e);
            }
            this.vipServerSynchronizer.addVipDomainListener(this);
            this.vipServerSynchronizer.addVipDomainListener(this.diskStore);
            if (config.isPollingNameList()) {
                this.vipServerSynchronizer.addVipDomainNameListListener(this);
                this.vipServerSynchronizer.addVipDomainNameListListener(this.diskStore);
            } else {
                this.vipServerSynchronizer.addVipDomainDeleteListener(this);
            }
            this.vipServerSynchronizer.start();
            this.apiStatisticsThread = new Thread(){

                @Override
                public void run() {
                    while (!Thread.currentThread().isInterrupted()) {
                        try {
                            Thread.sleep(DefaultAntVipClient.this.context.getConfig().getDrmControl().getPrintStatInfoIntervalSec() * 1000L);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            Loggers.DEFAULT.info("Interrupted in apiStatisticsThread, thread will quit");
                        }
                        DefaultAntVipClient.this.apiStatistics.printAndClearStatInfo();
                    }
                }
            };
            this.apiStatisticsThread.setName("AntVip-ApiStatisticsThread");
            this.apiStatisticsThread.setDaemon(true);
            this.apiStatisticsThread.start();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        }
        Loggers.STARTUP.info("================== Init done (elapsed %sms). ==================", System.currentTimeMillis() - startTime);
    }

    @Override
    public void addIslandListener(IslandListener listener) {
        if (this.isClose()) {
            throw new ClientClosedException();
        }
        if (null == listener) {
            throw new AntVipException("listener should not be null!");
        }
        this.vipServerSynchronizer.registerIslandListener(listener);
    }

    private void loadResolvedVipDomains() throws IOException {
        List<VipDomain> vipDomains = this.diskStore.loadVipDomains();
        if (vipDomains.size() > 0) {
            int count = 0;
            for (int i = 0; i < vipDomains.size(); ++i) {
                VipDomain vipDomain = vipDomains.get(i);
                if (this.context.getConfig().isPollingNameList() && this.context.getNameListHolder().getNameList().size() > 0 && !this.context.getNameListHolder().contains(vipDomain.getName())) {
                    this.diskStore.asyncDeleteVipDomain(vipDomain.getName());
                    continue;
                }
                AntVipUtils.resolveVipDomain(vipDomain);
                VipDomainWithWeight weightedVipDomain = new VipDomainWithWeight(vipDomain, this.context.getConfig().getDrmControl(), this.extensionParamsCache);
                this.context.getResolvedVipDomains().put(vipDomain.getName(), weightedVipDomain);
                ++count;
            }
            Loggers.STARTUP.info("Loaded local VipDomains size is %s", count);
        }
    }

    private void loadNameList() throws IOException, AntVipIOException, NoAvailableServerException {
        List<String> nameList = this.diskStore.loadDomainNameList();
        Loggers.STARTUP.info("Loaded local nameList, size is %s", nameList.size());
        if (nameList.size() <= 0) {
            if (!this.context.getConfig().getDrmControl().isMainSwitch()) {
                Loggers.STARTUP.info("Main switch is off, wont't fetch 'nameList' from server");
                nameList = Collections.emptyList();
            } else {
                try {
                    nameList = this.vipServerSynchronizer.getVipDomainNameList(this.context.getConfig().getRequestTimeoutMs());
                    if (nameList.size() > 0) {
                        this.diskStore.asyncStoreDomainNameList(nameList);
                    }
                }
                catch (AntVipIOException e) {
                    Loggers.STARTUP.error("Error when loading nameList from server, loaded empty nameList", e);
                }
            }
        }
        this.context.setNameListHolder(new NameListHolder(nameList));
    }

    public DefaultAntVipClient() {
        this(new AntVipConfigure());
    }

    @Override
    public List<RealServer> getRealServers(String domainName) throws AntVipIOException, DomainNotFoundException {
        return this.getRealServers(domainName, this.context.getConfig().getRequestTimeoutMs());
    }

    @Override
    public List<RealServer> getRealServers(String domainName, long timeoutMs) throws AntVipIOException, DomainNotFoundException {
        VipDomainWithWeight weightedVipDomain = this._getVipDomain(domainName, timeoutMs);
        return weightedVipDomain.getAvailableRealServers();
    }

    @Override
    public List<RealServer> getHealthRealServers(String domainName) throws AntVipIOException, DomainNotFoundException {
        return this.getHealthRealServers(domainName, this.context.getConfig().getRequestTimeoutMs());
    }

    @Override
    public List<RealServer> getHealthRealServers(String domainName, long timeoutMs) throws AntVipIOException, DomainNotFoundException {
        List<RealServer> realServers = this.getRealServers(domainName, timeoutMs);
        ArrayList<RealServer> healthRSs = new ArrayList<RealServer>();
        for (RealServer rs : realServers) {
            if (!rs.isAvailable()) continue;
            healthRSs.add(rs);
        }
        return healthRSs;
    }

    @Override
    public List<RealServer> getAllRealServers(String domainName) throws AntVipIOException, DomainNotFoundException {
        return this.getAllRealServers(domainName, this.context.getConfig().getRequestTimeoutMs());
    }

    @Override
    public List<RealServer> getAllRealServers(String domainName, long timeoutMs) throws AntVipIOException, DomainNotFoundException {
        VipDomainWithWeight weightedVipDomain = this._getVipDomain(domainName, timeoutMs);
        return weightedVipDomain.getAllRealServers();
    }

    @Override
    public synchronized void addListener(AntVipListener listener) {
        if (this.isClose()) {
            throw new ClientClosedException();
        }
        if (null == listener) {
            throw new AntVipException("listener should not be null!");
        }
        this.listeners.add(listener);
    }

    @Override
    public RealServer getRealServer(String domainName) throws AntVipIOException, DomainNotFoundException {
        return this.getRealServer(domainName, this.context.getConfig().getRequestTimeoutMs());
    }

    @Override
    public RealServer getRealServer(String domainName, long timeoutMs) throws AntVipIOException, DomainNotFoundException {
        VipDomainWithWeight weightedVipDomain = this._getVipDomain(domainName, timeoutMs);
        return weightedVipDomain.getRealServer();
    }

    @Override
    public RealServer getLocalIdcRS(String domainName, boolean allowCrossCity) throws AntVipIOException, DomainNotFoundException {
        return this.getLocalIdcRS(domainName, allowCrossCity, this.context.getConfig().getRequestTimeoutMs());
    }

    @Override
    public RealServer getLocalIdcRS(String domainName, boolean allowCrossCity, long timeoutMs) throws AntVipIOException, DomainNotFoundException {
        return this.getLocalIdcRS(domainName, "", true, allowCrossCity, timeoutMs);
    }

    @Override
    public RealServer getLocalIdcRS(String domainName, String idc, boolean allowCrossCity) throws AntVipIOException, DomainNotFoundException {
        return this.getLocalIdcRS(domainName, idc, true, allowCrossCity, this.context.getConfig().getRequestTimeoutMs());
    }

    @Override
    public RealServer getLocalIdcRS(String domainName, String idc, boolean allowCrossCity, long timeoutMs) throws AntVipIOException, DomainNotFoundException {
        return this.getLocalIdcRS(domainName, idc, true, allowCrossCity, this.context.getConfig().getRequestTimeoutMs());
    }

    @Override
    public RealServer getLocalIdcRS(String domainName, String idc, boolean allowCrossIdc, boolean allowCrossCity) throws AntVipIOException, DomainNotFoundException {
        return this.getLocalIdcRS(domainName, idc, allowCrossIdc, allowCrossCity, this.context.getConfig().getRequestTimeoutMs());
    }

    @Override
    public RealServer getLocalIdcRS(String domainName, String idc, boolean allowCrossIdc, boolean allowCrossCity, long timeoutMs) throws AntVipIOException, DomainNotFoundException {
        if (!this.context.getConfig().isLocalApiSwitch()) {
            throw new DomainNotFoundException(domainName, "Local access APIs not in use.");
        }
        VipDomainWithWeight weightedVipDomain = this._getVipDomain(domainName, timeoutMs);
        if (StringUtils.isBlank(idc)) {
            return weightedVipDomain.getLocalIdcRS(allowCrossIdc, allowCrossCity);
        }
        return weightedVipDomain.getLocalIdcRS(idc, allowCrossIdc, allowCrossCity);
    }

    @Override
    public RealServer getLocalCityRS(String domainName, boolean allowCrossCity) throws AntVipIOException, DomainNotFoundException {
        if (!this.context.getConfig().isLocalApiSwitch()) {
            throw new DomainNotFoundException(domainName, "Local access APIs not in use.");
        }
        VipDomainWithWeight weightedVipDomain = this._getVipDomain(domainName, this.context.getConfig().getRequestTimeoutMs());
        return weightedVipDomain.getLocalCityRS(allowCrossCity);
    }

    private RealServer getRealServerWithRestrain(String domainName, long timeoutMs) throws AntVipIOException, DomainNotFoundException {
        try {
            VipDomainWithWeight weightedVipDomain = this._getVipDomain(domainName, timeoutMs);
            return weightedVipDomain.getRealServerWithRestrain();
        }
        catch (RuntimeException e) {
            Loggers.API.error(e, "RuntimeException on getRealServer(domainName:%s,timeout:%s):" + e.getMessage(), domainName, timeoutMs);
            throw e;
        }
        catch (AntVipIOException e) {
            Loggers.API.error(e, "AntVipIOException on getRealServer(domainName:%s,timeout:%s):" + e.getMessage(), domainName, timeoutMs);
            throw e;
        }
        catch (DomainNotFoundException e) {
            Loggers.API.error(e, "DomainNotFoundException on getRealServer(domainName:%s,timeout:%s):" + e.getMessage(), domainName, timeoutMs);
            throw e;
        }
    }

    @Override
    public void onNameListChanged(List<String> vipDomainNameList) {
        if (this.isClose()) {
            return;
        }
        this.context.setNameListHolder(new NameListHolder(vipDomainNameList));
        Iterator<Map.Entry<String, VipDomainWithWeight>> iterator = this.context.getResolvedVipDomains().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, VipDomainWithWeight> entry = iterator.next();
            String domainName = entry.getKey();
            if (!this.context.getConfig().isPollingNameList() || this.context.getNameListHolder().getNameList().size() <= 0 || this.context.getNameListHolder().contains(domainName)) continue;
            iterator.remove();
            this.diskStore.asyncDeleteVipDomain(domainName);
        }
    }

    @Override
    public void onVipDomainDelete(List<String> deletedDomains) {
        if (this.isClose()) {
            return;
        }
        Iterator<Map.Entry<String, VipDomainWithWeight>> iterator = this.context.getResolvedVipDomains().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, VipDomainWithWeight> entry = iterator.next();
            String domainName = entry.getKey();
            if (!deletedDomains.contains(domainName)) continue;
            iterator.remove();
            this.diskStore.asyncDeleteVipDomain(domainName);
            Long ret = this.context.getNotExistDomains().put(domainName, System.currentTimeMillis());
            if (null != ret) continue;
            Loggers.CACHE.info(DefaultAntVipClient.class, "[NotExistDomains] add domain=%s, for remove vipDomain and care sometime, now=%s", domainName, this.context.getNotExistDomains().getAll());
        }
    }

    @Override
    public void onVipDomainChanged(List<VipDomain> vipDomains) {
        if (this.isClose()) {
            return;
        }
        for (VipDomain vipDomain : vipDomains) {
            Long remove;
            VipDomainWithWeight lastVipDomainWithWeight = this.context.getResolvedVipDomains().get(vipDomain.getName());
            long lastAccessTimeMs = null == lastVipDomainWithWeight ? System.currentTimeMillis() : lastVipDomainWithWeight.getLastAccessTimeMs();
            this.context.getResolvedVipDomains().put(vipDomain.getName(), new VipDomainWithWeight(vipDomain, this.context.getConfig().getDrmControl(), this.extensionParamsCache, lastAccessTimeMs));
            if (this.context.getConfig().isPollingNameList() || null == (remove = (Long)this.context.getNotExistDomains().remove(vipDomain.getName()))) continue;
            Loggers.CACHE.info(DefaultAntVipClient.class, "[NotExistDomains] remove domain=%s, for resolved vipDomain", vipDomain.getName());
        }
        final ArrayList<String> domainNames = new ArrayList<String>(vipDomains.size());
        for (VipDomain vipDomain : vipDomains) {
            domainNames.add(vipDomain.getName());
        }
        this.clientListenerExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                for (AntVipListener listener : DefaultAntVipClient.this.listeners) {
                    ClassLoader tcl = Thread.currentThread().getContextClassLoader();
                    try {
                        Thread.currentThread().setContextClassLoader(listener.getClass().getClassLoader());
                        Loggers.CLIENT_LISTENER.info("Trigger AntvipListener(class:%s)", listener.getClass());
                        listener.onChanged(DefaultAntVipClient.this, domainNames);
                    }
                    catch (Throwable e) {
                        Loggers.CLIENT_LISTENER.error(e, "Error on AntVipListener(class:%s)", listener.getClass());
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(tcl);
                    }
                }
            }
        });
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.vipServerSynchronizer.close();
            this.diskStore.close();
            this.clientListenerExecutor.shutdown();
            this.asyncInitDomainExecutor.shutdown();
            this.apiStatisticsThread.interrupt();
            Loggers.STARTUP.info(DefaultAntVipClient.class, "close.");
        }
    }

    @Override
    public boolean isClose() {
        return this.closed.get();
    }

    @Override
    public boolean exist(String domainName) {
        if (this.isClose()) {
            throw new ClientClosedException();
        }
        if (!this.context.getConfig().getDrmControl().isMainSwitch()) {
            return false;
        }
        if (this.context.getConfig().isPollingNameList()) {
            boolean contains = this.context.getNameListHolder().contains(domainName);
            if (!contains) {
                this.apiStatistics.statNotExist(domainName);
            }
            return contains;
        }
        try {
            VipDomainWithWeight vipDomainWithWeight = this._getVipDomain(domainName, this.context.getConfig().getRequestTimeoutMs());
            return null != vipDomainWithWeight;
        }
        catch (AntVipIOException e) {
            return false;
        }
        catch (DomainNotFoundException e) {
            return false;
        }
    }

    @Override
    public void asyncInit(List<String> domainNames) {
        if (this.isClose()) {
            throw new ClientClosedException();
        }
        if (!this.context.getConfig().getDrmControl().isMainSwitch()) {
            return;
        }
        if (null == domainNames || domainNames.size() == 0) {
            return;
        }
        final ArrayList<String> list = new ArrayList<String>(domainNames);
        this.asyncInitDomainExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    HashSet<String> _domainNames = new HashSet<String>();
                    for (String domainName : list) {
                        if (DefaultAntVipClient.this.context.getResolvedVipDomains().containsKey(domainName)) continue;
                        _domainNames.add(domainName);
                    }
                    if (_domainNames.size() > 0) {
                        List<VipDomain> vipDomains = DefaultAntVipClient.this.vipServerSynchronizer.getVipDomains(_domainNames, DefaultAntVipClient.this.context.getConfig().getRequestTimeoutMs());
                        for (VipDomain vipDomain : vipDomains) {
                            DefaultAntVipClient.this.putIfAbsent(vipDomain);
                        }
                    }
                }
                catch (Throwable e) {
                    Loggers.DEFAULT.error("Error in asyncInit()", e);
                }
            }
        });
    }

    public VipDomainWithWeight _getVipDomain(String domainName, long timeoutMs) throws AntVipIOException, DomainNotFoundException {
        if (this.isClose()) {
            throw new ClientClosedException();
        }
        if (!this.context.getConfig().getDrmControl().isMainSwitch()) {
            throw new DomainNotFoundException(domainName, "Main switch is off");
        }
        if (StringUtils.isBlank(domainName)) {
            throw new DomainNotFoundException("", "domain should not be blank.");
        }
        if (this.context.getConfig().isPollingNameList()) {
            try {
                this.context.getNameListHolder().checkContains(domainName);
            }
            catch (DomainNotFoundException e) {
                this.apiStatistics.statNotExist(domainName);
                throw e;
            }
        } else if (this.context.getNotExistDomains().containsKey(domainName)) {
            this.context.getNotExistDomains().put(domainName, System.currentTimeMillis());
            this.apiStatistics.statNotExist(domainName);
            throw new DomainNotFoundException(domainName, "domain in NotExistCache");
        }
        VipDomainWithWeight weightedVipDomain = this.context.getResolvedVipDomains().get(domainName);
        if (weightedVipDomain == null) {
            try {
                VipDomain vipDomain = this.vipServerSynchronizer.getVipDomain(domainName, timeoutMs);
                weightedVipDomain = this.putIfAbsent(vipDomain);
            }
            catch (AntVipIOException e) {
                Long ret;
                if (!this.context.getConfig().isPollingNameList() && null == (ret = this.context.getNotExistDomains().put(domainName, System.currentTimeMillis()))) {
                    Loggers.CACHE.info(DefaultAntVipClient.class, "[NotExistDomains] add domain=%s, for get vipDomain AntVipIOException, now=%s", domainName, this.context.getNotExistDomains().getAll());
                }
                this.apiStatistics.statFail(domainName);
                throw e;
            }
            catch (DomainNotFoundException e) {
                Long ret;
                if (!this.context.getConfig().isPollingNameList() && null == (ret = this.context.getNotExistDomains().put(domainName, System.currentTimeMillis()))) {
                    Loggers.CACHE.info(DefaultAntVipClient.class, "[NotExistDomains] add domain=%s, for get vipDomain DomainNotFoundException, now=%s", domainName, this.context.getNotExistDomains().getAll());
                }
                this.apiStatistics.statNotExist(domainName);
                throw e;
            }
        }
        this.apiStatistics.statSuccess(domainName);
        weightedVipDomain.setLastAccessTimeMs(System.currentTimeMillis());
        return weightedVipDomain;
    }

    private VipDomainWithWeight putIfAbsent(VipDomain vipDomain) {
        VipDomainWithWeight weightedVipDomain = new VipDomainWithWeight(vipDomain, this.context.getConfig().getDrmControl(), this.extensionParamsCache);
        VipDomainWithWeight exist = this.context.getResolvedVipDomains().putIfAbsent(weightedVipDomain.getVipDomain().getName(), weightedVipDomain);
        if (exist != null) {
            weightedVipDomain = exist;
        } else {
            this.diskStore.asyncStoreVipDomain(weightedVipDomain.getVipDomain());
        }
        return weightedVipDomain;
    }

    @Override
    public VipResolvedResult vipResolved(String url) throws AntVipIOException, DomainNotFoundException {
        return this.vipResolved(url, this.context.getConfig().getRequestTimeoutMs());
    }

    @Override
    public VipResolvedResult vipResolved(String url, long timeoutMs) throws AntVipIOException, DomainNotFoundException {
        try {
            if (StringUtils.isBlank(url)) {
                throw new DomainNotFoundException("", "url should not be blank!");
            }
            VipResolvedResult result = new VipResolvedResult();
            result.setResolved(false);
            result.setResolvedUrl(url);
            AntVipUrl antVipUrl = AntVipUrl.valueOf(url);
            String host = antVipUrl.getHost();
            if (host != null && !host.isEmpty() && this.exist(host)) {
                RealServer realServer = this.getRealServerWithRestrain(host, timeoutMs);
                antVipUrl.setHost(realServer.getIp());
                result.setResolved(true);
                result.setResolvedUrl(antVipUrl.toString());
            }
            return result;
        }
        catch (RuntimeException e) {
            Loggers.API.error(e, "RuntimeException on vipResolved(url:%s,timeout:%s):" + e.getMessage(), url, timeoutMs);
            throw e;
        }
        catch (AntVipIOException e) {
            Loggers.API.error(e, "AntVipIOException on vipResolved(url:%s,timeout:%s):" + e.getMessage(), url, timeoutMs);
            throw e;
        }
        catch (DomainNotFoundException e) {
            Loggers.API.error(e, "DomainNotFoundException on vipResolved(url:%s,timeout:%s):" + e.getMessage(), url, timeoutMs);
            throw e;
        }
    }

    @Override
    public boolean getIsland() {
        return this.vipServerSynchronizer.isIsland();
    }

    @Override
    public boolean getCityIsland() {
        return this.vipServerSynchronizer.isIslandCity();
    }

    public ExtensionParamsCache getExtensionParamsCache() {
        return this.extensionParamsCache;
    }

    @Override
    public List<RealServer> getLocalIdcRSList(String domainName, boolean allowCrossCity) throws AntVipIOException, DomainNotFoundException {
        return this.getLocalIdcRSList(domainName, allowCrossCity, this.context.getConfig().getRequestTimeoutMs());
    }

    @Override
    public List<RealServer> getLocalIdcRSList(String domainName, boolean allowCrossCity, long timeoutMs) throws AntVipIOException, DomainNotFoundException {
        return this.getLocalIdcRSList(domainName, "", true, allowCrossCity, timeoutMs);
    }

    @Override
    public List<RealServer> getLocalIdcRSList(String domainName, String idc, boolean allowCrossCity) throws AntVipIOException, DomainNotFoundException {
        return this.getLocalIdcRSList(domainName, idc, true, allowCrossCity, this.context.getConfig().getRequestTimeoutMs());
    }

    @Override
    public List<RealServer> getLocalIdcRSList(String domainName, String idc, boolean allowCrossCity, long timeoutMs) throws AntVipIOException, DomainNotFoundException {
        return this.getLocalIdcRSList(domainName, idc, true, allowCrossCity, this.context.getConfig().getRequestTimeoutMs());
    }

    @Override
    public List<RealServer> getLocalIdcRSList(String domainName, String idc, boolean allowCrossIdc, boolean allowCrossCity) throws AntVipIOException, DomainNotFoundException {
        return this.getLocalIdcRSList(domainName, idc, allowCrossIdc, allowCrossCity, this.context.getConfig().getRequestTimeoutMs());
    }

    @Override
    public List<RealServer> getLocalIdcRSList(String domainName, String idc, boolean allowCrossIdc, boolean allowCrossCity, long timeoutMs) throws AntVipIOException, DomainNotFoundException {
        if (!this.context.getConfig().isLocalApiSwitch()) {
            throw new DomainNotFoundException(domainName, "Local access APIs not in use.");
        }
        VipDomainWithWeight weightedVipDomain = this._getVipDomain(domainName, timeoutMs);
        if (StringUtils.isBlank(idc)) {
            return weightedVipDomain.getLocalIdcRSList(allowCrossIdc, allowCrossCity);
        }
        return weightedVipDomain.getLocalIdcRSList(idc, allowCrossIdc, allowCrossCity);
    }

    @Override
    public List<RealServer> getLocalCityRSList(String domainName, boolean allowCrossCity) throws AntVipIOException, DomainNotFoundException {
        if (!this.context.getConfig().isLocalApiSwitch()) {
            throw new DomainNotFoundException(domainName, "Local access APIs not in use.");
        }
        VipDomainWithWeight weightedVipDomain = this._getVipDomain(domainName, this.context.getConfig().getRequestTimeoutMs());
        return weightedVipDomain.getLocalCityRSList(allowCrossCity);
    }

    public ApiStatistics getApiStatistics() {
        return this.apiStatistics;
    }
}

