/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.com.shade.alipay.antvip.client;

import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.log.Loggers;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.model.ZoneMeta;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.store.Store;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.utils.ChecksumUtils;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.utils.ZoneMetaUtil;
import com.alipay.sofa.sofamq.org.shade.apache.commons.lang.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExtensionParamsCache {
    private Store diskStore;
    private String localZone;
    private Map<String, ZoneMeta> zoneInfoMap = new HashMap<String, ZoneMeta>();
    private Map<String, ZoneMeta> idcMap = new HashMap<String, ZoneMeta>();
    private String zoneInfoListChecksum = "N";
    private List<String> dnsfilterDomainSuffixWhiteList = new ArrayList<String>();
    private List<String> dnsfilterDomainSuffixBlackList = new ArrayList<String>();
    private String dnsfilterWhiteListChecksum = "N";
    private String dnsfilterBlackListChecksum = "N";
    private List<String> divisionByEnv0Domains = new ArrayList<String>();
    private String divisionByEnv0DomainsChecksum = "N";

    public ExtensionParamsCache(Store store, String zone) {
        try {
            this.localZone = null == zone ? "" : StringUtils.lowerCase(zone);
            this.diskStore = store;
            List<String> zoneInfoList = this.diskStore.loadStringList("zoneInfoList");
            this.dealZoneInfo(zoneInfoList);
            Loggers.STARTUP.info("Loaded local zoneInfoList(%s) from disk, localZone=%s", zoneInfoList, this.localZone);
            List<String> whiteList = this.diskStore.loadStringList("whiteList");
            this.resolveWhiteList(whiteList);
            Loggers.STARTUP.info("Loaded local whiteList(%s) from disk", whiteList);
            List<String> blackList = this.diskStore.loadStringList("blackList");
            this.resolveBlackList(blackList);
            Loggers.STARTUP.info("Loaded local blackList(%s) from disk", blackList);
            List<String> divisionDomains = this.diskStore.loadStringList("divisionByEnv0Domains");
            this.resolveDivisionByEnv0Domains(divisionDomains);
            Loggers.STARTUP.info("Loaded local divisionDomains(%s) from disk", divisionDomains);
            Loggers.STARTUP.info("ExtensionParamsCache inited");
        }
        catch (IOException e) {
            Loggers.STARTUP.warn(ExtensionParamsCache.class, "Load local zoneInfoList failed");
        }
    }

    public void resolveWhiteList(List<String> list) {
        this.dnsfilterDomainSuffixWhiteList = list;
        this.dnsfilterWhiteListChecksum = ChecksumUtils.checksum(list);
        this.diskStore.asyncStoreStringList(list, "whiteList");
        Loggers.CACHE.info(ExtensionParamsCache.class, ">>>>>>>>>>>>>>>>> Receive 'whiteList', %s", list);
    }

    public void resolveBlackList(List<String> list) {
        this.dnsfilterDomainSuffixBlackList = list;
        this.dnsfilterBlackListChecksum = ChecksumUtils.checksum(list);
        this.diskStore.asyncStoreStringList(list, "blackList");
        Loggers.CACHE.info(ExtensionParamsCache.class, ">>>>>>>>>>>>>>>>> Receive 'blackList', %s", list);
    }

    public void resolveDivisionByEnv0Domains(List<String> list) {
        this.divisionByEnv0Domains = list;
        this.divisionByEnv0DomainsChecksum = ChecksumUtils.checksum(list);
        this.diskStore.asyncStoreStringList(list, "divisionByEnv0Domains");
        Loggers.CACHE.info(ExtensionParamsCache.class, ">>>>>>>>>>>>>>>>> Receive 'divisionByEnv0Domains', %s", list);
    }

    public void resolveZoneInfo(List<String> zoneInfoList) {
        this.dealZoneInfo(zoneInfoList);
        if (null != zoneInfoList && zoneInfoList.size() > 0) {
            this.diskStore.asyncStoreStringList(zoneInfoList, "zoneInfoList");
            Loggers.CACHE.info(ExtensionParamsCache.class, ">>>>>>>>>>>>>>>>> Receive 'zoneInfoList', %s", zoneInfoList);
        }
    }

    private void dealZoneInfo(List<String> zoneInfoList) {
        if (null == zoneInfoList || zoneInfoList.size() <= 0) {
            this.zoneInfoListChecksum = "N";
            return;
        }
        this.zoneInfoListChecksum = ChecksumUtils.checksum(zoneInfoList);
        this.zoneInfoMap = ZoneMetaUtil.dealZoneInfos(zoneInfoList);
        for (Map.Entry<String, ZoneMeta> entry : this.zoneInfoMap.entrySet()) {
            ZoneMeta meta = entry.getValue();
            String idc = meta.getIdc();
            if (!StringUtils.isNotBlank(idc)) continue;
            this.idcMap.put(idc, meta);
        }
    }

    public boolean isZoneInfoInitialized() {
        return null != this.zoneInfoMap && this.zoneInfoMap.size() > 0;
    }

    public String getLocalIdc() {
        return this.getIdcByZone(this.localZone);
    }

    public String getLocalCity() {
        return this.getCityByZone(this.localZone);
    }

    public String getIdcByZone(String zone) {
        ZoneMeta zoneMeta = this.zoneInfoMap.get(StringUtils.lowerCase(zone));
        if (null != zoneMeta) {
            return zoneMeta.getIdc();
        }
        return "";
    }

    public String getCityByZone(String zone) {
        ZoneMeta zoneMeta = this.zoneInfoMap.get(StringUtils.lowerCase(zone));
        if (null != zoneMeta) {
            return zoneMeta.getCity();
        }
        return "";
    }

    public String getCityByIdc(String idc) {
        ZoneMeta zoneMeta = this.idcMap.get(StringUtils.lowerCase(idc));
        return null == zoneMeta ? "" : zoneMeta.getCity();
    }

    public boolean isLocalIdc(String idc) {
        return StringUtils.equalsIgnoreCase(idc, this.getLocalIdc());
    }

    public boolean islocalCity(String city) {
        return StringUtils.equalsIgnoreCase(city, this.getLocalCity());
    }

    public String getZoneInfoListChecksum() {
        return this.zoneInfoListChecksum;
    }

    public List<String> getDnsfilterDomainSuffixWhiteList() {
        return this.dnsfilterDomainSuffixWhiteList;
    }

    public List<String> getDnsfilterDomainSuffixBlackList() {
        return this.dnsfilterDomainSuffixBlackList;
    }

    public String getDnsfilterWhiteListChecksum() {
        return this.dnsfilterWhiteListChecksum;
    }

    public String getDnsfilterBlackListChecksum() {
        return this.dnsfilterBlackListChecksum;
    }

    public List<String> getDivisionByEnv0Domains() {
        return this.divisionByEnv0Domains;
    }

    public String getDivisionByEnv0DomainsChecksum() {
        return this.divisionByEnv0DomainsChecksum;
    }
}

