/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal;

import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.RealServer;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.model.RealNode;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class DefaultRealServer
implements RealServer,
Serializable {
    private static final long serialVersionUID = 1025787632037666790L;
    private String ip;
    private int weight = 1;
    private Integer healthCheckPort = -1;
    private boolean available;
    private String zone;
    private String idc;
    private Map<String, String> labels = new HashMap<String, String>();

    public DefaultRealServer(RealNode realNode, String idc) {
        this.ip = realNode.getIp();
        this.weight = realNode.getWeight();
        this.healthCheckPort = realNode.getEffectiveHealthCheckPort();
        this.available = realNode.isAvailable();
        this.zone = realNode.getZone();
        this.idc = idc;
        if (null != realNode.getVipDomain() && null != realNode.getVipDomain().getDomainLabels() && !realNode.getVipDomain().getDomainLabels().isEmpty()) {
            this.labels.putAll(realNode.getVipDomain().getDomainLabels());
        }
        if (null != realNode.getRnLabels() && !realNode.getRnLabels().isEmpty()) {
            this.labels.putAll(realNode.getRnLabels());
        }
    }

    @Override
    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    @Override
    public Integer getHealthCheckPort() {
        return this.healthCheckPort;
    }

    public void setHealthCheckPort(Integer healthCheckPort) {
        this.healthCheckPort = healthCheckPort;
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    @Override
    public String getZone() {
        return this.zone;
    }

    @Override
    public String getIdc() {
        return this.idc;
    }

    public void setIdc(String idc) {
        this.idc = idc;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    @Override
    public Map<String, String> getLabels() {
        return this.labels;
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    public String toString() {
        return "DefaultRealServer [ip=" + this.ip + ", weight=" + this.weight + ", healthCheckPort=" + this.healthCheckPort + ", available=" + this.available + ", zone=" + this.zone + ", idc=" + this.idc + ", labels=" + this.labels + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.available ? 1231 : 1237);
        result = 31 * result + (this.healthCheckPort == null ? 0 : this.healthCheckPort.hashCode());
        result = 31 * result + (this.idc == null ? 0 : this.idc.hashCode());
        result = 31 * result + (this.ip == null ? 0 : this.ip.hashCode());
        result = 31 * result + (this.labels == null ? 0 : this.labels.hashCode());
        result = 31 * result + this.weight;
        result = 31 * result + (this.zone == null ? 0 : this.zone.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultRealServer other = (DefaultRealServer)obj;
        if (this.available != other.available) {
            return false;
        }
        if (this.healthCheckPort == null ? other.healthCheckPort != null : !this.healthCheckPort.equals(other.healthCheckPort)) {
            return false;
        }
        if (this.idc == null ? other.idc != null : !this.idc.equals(other.idc)) {
            return false;
        }
        if (this.ip == null ? other.ip != null : !this.ip.equals(other.ip)) {
            return false;
        }
        if (this.labels == null ? other.labels != null : !this.labels.equals(other.labels)) {
            return false;
        }
        if (this.weight != other.weight) {
            return false;
        }
        return !(this.zone == null ? other.zone != null : !this.zone.equals(other.zone));
    }

    @Override
    public String getLabelValueByKey(String key) {
        return this.labels.get(key);
    }
}

