/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal;

import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.ExtensionParamsCache;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.RealServer;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.exception.AntVipInitializedException;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.DefaultRealServer;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.drm.DrmControl;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.log.Loggers;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.client.internal.restrainstrategy.RestrainStrategy;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.exception.DomainNotFoundException;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.model.RealNode;
import com.alipay.sofa.sofamq.com.shade.alipay.antvip.common.model.VipDomain;
import com.alipay.sofa.sofamq.org.shade.apache.commons.lang.StringUtils;
import com.alipay.sofa.sofamq.org.shade.apache.commons.lang.math.RandomUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class VipDomainWithWeight {
    private static final int RANDOM_SEQ = RandomUtils.nextInt(Short.MAX_VALUE);
    private final VipDomain vipDomain;
    private final ExtensionParamsCache extensionParamsCache;
    private final List<RealServer> weightedAvailableRealServers = new ArrayList<RealServer>();
    private final List<RealServer> weightedAllRealServers = new ArrayList<RealServer>();
    private final List<RealServer> availableRealServers = new ArrayList<RealServer>();
    private final List<RealServer> allRealServers = new ArrayList<RealServer>();
    private ConcurrentHashMap<String, List<RealServer>> idcWeightedAvailableRsMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Integer> idcWeightedCntMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, List<RealServer>> cityWeightedAvailableRsMap = new ConcurrentHashMap();
    private final AtomicLong realServerIndex = new AtomicLong(RandomUtils.nextInt(Short.MAX_VALUE));
    private final int restrainStartAtAvailableList;
    private final int restrainStartAtWeightedAvailableList;
    private final int restrainStartAtAllList;
    private final int restrainStartAtWeightedAllList;
    private final AtomicLong realServerIndexForRestrain = new AtomicLong(RandomUtils.nextInt(Short.MAX_VALUE));
    private final DrmControl drmControl;
    private long lastAccessTimeMs;

    public VipDomainWithWeight(VipDomain vipDomain, DrmControl drmControl, ExtensionParamsCache extensionParamsCache) {
        this(vipDomain, drmControl, extensionParamsCache, System.currentTimeMillis());
    }

    public VipDomainWithWeight(VipDomain vipDomain, DrmControl drmControl, ExtensionParamsCache extensionParamsCache, long lastAccessTimeMs) {
        this.vipDomain = vipDomain;
        this.drmControl = drmControl;
        this.extensionParamsCache = extensionParamsCache;
        this.buildWeightedRealServers(vipDomain);
        this.restrainStartAtAvailableList = RANDOM_SEQ % this.availableRealServers.size();
        this.restrainStartAtWeightedAvailableList = this.calRealServerWeightTotalSum(this.availableRealServers, 0, this.restrainStartAtAvailableList);
        this.restrainStartAtAllList = RANDOM_SEQ % this.allRealServers.size();
        this.restrainStartAtWeightedAllList = this.calRealServerWeightTotalSum(this.allRealServers, 0, this.restrainStartAtAllList);
        this.lastAccessTimeMs = lastAccessTimeMs;
    }

    public boolean expired() {
        return System.currentTimeMillis() - this.lastAccessTimeMs > this.drmControl.getVipDomainExpireTimeMs();
    }

    private int calRealServerWeightTotalSum(List<RealServer> list, int start, int len) {
        int weightTotal = 0;
        int size = list.size();
        for (int i = 0; i < len; ++i) {
            weightTotal += list.get((start + i) % size).getWeight();
        }
        return weightTotal;
    }

    private String getAppNameFromDomainName(String name) {
        String appName;
        int index = StringUtils.indexOf(name, "-pool.");
        if (index != -1 && StringUtils.isNotBlank(appName = StringUtils.substring(name, 0, index))) {
            return appName;
        }
        return null;
    }

    private List<RealServer> buildWeightedRealServers(VipDomain vipDomain) {
        List<RealNode> realNodes = vipDomain.getRealNodes();
        ArrayList<RealServer> realServers = new ArrayList<RealServer>(realNodes.size());
        for (RealNode realNode : realNodes) {
            DefaultRealServer realServer = new DefaultRealServer(realNode, this.extensionParamsCache.getIdcByZone(realNode.getZone()));
            realServers.add(realServer);
        }
        int totalCount = realNodes.size();
        int availableCount = 0;
        for (RealServer realServer : realServers) {
            if (realServer.isAvailable()) {
                ++availableCount;
                this.addWithWeightRepetition(this.weightedAvailableRealServers, realServer);
                this.availableRealServers.add(realServer);
            }
            this.addWithWeightRepetition(this.weightedAllRealServers, realServer);
            this.allRealServers.add(realServer);
        }
        int protectThreshold = vipDomain.getProtectThreshold();
        if (protectThreshold > 0) {
            int leastAvailableCount = (int)Math.ceil((double)(totalCount * protectThreshold) / 100.0);
            int n = leastAvailableCount = leastAvailableCount <= 0 ? 1 : leastAvailableCount;
            if (availableCount < leastAvailableCount) {
                List<RealServer> unavailableNodes = this.getUnavailableList(realServers, leastAvailableCount - availableCount);
                for (RealServer realServer : unavailableNodes) {
                    this.addWithWeightRepetition(this.weightedAvailableRealServers, realServer);
                    this.availableRealServers.add(realServer);
                }
                Loggers.API.warn("domain=%s protectThreshold=%s ipCount=%s, availableCount[%s] < leastAvailableCount[%s], may return some unavailable ips=%s", vipDomain.getName(), protectThreshold, totalCount, availableCount, leastAvailableCount, unavailableNodes);
            }
        } else if (availableCount <= 0) {
            Loggers.API.warn("domain=%s protectThreshold=%s realserverCount=%s, availableCount[0], will return any unavailable ip.", vipDomain.getName(), protectThreshold, totalCount);
            for (RealServer realServer : realServers) {
                this.addWithWeightRepetition(this.weightedAvailableRealServers, realServer);
                this.availableRealServers.add(realServer);
            }
        }
        return this.weightedAvailableRealServers;
    }

    private void addWithWeightRepetition(List<RealServer> weightedRealServers, RealServer realServer) {
        int weight = realServer.getWeight();
        for (int i = 0; i < weight; ++i) {
            weightedRealServers.add(realServer);
        }
    }

    private List<RealServer> getUnavailableList(List<RealServer> realServers, int count) {
        ArrayList<RealServer> list = new ArrayList<RealServer>(count);
        for (RealServer realServer : realServers) {
            if (!realServer.isAvailable()) {
                list.add(realServer);
            }
            if (list.size() < count) continue;
            break;
        }
        return list;
    }

    public RealServer getRealServer() {
        List<RealServer> list = this.drmControl.isAllAvailable() ? this.weightedAllRealServers : this.weightedAvailableRealServers;
        RealServer realServer = list.get((int)(this.realServerIndex.getAndIncrement() % (long)list.size()));
        if (!realServer.isAvailable()) {
            Loggers.API.warn("domain=%s protectThreshold=%s, return an unavailble realserver[%s]", this.vipDomain.getName(), this.vipDomain.getProtectThreshold(), realServer);
        }
        return realServer;
    }

    public RealServer getLocalIdcRS(boolean allowCrossIdc, boolean allowCrossCity) throws DomainNotFoundException {
        String localIdc = this.extensionParamsCache.getLocalIdc();
        return this.getLocalIdcRS(localIdc, allowCrossIdc, allowCrossCity);
    }

    public RealServer getLocalIdcRS(String idc, boolean allowCrossIdc, boolean allowCrossCity) throws DomainNotFoundException {
        List<RealServer> list = this.getLocalIdcRSList(idc, allowCrossIdc, allowCrossCity);
        return list.get(RandomUtils.nextInt(list.size()));
    }

    public List<RealServer> getLocalIdcRSList(boolean allowCrossIdc, boolean allowCrossCity) throws DomainNotFoundException {
        String localIdc = this.extensionParamsCache.getLocalIdc();
        return this.getLocalIdcRSList(localIdc, allowCrossIdc, allowCrossCity);
    }

    public List<RealServer> getLocalIdcRSList(String idc, boolean allowCrossIdc, boolean allowCrossCity) throws DomainNotFoundException {
        double availablePecent;
        Integer value;
        if (!this.extensionParamsCache.isZoneInfoInitialized()) {
            throw new AntVipInitializedException("Zone-idc-city info is not initialized!");
        }
        if (null == idc) {
            throw new DomainNotFoundException("idc shoud not be null.");
        }
        String city = this.extensionParamsCache.getCityByIdc(idc);
        List<RealServer> list = this.idcWeightedAvailableRsMap.get(idc);
        if (null == list) {
            Loggers.API.warn(String.format("Domain=%s begin build realserver map in idc=%s as local idc.", this.vipDomain.getName(), idc));
            list = this.buildLocalLdcRsMap(idc, city);
        }
        int idcAllCnt = null == (value = this.idcWeightedCntMap.get(idc)) ? 0 : value;
        double d = availablePecent = idcAllCnt <= 0 ? 0.0 : 100.0 * (double)list.size() / (double)idcAllCnt;
        if (list.size() > 0) {
            if (!allowCrossIdc) {
                return list;
            }
            if (availablePecent >= (double)this.vipDomain.getIdcDisasterProtect()) {
                return list;
            }
            Loggers.API.warn(String.format("Available pecent is lower than idcProtectProtect, domain=%s ,available_cnt=%s, all_rs_cnt=%s, idc=%s", this.vipDomain.getName(), list.size(), idcAllCnt, idc));
            return this.getLocalCityRSList(city, allowCrossCity);
        }
        if (allowCrossIdc) {
            return this.getLocalCityRSList(city, allowCrossCity);
        }
        String errorMsg = String.format("Domain=%s, not found realserver in target idc=%s, allowCrossIdc=%s.", this.vipDomain.getName(), idc, allowCrossCity);
        Loggers.API.warn(errorMsg);
        throw new DomainNotFoundException(this.vipDomain.getName(), errorMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RealServer> buildLocalLdcRsMap(String idc, String city) {
        ArrayList<RealServer> list = new ArrayList<RealServer>();
        ArrayList<RealServer> cityList = new ArrayList<RealServer>();
        int idcWeightCnt = 0;
        for (RealServer realServer : this.allRealServers) {
            String rsIdc = this.extensionParamsCache.getIdcByZone(realServer.getZone());
            String rsCity = this.extensionParamsCache.getCityByZone(realServer.getZone());
            if (StringUtils.equalsIgnoreCase(idc, rsIdc)) {
                idcWeightCnt += realServer.getWeight();
            }
            if (!realServer.isAvailable()) continue;
            if (StringUtils.equalsIgnoreCase(idc, rsIdc)) {
                this.addWithWeightRepetition(list, realServer);
                this.addWithWeightRepetition(cityList, realServer);
                continue;
            }
            if (!StringUtils.equalsIgnoreCase(city, rsCity)) continue;
            this.addWithWeightRepetition(cityList, realServer);
        }
        VipDomainWithWeight vipDomainWithWeight = this;
        synchronized (vipDomainWithWeight) {
            this.idcWeightedAvailableRsMap.put(idc, list);
            this.idcWeightedCntMap.put(idc, idcWeightCnt);
            this.cityWeightedAvailableRsMap.put(city, cityList);
        }
        return list;
    }

    public synchronized void refreshLocalRsMap() {
        if (!(null != this.idcWeightedAvailableRsMap && !this.idcWeightedAvailableRsMap.isEmpty() || null != this.idcWeightedCntMap && !this.idcWeightedCntMap.isEmpty() || null != this.cityWeightedAvailableRsMap && !this.cityWeightedAvailableRsMap.isEmpty())) {
            return;
        }
        this.idcWeightedAvailableRsMap = new ConcurrentHashMap();
        this.idcWeightedCntMap = new ConcurrentHashMap();
        this.cityWeightedAvailableRsMap = new ConcurrentHashMap();
    }

    public RealServer getLocalCityRS(String city, boolean allowCrossCity) throws DomainNotFoundException {
        List<RealServer> list = this.getLocalCityRSList(city, allowCrossCity);
        return list.get(RandomUtils.nextInt(list.size()));
    }

    public RealServer getLocalCityRS(boolean allowCrossCity) throws DomainNotFoundException {
        String localCity = this.extensionParamsCache.getLocalCity();
        return this.getLocalCityRS(localCity, allowCrossCity);
    }

    public List<RealServer> getLocalCityRSList(boolean allowCrossCity) throws DomainNotFoundException {
        String localCity = this.extensionParamsCache.getLocalCity();
        return this.getLocalCityRSList(localCity, allowCrossCity);
    }

    public List<RealServer> getLocalCityRSList(String city, boolean allowCrossCity) throws DomainNotFoundException {
        if (!this.extensionParamsCache.isZoneInfoInitialized()) {
            throw new AntVipInitializedException("Local zone is not initialized! Plz check '~/server.conf' or config file.");
        }
        if (null == city) {
            throw new DomainNotFoundException("city shoud not bu null.");
        }
        List<RealServer> list = this.cityWeightedAvailableRsMap.get(city);
        if (null == list) {
            Loggers.API.warn(String.format("Domain=%s begin build realserver map in city=%s as local city.", this.vipDomain.getName(), city));
            list = new ArrayList<RealServer>();
            for (RealServer realServer : this.allRealServers) {
                String rsCity;
                if (!realServer.isAvailable() || !StringUtils.equalsIgnoreCase(rsCity = this.extensionParamsCache.getCityByZone(realServer.getZone()), city)) continue;
                this.addWithWeightRepetition(list, realServer);
            }
            this.cityWeightedAvailableRsMap.put(city, list);
        }
        if (list.size() > 0) {
            return list;
        }
        if (allowCrossCity) {
            return this.drmControl.isAllAvailable() ? this.weightedAllRealServers : this.weightedAvailableRealServers;
        }
        String errorMsg = String.format("Domain=%s, not found realservers in target city=%s", this.vipDomain.getName(), city);
        Loggers.API.warn(errorMsg);
        throw new DomainNotFoundException(this.vipDomain.getName(), errorMsg);
    }

    public RealServer getRealServerWithRestrain() {
        boolean allAvailable = this.drmControl.isAllAvailable();
        List<RealServer> list = allAvailable ? this.allRealServers : this.availableRealServers;
        List<RealServer> weightedList = allAvailable ? this.weightedAllRealServers : this.weightedAvailableRealServers;
        int index = -1;
        if (this.drmControl.isRestrainEnable()) {
            HashMap<String, RestrainStrategy> restrainStrategies = this.drmControl.getRestrainStrategies();
            String appName = this.getAppNameFromDomainName(this.vipDomain.getName());
            if (appName != null) {
                RestrainStrategy restrainStrategy = restrainStrategies.get(appName);
                if (restrainStrategy == null) {
                    restrainStrategy = restrainStrategies.get("*");
                }
                if (restrainStrategy != null) {
                    int restrainSize = restrainStrategy.getRestrainedSize(list.size());
                    int start = allAvailable ? this.restrainStartAtAllList : this.restrainStartAtAvailableList;
                    int weightStart = allAvailable ? this.restrainStartAtWeightedAllList : this.restrainStartAtWeightedAvailableList;
                    int weightTotalSum = this.calRealServerWeightTotalSum(list, start, restrainSize);
                    index = (weightStart + (int)(this.realServerIndexForRestrain.getAndIncrement() % (long)weightTotalSum)) % weightedList.size();
                }
            }
        }
        if (index == -1) {
            index = (int)(this.realServerIndexForRestrain.getAndIncrement() % (long)weightedList.size());
        }
        return weightedList.get(index);
    }

    public VipDomain getVipDomain() {
        return this.vipDomain;
    }

    public List<RealServer> getAvailableRealServers() {
        return this.drmControl.isAllAvailable() ? this.allRealServers : this.availableRealServers;
    }

    public List<RealServer> getAllRealServers() {
        return this.allRealServers;
    }

    public void setLastAccessTimeMs(long lastAccessTimeMs) {
        this.lastAccessTimeMs = lastAccessTimeMs;
    }

    public long getLastAccessTimeMs() {
        return this.lastAccessTimeMs;
    }
}

